/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.PT;
import jspecview.common.Spectrum;

public class PeakInfo {
    public static final PeakInfo nullPeakInfo = new PeakInfo();
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private int px0;
    private int px1;
    private String stringInfo;
    private String type;
    private String type2;
    private String index;
    private String file;
    private String filePathForwardSlash;
    private String title;
    private String model;
    private String atoms;
    private String id;
    public Spectrum spectrum;
    private String _match;
    private String atomKey;

    public PeakInfo() {
    }

    public PeakInfo(String string) {
        this.stringInfo = string;
        this.type = PT.getQuotedAttribute(string, "type");
        if (this.type == null) {
            this.type = "";
        }
        this.type = this.type.toUpperCase();
        int n = this.type.indexOf(47);
        this.type2 = n < 0 ? "" : PeakInfo.fixType(this.type.substring(this.type.indexOf(47) + 1));
        this.type = n >= 0 ? PeakInfo.fixType(this.type.substring(0, n)) + "/" + this.type2 : PeakInfo.fixType(this.type);
        this.id = PT.getQuotedAttribute(string, "id");
        this.index = PT.getQuotedAttribute(string, "index");
        this.file = PT.getQuotedAttribute(string, "file");
        System.out.println("pi file=" + this.file);
        this.filePathForwardSlash = this.file == null ? null : this.file.replace('\\', '/');
        this.model = PT.getQuotedAttribute(string, "model");
        boolean bl = string.contains("baseModel=\"\"");
        if (!bl) {
            this.atoms = PT.getQuotedAttribute(string, "atoms");
        }
        this.atomKey = "," + this.atoms + ",";
        this.title = PT.getQuotedAttribute(string, "title");
        this._match = PT.getQuotedAttribute(string, "_match");
        this.xMax = PT.parseFloat(PT.getQuotedAttribute(string, "xMax"));
        this.xMin = PT.parseFloat(PT.getQuotedAttribute(string, "xMin"));
        this.yMax = PT.parseFloat(PT.getQuotedAttribute(string, "yMax"));
        this.yMin = PT.parseFloat(PT.getQuotedAttribute(string, "yMin"));
    }

    public boolean isClearAll() {
        return this.spectrum == null;
    }

    public String getType() {
        return this.type;
    }

    public String getAtoms() {
        return this.atoms;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getX() {
        return (this.xMax + this.xMin) / 2.0;
    }

    public String getMatch() {
        return this._match;
    }

    private static String fixType(String string) {
        return string.equals("HNMR") ? "1HNMR" : (string.equals("CNMR") ? "13CNMR" : string);
    }

    public String toString() {
        return this.stringInfo;
    }

    public String getIndex() {
        return this.index;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean checkFileIndex(String string, String string2, String string3) {
        return string3 != null ? this.atomKey.indexOf(string3) >= 0 : string2.equals(this.index) && (string.equals(this.file) || string.equals(this.filePathForwardSlash));
    }

    public boolean checkFileTypeModel(String string, String string2, String string3) {
        return string.equals(this.file) && this.checkModel(string3) && this.type.endsWith(string2);
    }

    public boolean checkTypeModel(String string, String string2) {
        return this.checkType(string) && this.checkModel(string2);
    }

    private boolean checkModel(String string) {
        return string != null && string.equals(this.model);
    }

    private boolean checkType(String string) {
        return string.endsWith(this.type);
    }

    public boolean checkTypeMatch(PeakInfo peakInfo) {
        return this.checkType(peakInfo.type) && (this.checkId(peakInfo._match) || this.checkModel(peakInfo._match) || this.title.toUpperCase().indexOf(peakInfo._match) >= 0);
    }

    private boolean checkId(String string) {
        if (string == null) {
            return false;
        }
        return this.id != null && string.toUpperCase().startsWith("ID=") && string.substring(3).equals(this.id) || (string = string.toUpperCase()).startsWith("INDEX=") && string.equals("INDEX=" + this.index) || string.startsWith("#=") && string.equals("#=" + this.index);
    }

    public String getModel() {
        return this.model;
    }

    public String getFilePath() {
        return this.file;
    }

    public boolean autoSelectOnLoad() {
        return this.type.startsWith("GC");
    }

    public void setPixelRange(int n, int n2) {
        this.px0 = n;
        this.px1 = n2;
    }

    public double checkRange(int n, double d) {
        if (n != Integer.MAX_VALUE ? this.px0 <= n && this.px1 >= n : d >= this.xMin && d <= this.xMax) {
            return Math.abs(d - this.getX());
        }
        return 1.0E100;
    }

    public int getXPixel() {
        return (this.px0 + this.px1) / 2;
    }
}

