/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMeasure;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

public class SmilesParser {
    private Map<Integer, SmilesBond> connections = new Hashtable<Integer, SmilesBond>();
    private Map<String, SmilesMeasure> htMeasures = new Hashtable<String, SmilesMeasure>();
    private int flags;
    private boolean isSmarts;
    private boolean isBioSequence;
    private char bioType = '\u0000';
    private int braceCount;
    private int branchLevel;
    private int componentCount;
    private int componentParenCount;
    private boolean ignoreStereochemistry;
    private boolean bondDirectionPaired = true;
    private boolean isTarget;

    static SmilesSearch newSearch(String pattern, boolean isSmarts, boolean isTarget) throws InvalidSmilesException {
        return new SmilesParser(isSmarts, isTarget).parse(pattern);
    }

    SmilesParser(boolean isSmarts, boolean isTarget) {
        this.isSmarts = isSmarts;
        this.isTarget = isTarget;
    }

    SmilesSearch parse(String pattern) throws InvalidSmilesException {
        if (pattern == null) {
            throw new InvalidSmilesException("expression must not be null");
        }
        SmilesSearch search = new SmilesSearch();
        if (pattern.indexOf("$(select") >= 0) {
            pattern = this.parseNested(search, pattern, "select");
        }
        int[] ret = new int[1];
        pattern = SmilesParser.extractFlags(pattern, ret);
        this.flags = ret[0];
        this.ignoreStereochemistry = (this.flags & 0x20) == 32;
        search.setFlags(this.flags);
        if (pattern.indexOf("$") >= 0) {
            pattern = this.parseVariables(pattern);
        }
        if (this.isSmarts && pattern.indexOf("[$") >= 0) {
            pattern = this.parseVariableLength(pattern);
        }
        if (pattern.indexOf("||") < 0) {
            return this.getSubsearch(search, pattern, this.flags);
        }
        String[] patterns = PT.split((String)pattern, (String)"||");
        String toDo = "";
        search.subSearches = new SmilesSearch[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            String key = "|" + patterns[i] + "|";
            if (toDo.indexOf(key) >= 0) continue;
            search.subSearches[i] = this.getSubsearch(search, patterns[i], this.flags);
            toDo = toDo + key;
        }
        return search;
    }

    private String parseVariableLength(String pattern) throws InvalidSmilesException {
        SB sout = new SB();
        int len = pattern.length() - 1;
        int nParen = 0;
        boolean haveInternalOr = false;
        block11: for (int i = 0; i < len; ++i) {
            switch (pattern.charAt(i)) {
                case '(': {
                    ++nParen;
                    continue block11;
                }
                case ')': {
                    --nParen;
                    continue block11;
                }
                case '|': {
                    if (nParen <= 0) continue block11;
                    haveInternalOr = true;
                    if (pattern.charAt(i + 1) != '|') continue block11;
                    pattern = pattern.substring(0, i) + pattern.substring(i + 1);
                    --len;
                }
            }
        }
        if (pattern.indexOf("||") >= 0) {
            String[] patterns = PT.split((String)pattern, (String)"||");
            for (int i = 0; i < patterns.length; ++i) {
                sout.append("||").append(this.parseVariableLength(patterns[i]));
            }
        } else {
            int pt = -1;
            int[] ret = new int[1];
            boolean isOK = true;
            String bracketed = null;
            while ((pt = pattern.indexOf("[$", pt + 1)) >= 0) {
                int pt0 = pt;
                int min = Integer.MIN_VALUE;
                int max = Integer.MIN_VALUE;
                pt = SmilesParser.getDigits(pattern, pt + 2, ret);
                min = ret[0];
                if (min != Integer.MIN_VALUE && SmilesParser.getChar(pattern, pt) == '-') {
                    pt = SmilesParser.getDigits(pattern, pt + 1, ret);
                    max = ret[0];
                }
                if (SmilesParser.getChar(pattern, pt) != '(' || !(bracketed = SmilesParser.getSubPattern(pattern, pt0, '[')).endsWith(")")) continue;
                int pt1 = pt0 + bracketed.length() + 2;
                String repeat = SmilesParser.getSubPattern(pattern, pt, '(');
                int pt2 = pt;
                bracketed = SmilesParser.getSubPattern(pattern, pt, '[');
                pt += 1 + repeat.length();
                if (repeat.indexOf(58) >= 0 && repeat.indexOf(124) < 0) {
                    int parenCount = 0;
                    int n = repeat.length();
                    int ptColon = -1;
                    block14: for (int i = 0; i < n; ++i) {
                        switch (repeat.charAt(i)) {
                            case '(': 
                            case '[': {
                                ++parenCount;
                                continue block14;
                            }
                            case ')': 
                            case ']': {
                                --parenCount;
                                continue block14;
                            }
                            case '.': {
                                if (ptColon < 0 || parenCount != 0) continue block14;
                                n = i;
                                continue block14;
                            }
                            case ':': {
                                if (ptColon >= 0 || parenCount != 0) continue block14;
                                ptColon = i;
                            }
                        }
                    }
                    if (ptColon > 0) {
                        repeat = repeat.substring(0, ptColon) + "(" + repeat.substring(ptColon, n) + ")" + repeat.substring(n);
                    }
                }
                if (min == Integer.MIN_VALUE) {
                    int ptOr = repeat.indexOf("|");
                    if (ptOr < 0) continue;
                    return this.parseVariableLength(pattern.substring(0, pt0) + "[$1" + pattern.substring(pt2, pt2 + ptOr + 1) + ")]" + pattern.substring(pt1) + "||" + pattern.substring(0, pt0) + "[$1(" + pattern.substring(pt2 + ptOr + 2) + pattern.substring(pt1));
                }
                if (max == Integer.MIN_VALUE) {
                    max = min;
                }
                if (repeat.indexOf("|") >= 0) {
                    repeat = "[$(" + repeat + ")]";
                }
                for (int i = min; i <= max; ++i) {
                    SB sb = new SB();
                    sb.append("||").append(pattern.substring(0, pt0));
                    for (int j = 0; j < i; ++j) {
                        sb.append(repeat);
                    }
                    sb.append(pattern.substring(pt1));
                    sout.appendSB(sb);
                }
            }
            if (!isOK) {
                throw new InvalidSmilesException("bad variable expression: " + bracketed);
            }
        }
        return haveInternalOr ? this.parseVariableLength(sout.substring(2)) : (sout.length() < 2 ? pattern : sout.substring(2));
    }

    SmilesSearch getSubsearch(SmilesSearch parent, String pattern, int flags) throws InvalidSmilesException {
        this.htMeasures = new Hashtable<String, SmilesMeasure>();
        SmilesSearch search = new SmilesSearch();
        search.setTop(parent);
        search.isSmarts = this.isSmarts;
        search.pattern = pattern;
        search.setFlags(flags);
        if (pattern.indexOf("$(") >= 0) {
            pattern = this.parseNested(search, pattern, "");
        }
        this.parseSmiles(search, pattern, null, false);
        if (this.braceCount != 0) {
            throw new InvalidSmilesException("unmatched '{'");
        }
        if (!this.connections.isEmpty()) {
            throw new InvalidSmilesException("Open connection");
        }
        search.set();
        if (this.isSmarts) {
            int i = search.ac;
            while (--i >= 0) {
                this.checkNested(search, search.patternAtoms[i], flags);
            }
        } else if (!this.isBioSequence) {
            search.elementCounts[1] = search.getMissingHydrogenCount();
        }
        if (!this.ignoreStereochemistry && !this.isTarget) {
            this.fixChirality(search);
        }
        return search;
    }

    private void checkNested(SmilesSearch search, SmilesAtom atom, int flags) throws InvalidSmilesException {
        Object o;
        if (atom.iNested > 0 && (o = search.getNested(atom.iNested)) instanceof String) {
            String s = (String)o;
            if (s.startsWith("select")) {
                return;
            }
            if (s.charAt(0) != '~' && atom.bioType != '\u0000') {
                s = "~" + atom.bioType + "~" + s;
            }
            SmilesSearch nested = this.getSubsearch(search, s, flags);
            if (nested.ac > 0 && nested.patternAtoms[0].selected) {
                atom.selected = true;
            }
            search.setNested(atom.iNested, (Object)nested);
        }
        for (int i = 0; i < atom.nSubAtoms; ++i) {
            this.checkNested(search, atom.subAtoms[i], flags);
        }
    }

    private void fixChirality(SmilesSearch search) throws InvalidSmilesException {
        int i = search.ac;
        while (--i >= 0) {
            SmilesAtom sAtom = search.patternAtoms[i];
            if (sAtom.stereo == null) continue;
            sAtom.stereo.fixStereo(sAtom);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseSmiles(SmilesSearch search, String pattern, SmilesAtom currentAtom, boolean isBranchAtom) throws InvalidSmilesException {
        ret = new int[1];
        pt = 0;
        bond = null;
        wasMeasure = false;
        wasBranch = false;
        block16: while (pattern != null && pattern.length() != 0) {
            block47: {
                index = 0;
                if (currentAtom == null) {
                    index = this.checkBioType(pattern, 0);
                    if (index == pattern.length()) {
                        pattern = pattern + "*";
                    }
                    if (this.isBioSequence) {
                        search.top.needAromatic = false;
                        search.needAromatic = false;
                    }
                }
                if (haveOpen = this.checkBrace(search, ch = SmilesParser.getChar(pattern, index), '{')) {
                    ch = SmilesParser.getChar(pattern, ++index);
                }
                if (ch == '(') {
                    subString = SmilesParser.getSubPattern(pattern, index, '(');
                    v0 = isMeasure = SmilesParser.getChar(pattern, index + 1) == '.';
                    if (currentAtom == null) {
                        if (isMeasure || !this.isSmarts) {
                            throw new InvalidSmilesException("No previous atom for measure");
                        }
                        search.haveComponents = true;
                        do {
                            ++this.componentCount;
                            ++this.componentParenCount;
                        } while ((ch = SmilesParser.getChar(pattern = pattern.substring(1), 0)) == '(');
                        if (!haveOpen && (haveOpen = this.checkBrace(search, ch, '{'))) {
                            pattern = pattern.substring(1);
                            ch = SmilesParser.getChar(pattern, 0);
                        }
                    } else {
                        wasBranch = false;
                        wasMeasure = false;
                        if (subString.startsWith(".")) {
                            this.parseMeasure(search, subString.substring(1), currentAtom);
                            wasMeasure = true;
                        } else if (subString.length() == 0 && this.isBioSequence) {
                            currentAtom.notCrossLinked = true;
                        } else {
                            ++this.branchLevel;
                            this.parseSmiles(search, subString, currentAtom, true);
                            wasBranch = true;
                            --this.branchLevel;
                        }
                        index = subString.length() + 2;
                        ch = SmilesParser.getChar(pattern, index);
                        if (ch == '}' && this.checkBrace(search, ch, '}')) {
                            ++index;
                        }
                        ch = '\u0000';
                    }
                }
                if (ch == '\u0000') break block47;
                pt = index;
                block18: while (ch != '\u0000') {
                    switch (SmilesBond.isBondType(ch, this.isSmarts, this.isBioSequence)) {
                        case 1: {
                            ** GOTO lbl61
                        }
                        case 0: {
                            break block18;
                        }
                        case -1: {
                            if ((!PT.isDigit((char)SmilesParser.getChar(pattern, ++index)) || index++ <= 0 || PT.isDigit((char)SmilesParser.getChar(pattern, index++))) && (ch = SmilesParser.getChar(pattern, index)) == '-') continue block18;
                            throw new InvalidSmilesException("malformed atropisomerism bond ^nn-  or ^^nn-");
                        }
lbl61:
                        // 2 sources

                        default: {
                            ch = SmilesParser.getChar(pattern, ++index);
                            continue block18;
                        }
                    }
                }
                if ((ch = SmilesParser.getChar(pattern, index)) == ')') {
                    ch = SmilesParser.getChar(pattern, ++index);
                    switch (ch) {
                        case '\u0000': 
                        case ')': 
                        case '.': {
                            pattern = pattern.substring(index);
                            --this.componentParenCount;
                            if (this.componentParenCount < 0) break;
                            continue block16;
                        }
                    }
                    throw new InvalidSmilesException("invalid continuation after component grouping (SMARTS).(SMARTS)");
                }
                bond = this.parseBond(search, null, pattern.substring(pt, index), null, currentAtom, false, isBranchAtom, index - pt, ret);
                if (haveOpen && bond.order != -1) {
                    index = pt;
                    ch = SmilesParser.getChar(pattern, index);
                }
                if (this.checkBrace(search, ch, '{')) {
                    ch = SmilesParser.getChar(pattern, ++index);
                }
                switch (ch) {
                    case '~': {
                        if (bond.order != 0 || (index = this.checkBioType(pattern, index)) != pattern.length()) break;
                        pattern = pattern + "*";
                        break;
                    }
                    case '(': {
                        do {
                            ++this.componentCount;
                            ++this.componentParenCount;
                        } while ((ch = SmilesParser.getChar(pattern, ++index)) == '(');
                        break;
                    }
                    case '\u0000': {
                        if (bond.order != 0) break;
                        return;
                    }
                }
                isConnect = PT.isDigit((char)ch) != false || ch == '%';
                v1 = isAtom = isConnect == false && (ch == '_' || ch == '[' || ch == '*' || PT.isLetter((char)ch) != false);
                if (isConnect) {
                    if (wasMeasure || wasBranch) {
                        throw new InvalidSmilesException("connection number must immediately follow its connecting atom");
                    }
                    index = SmilesParser.getRingNumber(pattern, index, ch, ret);
                    ringNumber = ret[0];
                    this.parseConnection(search, ringNumber, currentAtom, bond);
                    bond = null;
                } else if (isAtom) {
                    wasBranch = false;
                    wasMeasure = false;
                    switch (ch) {
                        case '[': 
                        case '_': {
                            subPattern = SmilesParser.getSubPattern(pattern, index, ch);
                            index += subPattern.length() + (ch == '[' ? 2 : 0);
                            if (this.isBioSequence && ch == '[' && subPattern.indexOf(".") < 0 && subPattern.indexOf("_") < 0) {
                                subPattern = subPattern + ".0";
                            }
                            currentAtom = this.parseAtom(search, null, subPattern, currentAtom, bond, ch == '[', false, isBranchAtom);
                            currentAtom.hasSubpattern = true;
                            if (bond.order != -1 && bond.order != 0) {
                                this.setBondAtom(bond, null, currentAtom, search);
                            }
                            bond = null;
                            break;
                        }
                        default: {
                            v2 = ch2 = this.isBioSequence == false && PT.isUpperCase((char)ch) != false ? SmilesParser.getChar(pattern, index + 1) : '\u0000';
                            if (!(ch == 'X' && ch2 == 'x' || PT.isLowerCase((char)ch2) && Elements.elementNumberFromSymbol((String)pattern.substring(index, index + 2), (boolean)true) != 0)) {
                                ch2 = '\u0000';
                            }
                            if (ch2 != '\u0000' && "NA CA BA PA SC AC".indexOf(pattern.substring(index, index + 2)) >= 0) {
                                ch2 = '\u0000';
                            }
                            size = PT.isUpperCase((char)ch) != false && PT.isLowerCase((char)ch2) != false ? 2 : 1;
                            currentAtom = this.parseAtom(search, null, pattern.substring(index, index + size), currentAtom, bond, false, false, isBranchAtom);
                            bond = null;
                            index += size;
                            break;
                        }
                    }
                } else {
                    throw new InvalidSmilesException("Unexpected character: " + SmilesParser.getChar(pattern, index));
                }
                ch = SmilesParser.getChar(pattern, index);
                if (ch == '}' && this.checkBrace(search, ch, '}')) {
                    ++index;
                }
            }
            pattern = pattern.substring(index);
            isBranchAtom = false;
        }
    }

    private void parseConnection(SmilesSearch search, int ringNum, SmilesAtom currentAtom, SmilesBond bond) throws InvalidSmilesException {
        Integer r = ringNum;
        SmilesBond bond0 = this.connections.get(r);
        if (bond0 == null) {
            this.connections.put(r, bond);
            ++search.top.ringCount;
            return;
        }
        this.connections.remove(r);
        switch (bond.order) {
            case -1: {
                bond.order = bond0.order != -1 ? bond0.order : (this.isSmarts || currentAtom.isAromatic && bond0.atom1.isAromatic ? 81 : 1);
                break;
            }
            case 1025: {
                bond.order = 1041;
                break;
            }
            case 1041: {
                bond.order = 1025;
            }
        }
        if (bond0.order != -1 && bond0.order != bond.order || currentAtom == bond0.atom1 || bond0.atom1.getBondTo(currentAtom) != null) {
            throw new InvalidSmilesException("Bad connection type or atom");
        }
        bond0.set(bond);
        --currentAtom.bondCount;
        bond0.setAtom2(currentAtom, search);
    }

    private void setBondAtom(SmilesBond bond, SmilesAtom a1, SmilesAtom a2, SmilesSearch search) {
        bond.set2a(a1, a2);
        if (search != null && bond.order == 2 && bond.atom1 != null && bond.atom2 != null && bond.atom1.isAromatic && bond.atom2.isAromatic && (this.flags & 0x200) == 0) {
            search.setFlags(this.flags |= 0x200);
        }
    }

    static int getRingNumber(String pattern, int index, char ch, int[] ret) throws InvalidSmilesException {
        int ringNumber;
        switch (ch) {
            case '%': {
                if (SmilesParser.getChar(pattern, index + 1) == '(') {
                    String subPattern = SmilesParser.getSubPattern(pattern, index + 1, '(');
                    SmilesParser.getDigits(subPattern, 0, ret);
                    index += subPattern.length() + 3;
                    if (ret[0] < 0) {
                        throw new InvalidSmilesException("Invalid number designation: " + subPattern);
                    }
                } else {
                    if (index + 3 <= pattern.length()) {
                        index = SmilesParser.getDigits(pattern.substring(0, index + 3), index + 1, ret);
                    }
                    if (ret[0] < 10) {
                        throw new InvalidSmilesException("Two digits must follow the % sign");
                    }
                }
                ringNumber = ret[0];
                break;
            }
            default: {
                ringNumber = ch - 48;
                ++index;
            }
        }
        ret[0] = ringNumber;
        return index;
    }

    private int checkBioType(String pattern, int index) {
        boolean bl = this.isBioSequence = pattern.charAt(index) == '~';
        if (this.isBioSequence) {
            ++index;
            this.bioType = (char)42;
            char ch = SmilesParser.getChar(pattern, 2);
            if (ch == '~' && ((ch = pattern.charAt(1)) == '*' || PT.isLowerCase((char)ch))) {
                this.bioType = ch;
                index = 3;
            }
        }
        return index;
    }

    private void parseMeasure(SmilesSearch search, String strMeasure, SmilesAtom currentAtom) throws InvalidSmilesException {
        block11: {
            SmilesMeasure m;
            String id;
            int pt = strMeasure.indexOf(":");
            String string = id = pt < 0 ? strMeasure : strMeasure.substring(0, pt);
            if (pt == 0) break block11;
            int len = id.length();
            if (len == 1) {
                id = id + "0";
            }
            if ((m = this.htMeasures.get(id)) == null == pt < 0 || len == 0) break block11;
            try {
                block14: {
                    block12: {
                        int index;
                        block13: {
                            String[] tokens;
                            boolean isNegative;
                            if (pt <= 0) break block12;
                            int type = "__dat".indexOf(id.charAt(0));
                            if (type < 2) break block11;
                            int[] ret = new int[1];
                            SmilesParser.getDigits(id, 1, ret);
                            index = ret[0];
                            strMeasure = strMeasure.substring(pt + 1);
                            boolean isNot = strMeasure.startsWith("!");
                            if (isNot) {
                                strMeasure = strMeasure.substring(1);
                            }
                            if (isNegative = strMeasure.startsWith("-")) {
                                strMeasure = strMeasure.substring(1);
                            }
                            strMeasure = PT.rep((String)strMeasure, (String)"-", (String)",");
                            strMeasure = PT.rep((String)strMeasure, (String)",,", (String)",-");
                            if (isNegative) {
                                strMeasure = "-" + strMeasure;
                            }
                            if ((tokens = PT.split((String)strMeasure, (String)",")).length % 2 == 1 || isNot && tokens.length != 2) break block11;
                            float[] vals = new float[tokens.length];
                            int i = tokens.length;
                            while (--i >= 0 && !Float.isNaN(vals[i] = PT.fVal((String)tokens[i]))) {
                            }
                            if (i >= 0) break block11;
                            m = new SmilesMeasure(search, index, type, isNot, vals);
                            search.measures.addLast((Object)m);
                            if (index <= 0) break block13;
                            this.htMeasures.put(id, m);
                            break block14;
                        }
                        if (index != 0 || !Logger.debugging) break block14;
                        Logger.debug((String)("measure created: " + m));
                        break block14;
                    }
                    if (m.addPoint(currentAtom.index)) {
                        if (m.nPoints == m.type) {
                            this.htMeasures.remove(id);
                            if (Logger.debugging) {
                                Logger.debug((String)("measure created: " + m));
                            }
                        }
                        return;
                    }
                    break block11;
                }
                if (!m.addPoint(currentAtom.index)) {
                }
            }
            catch (NumberFormatException e) {}
            break block11;
            return;
        }
        throw new InvalidSmilesException("invalid measure: " + strMeasure);
    }

    private boolean checkBrace(SmilesSearch search, char ch, char type) throws InvalidSmilesException {
        switch (ch) {
            case '{': {
                if (ch != type) break;
                ++this.braceCount;
                search.top.haveSelected = true;
                return true;
            }
            case '}': {
                if (ch != type || this.braceCount <= 0) break;
                --this.braceCount;
                return true;
            }
            default: {
                return false;
            }
        }
        throw new InvalidSmilesException("Unmatched '}'");
    }

    private String parseNested(SmilesSearch search, String pattern, String prefix) throws InvalidSmilesException {
        int index;
        prefix = "$(" + prefix;
        while ((index = pattern.lastIndexOf(prefix)) >= 0) {
            String s = SmilesParser.getSubPattern(pattern, index + 1, '(');
            int pt = index + s.length() + 3;
            String ext = pattern.substring(pt);
            pattern = pattern.substring(0, index);
            String op = "";
            if (pattern.endsWith("]")) {
                throw new InvalidSmilesException("$(...) must be enclosed in brackets: " + pattern + "$(" + s + ")");
            }
            if (index > 1 && prefix.length() == 2 && (pt = pattern.length()) > 1 && ",;&![".indexOf(pattern.substring(pt - 1)) < 0) {
                op = "&";
            }
            if (ext.length() > 1 && ",;&!)]".indexOf(ext.charAt(0)) < 0) {
                ext = "&" + ext;
            }
            pattern = pattern + op + "_" + search.top.addNested(s) + "_" + ext;
        }
        return pattern;
    }

    private String parseVariables(String pattern) throws InvalidSmilesException {
        int index;
        Lst keys = new Lst();
        Lst values = new Lst();
        int ipt = 0;
        int iptLast = -1;
        if (Logger.debugging) {
            Logger.info((String)pattern);
        }
        while ((index = pattern.indexOf("$", ipt)) >= 0 && SmilesParser.getChar(pattern, index + 1) != '(' && (ipt = SmilesParser.skipTo(pattern, index, '=')) > index + 1 && SmilesParser.getChar(pattern, ipt + 1) == '\"') {
            String key = pattern.substring(index, ipt);
            if (key.lastIndexOf(36) > 0 || key.indexOf(93) > 0) {
                throw new InvalidSmilesException("Invalid variable name: " + key);
            }
            String s = SmilesParser.getSubPattern(pattern, ipt + 1, '\"');
            keys.addLast((Object)("[" + key + "]"));
            values.addLast((Object)s);
            ipt += s.length() + 2;
            ipt = SmilesParser.skipTo(pattern, ipt, ';');
            iptLast = ++ipt;
        }
        if (iptLast < 0) {
            return pattern;
        }
        pattern = pattern.substring(iptLast);
        int i = keys.size();
        while (--i >= 0) {
            String k = (String)keys.get(i);
            String v = (String)values.get(i);
            if (v.equals(k)) continue;
            pattern = PT.rep((String)pattern, (String)k, (String)v);
        }
        if (Logger.debugging) {
            Logger.info((String)pattern);
        }
        return pattern;
    }

    private SmilesAtom parseAtom(SmilesSearch search, SmilesAtom atomSet, String pattern, SmilesAtom atom, SmilesBond bond, boolean isBracketed, boolean isAND, boolean isBranchAtom) throws InvalidSmilesException {
        if (pattern == null || pattern.length() == 0) {
            throw new InvalidSmilesException("Empty atom definition");
        }
        SmilesAtom newAtom = new SmilesAtom();
        if (this.componentParenCount > 0) {
            newAtom.component = this.componentCount;
        }
        if (atomSet == null) {
            search.appendAtom(newAtom);
        }
        boolean isNewAtom = true;
        if (!this.checkLogic(search, pattern, newAtom, null, atom, isAND, isBranchAtom, null)) {
            int biopt;
            int[] ret = new int[1];
            if (this.isBioSequence && pattern.length() == 1) {
                pattern = pattern + ".0";
            }
            char ch = pattern.charAt(0);
            int index = 0;
            boolean isNot = false;
            if (this.isSmarts && ch == '!') {
                if ((ch = SmilesParser.getChar(pattern, ++index)) == '\u0000') {
                    throw new InvalidSmilesException("invalid '!'");
                }
                isNot = true;
                newAtom.not = true;
            }
            if ((biopt = pattern.indexOf(46)) >= 0) {
                newAtom.isBioResidue = true;
                String resOrName = pattern.substring(index, biopt);
                pattern = pattern.substring(biopt + 1).toUpperCase();
                int len = resOrName.length();
                biopt = resOrName.indexOf("^");
                if (biopt >= 0) {
                    if (biopt == len - 2 && (ch = resOrName.charAt(len - 1)) != '*') {
                        newAtom.insCode = ch;
                    }
                    resOrName = resOrName.substring(0, biopt);
                }
                if ((biopt = resOrName.indexOf("#")) >= 0) {
                    SmilesParser.getDigits(resOrName, biopt + 1, ret);
                    newAtom.residueNumber = ret[0];
                    resOrName = resOrName.substring(0, biopt);
                }
                if (resOrName.length() == 0) {
                    resOrName = "*";
                }
                if (resOrName.length() > 1) {
                    newAtom.residueName = resOrName.toUpperCase();
                } else if (!resOrName.equals("*")) {
                    newAtom.residueChar = resOrName;
                }
                resOrName = pattern;
                biopt = resOrName.indexOf("#");
                if (biopt >= 0) {
                    SmilesParser.getDigits(resOrName, biopt + 1, ret);
                    newAtom.elementNumber = ret[0];
                    resOrName = resOrName.substring(0, biopt);
                }
                if (resOrName.length() == 0) {
                    resOrName = "*";
                } else if (resOrName.equals("0")) {
                    resOrName = "\u0000";
                }
                if (resOrName.equals("*")) {
                    newAtom.isBioAtomWild = true;
                } else {
                    newAtom.setAtomName(resOrName);
                }
                ch = '\u0000';
            }
            newAtom.setBioAtom(this.bioType);
            int hydrogenCount = Integer.MIN_VALUE;
            while (ch != '\u0000' && isNewAtom) {
                newAtom.setAtomName(this.isBioSequence ? "\u0000" : "");
                if (PT.isDigit((char)ch)) {
                    index = SmilesParser.getDigits(pattern, index, ret);
                    int mass = ret[0];
                    if (mass == Integer.MIN_VALUE) {
                        throw new InvalidSmilesException("Non numeric atomic mass");
                    }
                    if (SmilesParser.getChar(pattern, index) == '?') {
                        ++index;
                        mass = -mass;
                    }
                    if (newAtom.elementDefined) {
                        throw new InvalidSmilesException("atom mass must precede atom symbol or be separated from it with \";\"");
                    }
                    newAtom.setAtomicMass(mass);
                } else {
                    block0 : switch (ch) {
                        case '\"': {
                            String type = PT.getQuotedStringAt((String)pattern, (int)index);
                            index += type.length() + 2;
                            newAtom.atomType = type;
                            break;
                        }
                        case '_': {
                            index = SmilesParser.getDigits(pattern, index + 1, ret) + 1;
                            if (ret[0] == Integer.MIN_VALUE) {
                                throw new InvalidSmilesException("Invalid SEARCH primitive: " + pattern.substring(index));
                            }
                            newAtom.iNested = ret[0];
                            if (!isBracketed) {
                                throw new InvalidSmilesException("nesting must appear in [...]: $(" + search.getNested(ret[0]) + ")");
                            }
                            if (!this.isBioSequence || index == pattern.length()) break;
                            throw new InvalidSmilesException("invalid characters: " + pattern.substring(index));
                        }
                        case '=': {
                            index = SmilesParser.getDigits(pattern, index + 1, ret);
                            newAtom.jmolIndex = ret[0];
                            break;
                        }
                        case '#': {
                            boolean isAtomNo = pattern.charAt(index + 1) == '-';
                            index = SmilesParser.getDigits(pattern, index + (isAtomNo ? 2 : 1), ret);
                            if (isAtomNo) {
                                newAtom.atomNumber = ret[0];
                                break;
                            }
                            newAtom.elementNumber = ret[0];
                            break;
                        }
                        case '+': 
                        case '-': {
                            index = this.checkCharge(pattern, index, newAtom);
                            break;
                        }
                        case '@': {
                            if (search.stereo == null) {
                                search.stereo = SmilesStereo.newStereo(null);
                            }
                            index = SmilesStereo.checkChirality(pattern, index, search.patternAtoms[newAtom.index]);
                            break;
                        }
                        case ':': {
                            ++index;
                            index = SmilesParser.getDigits(pattern, index, ret);
                            if (ret[0] == Integer.MIN_VALUE) {
                                throw new InvalidSmilesException("Invalid atom class");
                            }
                            newAtom.atomClass = ret[0];
                            break;
                        }
                        default: {
                            boolean checkForPrimitive;
                            char nextChar = SmilesParser.getChar(pattern, index + 1);
                            int len = index + (PT.isLowerCase((char)nextChar) && (!isBracketed || !PT.isDigit((char)SmilesParser.getChar(pattern, index + 2))) ? 2 : 1);
                            String sym2 = pattern.substring(index + 1, len);
                            String symbol = Character.toUpperCase(ch) + sym2;
                            boolean mustBeSymbol = true;
                            boolean bl = checkForPrimitive = isBracketed && PT.isLetter((char)ch);
                            if (checkForPrimitive) {
                                if (!isNot && (isAND ? atomSet : newAtom).hasSymbol) {
                                    mustBeSymbol = false;
                                } else if (ch == 'H') {
                                    mustBeSymbol = pattern.length() == 1 || !PT.isDigit((char)nextChar);
                                } else if (PT.isDigit((char)nextChar)) {
                                    mustBeSymbol = false;
                                } else if (!symbol.equals("A") && !symbol.equals("Xx")) {
                                    boolean bl2 = mustBeSymbol = (ch != 'h' || len == 2) && Elements.elementNumberFromSymbol((String)symbol, (boolean)true) > 0;
                                    if (!mustBeSymbol && len == 2) {
                                        sym2 = "";
                                        boolean bl3 = mustBeSymbol = Elements.elementNumberFromSymbol((String)(symbol = symbol.substring(0, 1)), (boolean)true) > 0;
                                    }
                                }
                            }
                            if (mustBeSymbol) {
                                if (!((isBracketed || this.isSmarts || this.isBioSequence || SmilesAtom.allowSmilesUnbracketed(symbol)) && newAtom.setSymbol(symbol = ch + sym2))) {
                                    throw new InvalidSmilesException("Invalid atom symbol: " + symbol);
                                }
                                if (isAND) {
                                    atomSet.hasSymbol = true;
                                }
                                index += symbol.length();
                                break;
                            }
                            index = SmilesParser.getDigits(pattern, index + 1, ret);
                            int val = ret[0];
                            switch (ch) {
                                default: {
                                    throw new InvalidSmilesException("Invalid SEARCH primitive: " + pattern.substring(index));
                                }
                                case 'D': {
                                    newAtom.setDegree(val == Integer.MIN_VALUE ? 1 : val);
                                    break block0;
                                }
                                case 'd': {
                                    newAtom.setNonhydrogenDegree(val == Integer.MIN_VALUE ? 1 : val);
                                    break block0;
                                }
                                case 'H': {
                                    hydrogenCount = val == Integer.MIN_VALUE ? 1 : val;
                                    break block0;
                                }
                                case 'h': {
                                    newAtom.setImplicitHydrogenCount(val == Integer.MIN_VALUE ? -1 : val);
                                    break block0;
                                }
                                case 'R': {
                                    if (val == Integer.MIN_VALUE) {
                                        val = -1;
                                    }
                                    newAtom.setRingMembership(val);
                                    search.top.needRingData = true;
                                    break block0;
                                }
                                case 'r': {
                                    if (val == Integer.MIN_VALUE) {
                                        val = -1;
                                        newAtom.setRingMembership(val);
                                    } else {
                                        newAtom.setRingSize(val);
                                        switch (val) {
                                            case 500: {
                                                val = 5;
                                                break;
                                            }
                                            case 600: {
                                                val = 6;
                                            }
                                        }
                                        if (val > search.ringDataMax) {
                                            search.ringDataMax = val;
                                        }
                                    }
                                    search.top.needRingData = true;
                                    break block0;
                                }
                                case 'v': {
                                    newAtom.setValence(val == Integer.MIN_VALUE ? 1 : val);
                                    break block0;
                                }
                                case 'X': {
                                    newAtom.setConnectivity(val == Integer.MIN_VALUE ? 1 : val);
                                    break block0;
                                }
                                case 'x': 
                            }
                            newAtom.setRingConnectivity(val == Integer.MIN_VALUE ? -1 : val);
                            search.top.needRingData = true;
                        }
                    }
                }
                ch = SmilesParser.getChar(pattern, index);
                if (!isNot || ch == '\u0000') continue;
                throw new InvalidSmilesException("'!' may only involve one primitive.");
            }
            if (hydrogenCount == Integer.MIN_VALUE && isBracketed) {
                hydrogenCount = -2147483647;
            }
            newAtom.setExplicitHydrogenCount(hydrogenCount);
            search.patternAtoms[newAtom.index].setExplicitHydrogenCount(hydrogenCount);
        }
        if (this.braceCount > 0) {
            newAtom.selected = true;
        }
        if (isNewAtom && atomSet != null) {
            atomSet.addSubAtom(newAtom, isAND);
        }
        if (atom != null && bond.order == 0) {
            newAtom.notBondedIndex = atom.index;
        }
        if (atom != null && bond.order != 0) {
            if (bond.order == -1) {
                int n = this.isBioSequence && isBranchAtom ? 112 : (bond.order = this.isSmarts || atom.isAromatic && newAtom.isAromatic ? 81 : 1);
            }
            if (!isBracketed) {
                this.setBondAtom(bond, null, newAtom, search);
            }
            if (this.branchLevel == 0 && (bond.order == 17 || bond.order == 112)) {
                ++this.branchLevel;
            }
        }
        if (this.branchLevel == 0) {
            search.lastChainAtom = newAtom;
        }
        return newAtom;
    }

    private int checkCharge(String pattern, int index, SmilesAtom newAtom) throws InvalidSmilesException {
        int len = pattern.length();
        char ch = pattern.charAt(index);
        int count = 1;
        if (++index < len) {
            char nextChar = pattern.charAt(index);
            if (PT.isDigit((char)nextChar)) {
                int[] ret = new int[1];
                index = SmilesParser.getDigits(pattern, index, ret);
                count = ret[0];
                if (count == Integer.MIN_VALUE) {
                    throw new InvalidSmilesException("Non numeric charge");
                }
            } else {
                while (index < len && pattern.charAt(index) == ch) {
                    ++index;
                    ++count;
                }
            }
        }
        newAtom.setCharge(ch == '+' ? count : -count);
        return index;
    }

    private SmilesBond parseBond(SmilesSearch search, SmilesBond bondSet, String pattern, SmilesBond bond, SmilesAtom currentAtom, boolean isAND, boolean isBranchAtom, int len, int[] ret) throws InvalidSmilesException {
        SmilesBond newBond;
        char ch;
        if (len > 0) {
            ch = pattern.charAt(0);
            switch (ch) {
                case '>': {
                    if (!pattern.equals(">>")) {
                        len = -1;
                        break;
                    }
                }
                case '.': {
                    if (bond == null && bondSet == null) {
                        this.isBioSequence = SmilesParser.getChar(pattern, 1) == '~';
                        return new SmilesBond(null, null, 0, false);
                    }
                    len = -1;
                    break;
                }
                case '+': {
                    if (bondSet == null) break;
                    len = -1;
                }
            }
        } else {
            ch = '\u0000';
        }
        SmilesBond smilesBond = bondSet == null ? (bond == null ? new SmilesBond(currentAtom, null, this.isBioSequence && currentAtom != null ? (isBranchAtom ? 112 : 96) : -1, false) : bond) : (newBond = isAND ? bondSet.addPrimitive() : bondSet.addBondOr());
        if (len > 0 && !this.checkLogic(search, pattern, null, newBond, currentAtom, isAND, false, ret)) {
            boolean isBondNot;
            boolean bl = isBondNot = ch == '!';
            if (isBondNot && ((ch = SmilesParser.getChar(pattern, 1)) == '\u0000' || ch == '!')) {
                throw new InvalidSmilesException("invalid '!'");
            }
            int bondType = SmilesBond.getBondTypeFromCode(ch);
            if (bondType == 65) {
                search.top.needRingMemberships = true;
            }
            if (currentAtom == null && bondType != 0) {
                throw new InvalidSmilesException("Bond without a previous atom");
            }
            switch (bondType) {
                case 65537: 
                case 65538: {
                    len = pattern.length();
                    if (len < (isBondNot ? 3 : 2) || pattern.charAt(len - 1) != '-') {
                        len = 0;
                    } else if (len == (isBondNot ? 3 : 2)) {
                        newBond.setAtropType(22);
                    } else {
                        SmilesParser.getDigits(pattern, isBondNot ? 2 : 1, ret);
                        newBond.setAtropType(ret[0]);
                    }
                    search.haveBondStereochemistry = true;
                    break;
                }
                case 1025: 
                case 1041: {
                    this.bondDirectionPaired = !this.bondDirectionPaired;
                    search.haveBondStereochemistry = true;
                    break;
                }
                case 17: {
                    break;
                }
                case 2: {
                    ++search.top.nDouble;
                }
                case 1: {
                    if (!currentAtom.isAromatic) break;
                    search.top.needRingData = true;
                }
            }
            newBond.set2(bondType, isBondNot);
            if (this.isBioSequence && bondSet != null) {
                bondSet.set2(bondType, isBondNot);
            }
        }
        if (len == -1) {
            throw new InvalidSmilesException("invalid bond:" + ch);
        }
        return newBond;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkLogic(SmilesSearch search, String pattern, SmilesAtom atom, SmilesBond bond, SmilesAtom currentAtom, boolean isAND, boolean isBranchAtom, int[] ret) throws InvalidSmilesException {
        int index;
        String and;
        int len;
        int pt;
        block25: {
            String string;
            block22: {
                int i;
                SB sNew;
                block26: {
                    block24: {
                        boolean haveOr;
                        block23: {
                            pt = pattern.lastIndexOf("!");
                            if (atom != null) {
                                atom.pattern = pattern;
                            }
                            while (pt > 0) {
                                if (",;&!".indexOf(pattern.charAt(pt - 1)) < 0) {
                                    pattern = pattern.substring(0, pt) + "&" + pattern.substring(pt);
                                }
                                pt = pattern.lastIndexOf("!", pt - 1);
                            }
                            pt = pattern.indexOf(44);
                            len = pattern.length();
                            and = "&";
                            boolean bl = haveOr = pt > 0;
                            if (haveOr && !this.isSmarts || pt == 0) break block22;
                            pt = pattern.indexOf(59);
                            if (pt < 0) break block23;
                            if (!this.isSmarts || pt == 0) break block22;
                            if (haveOr) {
                                and = ";";
                                haveOr = false;
                            } else {
                                pattern = pattern.replace(';', '&');
                            }
                        }
                        index = 0;
                        if (haveOr) break block24;
                        pt = pattern.indexOf(and);
                        if (pt < 0) {
                            if (bond == null) return false;
                            if (len <= 1) return false;
                            if (isAND) return false;
                        }
                        if (pt == 0 || bond == null && !this.isSmarts) break block22;
                        if (bond == null || pt >= 0 || len <= 1) break block25;
                        sNew = new SB();
                        i = 0;
                        break block26;
                    }
                    pattern = pattern + ",";
                    while ((pt = pattern.indexOf(44, index)) > 0) {
                        if (pt > len) return true;
                        String s = pattern.substring(index, pt);
                        if (s.length() == 0) {
                            String string2;
                            StringBuilder stringBuilder = new StringBuilder().append("missing ");
                            if (bond == null) {
                                string2 = "atom";
                                throw new InvalidSmilesException(stringBuilder.append(string2).append(" token").toString());
                            }
                            string2 = "bond";
                            throw new InvalidSmilesException(stringBuilder.append(string2).append(" token").toString());
                        }
                        if (bond == null) {
                            this.parseAtom(search, atom, s, null, null, true, false, isBranchAtom);
                        } else {
                            this.parseBond(search, bond, s, null, currentAtom, false, false, s.length(), ret);
                        }
                        index = pt + 1;
                    }
                    return true;
                }
                while (i < len) {
                    char ch = pattern.charAt(i++);
                    sNew.appendC(ch);
                    switch (ch) {
                        case '!': {
                            if (this.isSmarts) break;
                            break block22;
                        }
                        case '^': 
                        case '`': {
                            while ((ch = pattern.charAt(i++)) != '-' && ch != '\u0000') {
                                sNew.appendC(ch);
                            }
                            sNew.appendC('-');
                        }
                        default: {
                            if (i >= len) break;
                            if (this.isSmarts) {
                                sNew.append(and);
                                break;
                            }
                            break block22;
                        }
                    }
                }
                pattern = sNew.toString();
                len = pattern.length();
                break block25;
            }
            char ch = pattern.charAt(pt);
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isSmarts) {
                string = "invalid placement for '" + ch + "'";
                throw new InvalidSmilesException(stringBuilder.append(string).append(" in ").append(pattern).toString());
            }
            string = "[" + ch + "] notation only valid with SMARTS, not SMILES,";
            throw new InvalidSmilesException(stringBuilder.append(string).append(" in ").append(pattern).toString());
        }
        pattern = pattern + and;
        while ((pt = pattern.indexOf(and, index)) > 0) {
            if (pt > len) return true;
            String s = pattern.substring(index, pt);
            if (bond == null) {
                this.parseAtom(search, atom, s, null, null, true, true, isBranchAtom);
            } else {
                this.parseBond(search, this.isSmarts ? bond : null, s, this.isSmarts ? null : bond, currentAtom, true, false, s.length(), ret);
            }
            index = pt + 1;
        }
        return true;
    }

    static String getSubPattern(String pattern, int index, char ch) throws InvalidSmilesException {
        char ch2;
        int margin = 1;
        switch (ch) {
            case '[': {
                ch2 = ']';
                break;
            }
            case '\"': 
            case '%': 
            case '/': {
                ch2 = ch;
                break;
            }
            case '(': {
                ch2 = ')';
                break;
            }
            default: {
                ch2 = ch;
                margin = 0;
            }
        }
        int len = pattern.length();
        int pCount = 1;
        for (int pt = index + 1; pt < len; ++pt) {
            char ch1 = pattern.charAt(pt);
            if (ch1 == ch2) {
                if (--pCount != 0) continue;
                return pattern.substring(index + margin, pt + 1 - margin);
            }
            if (ch1 != ch) continue;
            ++pCount;
        }
        throw new InvalidSmilesException("Unmatched " + ch);
    }

    static char getChar(String pattern, int i) {
        return i < pattern.length() ? pattern.charAt(i) : (char)'\u0000';
    }

    static int getDigits(String pattern, int index, int[] ret) {
        int pt;
        int len = pattern.length();
        for (pt = index; pt < len && PT.isDigit((char)pattern.charAt(pt)); ++pt) {
        }
        if (pt > index) {
            try {
                ret[0] = Integer.parseInt(pattern.substring(index, pt));
                return pt;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ret[0] = Integer.MIN_VALUE;
        return pt;
    }

    private static int skipTo(String pattern, int index, char ch0) {
        char ch;
        int pt = index;
        while ((ch = SmilesParser.getChar(pattern, ++pt)) != ch0 && ch != '\u0000') {
        }
        return ch == '\u0000' ? -1 : pt;
    }

    static String cleanPattern(String pattern) {
        pattern = PT.replaceAllCharacters((String)pattern, (String)" \t\n\r", (String)"");
        pattern = PT.rep((String)pattern, (String)"^^", (String)"`");
        int i = 0;
        int i2 = 0;
        while ((i = pattern.indexOf("//*")) >= 0 && (i2 = pattern.indexOf("*//")) >= i) {
            pattern = pattern.substring(0, i) + pattern.substring(i2 + 3);
        }
        pattern = PT.rep((String)pattern, (String)"//", (String)"");
        return pattern;
    }

    static String extractFlags(String pattern, int[] ret) throws InvalidSmilesException {
        pattern = SmilesParser.cleanPattern(pattern);
        int flags = 0;
        while (pattern.startsWith("/")) {
            String strFlags = SmilesParser.getSubPattern(pattern, 0, '/').toUpperCase();
            pattern = pattern.substring(strFlags.length() + 2);
            flags = SmilesSearch.addFlags(flags, strFlags);
        }
        ret[0] = flags;
        return pattern;
    }

    static int getFlags(String pattern) throws InvalidSmilesException {
        int[] ret = new int[1];
        SmilesParser.extractFlags(pattern, ret);
        return ret[0];
    }
}

