/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDisk;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.control.group.GroupId;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.AbstractLRUMap;
import org.apache.commons.jcs.utils.struct.LRUMap;
import org.apache.commons.jcs.utils.timing.ElapsedTimer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexedDiskCache<K, V>
extends AbstractDiskCache<K, V> {
    private static final Log log = LogFactory.getLog(IndexedDiskCache.class);
    protected final String logCacheName;
    private final String fileName;
    private IndexedDisk dataFile;
    private IndexedDisk keyFile;
    private Map<K, IndexedDiskElementDescriptor> keyHash;
    private final int maxKeySize;
    private File rafDir;
    private boolean doRecycle = true;
    private boolean isRealTimeOptimizationEnabled = true;
    private boolean isShutdownOptimizationEnabled = true;
    private boolean isOptimizing = false;
    private int timesOptimized = 0;
    private volatile Thread currentOptimizationThread;
    private int removeCount = 0;
    private boolean queueInput = false;
    private final ConcurrentSkipListSet<IndexedDiskElementDescriptor> queuedPutList = new ConcurrentSkipListSet<IndexedDiskElementDescriptor>(new PositionComparator());
    private ConcurrentSkipListSet<IndexedDiskElementDescriptor> recycle;
    private final IndexedDiskCacheAttributes cattr;
    private int recycleCnt = 0;
    private int startupSize = 0;
    private AtomicLong bytesFree = new AtomicLong(0L);
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
    private AtomicInteger hitCount = new AtomicInteger(0);
    protected ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();

    public IndexedDiskCache(IndexedDiskCacheAttributes cacheAttributes) {
        this(cacheAttributes, null);
    }

    public IndexedDiskCache(IndexedDiskCacheAttributes cattr, IElementSerializer elementSerializer) {
        super(cattr);
        this.setElementSerializer(elementSerializer);
        this.cattr = cattr;
        this.maxKeySize = cattr.getMaxKeySize();
        this.isRealTimeOptimizationEnabled = cattr.getOptimizeAtRemoveCount() > 0;
        this.isShutdownOptimizationEnabled = cattr.isOptimizeOnShutdown();
        this.logCacheName = "Region [" + this.getCacheName() + "] ";
        this.diskLimitType = cattr.getDiskLimitType();
        this.fileName = this.getCacheName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        try {
            this.initializeFileSystem(cattr);
            this.initializeKeysAndData(cattr);
            this.initializeRecycleBin();
            this.setAlive(true);
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Indexed Disk Cache is alive.");
            }
            if (this.isRealTimeOptimizationEnabled && this.keyHash.size() > 0) {
                this.doOptimizeRealTime();
            }
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Failure initializing for fileName: " + this.fileName + " and directory: " + this.rafDir.getAbsolutePath(), e);
        }
    }

    private void initializeFileSystem(IndexedDiskCacheAttributes cattr) {
        this.rafDir = cattr.getDiskPath();
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Cache file root directory: " + this.rafDir);
        }
    }

    private void initializeKeysAndData(IndexedDiskCacheAttributes cattr) throws IOException {
        this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"), this.getElementSerializer());
        this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"), this.getElementSerializer());
        if (cattr.isClearDiskOnStartup()) {
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "ClearDiskOnStartup is set to true.  Ingnoring any persisted data.");
            }
            this.initializeEmptyStore();
        } else if (this.keyFile.length() > 0L) {
            this.initializeStoreFromPersistedData();
        } else {
            this.initializeEmptyStore();
        }
    }

    private void initializeEmptyStore() throws IOException {
        this.initializeKeyMap();
        if (this.dataFile.length() > 0L) {
            this.dataFile.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStoreFromPersistedData() throws IOException {
        this.loadKeys();
        if (this.keyHash.isEmpty()) {
            this.dataFile.reset();
        } else {
            boolean isOk = this.checkKeyDataConsistency(false);
            if (!isOk) {
                this.keyHash.clear();
                this.keyFile.reset();
                this.dataFile.reset();
                log.warn(this.logCacheName + "Corruption detected.  Reseting data and keys files.");
            } else {
                IndexedDiskCache indexedDiskCache = this;
                synchronized (indexedDiskCache) {
                    this.startupSize = this.keyHash.size();
                }
            }
        }
    }

    protected void loadKeys() {
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Loading keys for " + this.keyFile.toString());
        }
        this.storageLock.writeLock().lock();
        try {
            this.initializeKeyMap();
            HashMap keys = (HashMap)this.keyFile.readObject(new IndexedDiskElementDescriptor(0L, (int)this.keyFile.length() - 4));
            if (keys != null) {
                if (log.isDebugEnabled()) {
                    log.debug(this.logCacheName + "Found " + keys.size() + " in keys file.");
                }
                this.keyHash.putAll(keys);
                if (log.isInfoEnabled()) {
                    log.info(this.logCacheName + "Loaded keys from [" + this.fileName + "], key count: " + this.keyHash.size() + "; up to " + this.maxKeySize + " will be available.");
                }
            }
            if (log.isDebugEnabled()) {
                this.dump(false);
            }
        }
        catch (Exception e) {
            log.error(this.logCacheName + "Problem loading keys for file " + this.fileName, e);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    private boolean checkKeyDataConsistency(boolean checkForDedOverlaps) {
        ElapsedTimer timer = new ElapsedTimer();
        log.debug(this.logCacheName + "Performing inital consistency check");
        boolean isOk = true;
        long fileLength = 0L;
        try {
            fileLength = this.dataFile.length();
            for (Map.Entry<K, IndexedDiskElementDescriptor> e : this.keyHash.entrySet()) {
                IndexedDiskElementDescriptor ded = e.getValue();
                isOk = ded.pos + 4L + (long)ded.len <= fileLength;
                if (isOk) continue;
                log.warn(this.logCacheName + "The dataFile is corrupted!\n raf.length() = " + fileLength + "\n ded.pos = " + ded.pos);
                break;
            }
            if (isOk && checkForDedOverlaps) {
                isOk = this.checkForDedOverlaps(this.createPositionSortedDescriptorList());
            }
        }
        catch (IOException e) {
            log.error(e);
            isOk = false;
        }
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Finished inital consistency check, isOk = " + isOk + " in " + timer.getElapsedTimeString());
        }
        return isOk;
    }

    protected boolean checkForDedOverlaps(IndexedDiskElementDescriptor[] sortedDescriptors) {
        long start = System.currentTimeMillis();
        boolean isOk = true;
        long expectedNextPos = 0L;
        for (int i = 0; i < sortedDescriptors.length; ++i) {
            IndexedDiskElementDescriptor ded = sortedDescriptors[i];
            if (expectedNextPos > ded.pos) {
                log.error(this.logCacheName + "Corrupt file: overlapping deds " + ded);
                isOk = false;
                break;
            }
            expectedNextPos = ded.pos + 4L + (long)ded.len;
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Check for DED overlaps took " + (end - start) + " ms.");
        }
        return isOk;
    }

    protected void saveKeys() {
        try {
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Saving keys to: " + this.fileName + ", key count: " + this.keyHash.size());
            }
            this.keyFile.reset();
            HashMap<K, IndexedDiskElementDescriptor> keys = new HashMap<K, IndexedDiskElementDescriptor>();
            keys.putAll(this.keyHash);
            if (keys.size() > 0) {
                this.keyFile.writeObject(keys, 0L);
            }
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Finished saving keys.");
            }
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Problem storing keys.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdate(ICacheElement<K, V> ce) {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "No longer alive; aborting put of key = " + ce.getKey());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Storing element on disk, key: " + ce.getKey());
        }
        IndexedDiskElementDescriptor ded = null;
        IndexedDiskElementDescriptor old = null;
        try {
            byte[] data = this.getElementSerializer().serialize(ce);
            this.storageLock.writeLock().lock();
            try {
                old = this.keyHash.get(ce.getKey());
                if (old != null && data.length <= old.len) {
                    ded = old;
                    ded.len = data.length;
                } else {
                    IndexedDiskElementDescriptor rep;
                    ded = new IndexedDiskElementDescriptor(this.dataFile.length(), data.length);
                    if (this.doRecycle && (rep = this.recycle.ceiling(ded)) != null) {
                        this.recycle.remove(rep);
                        ded = rep;
                        ded.len = data.length;
                        ++this.recycleCnt;
                        this.adjustBytesFree(ded, false);
                        if (log.isDebugEnabled()) {
                            log.debug(this.logCacheName + "using recycled ded " + ded.pos + " rep.len = " + rep.len + " ded.len = " + ded.len);
                        }
                    }
                    this.keyHash.put(ce.getKey(), ded);
                    if (this.queueInput) {
                        this.queuedPutList.add(ded);
                        if (log.isDebugEnabled()) {
                            log.debug(this.logCacheName + "added to queued put list." + this.queuedPutList.size());
                        }
                    }
                    if (old != null) {
                        this.addToRecycleBin(old);
                    }
                }
                this.dataFile.write(ded, data);
            }
            finally {
                this.storageLock.writeLock().unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Put to file: " + this.fileName + ", key: " + ce.getKey() + ", position: " + ded.pos + ", size: " + ded.len);
            }
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Failure updating element, key: " + ce.getKey() + " old: " + old, e);
        }
    }

    @Override
    protected ICacheElement<K, V> processGet(K key) {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "No longer alive so returning null for key = " + key);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Trying to get from disk: " + key);
        }
        ICacheElement<K, V> object = null;
        try {
            this.storageLock.readLock().lock();
            try {
                object = this.readElement(key);
            }
            finally {
                this.storageLock.readLock().unlock();
            }
            if (object != null) {
                this.hitCount.incrementAndGet();
            }
        }
        catch (IOException ioe) {
            log.error(this.logCacheName + "Failure getting from disk, key = " + key, ioe);
            this.reset();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> processGetMatching(String pattern) {
        HashMap elements = new HashMap();
        HashSet<K> keyArray = null;
        this.storageLock.readLock().lock();
        try {
            keyArray = new HashSet<K>(this.keyHash.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        Set matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        for (Object key : matchingKeys) {
            ICacheElement element = this.processGet(key);
            if (element == null) continue;
            elements.put(key, element);
        }
        return elements;
    }

    private ICacheElement<K, V> readElement(K key) throws IOException {
        ICacheElement object = null;
        IndexedDiskElementDescriptor ded = this.keyHash.get(key);
        if (ded != null) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Found on disk, key: " + key);
            }
            try {
                ICacheElement readObject;
                object = readObject = (ICacheElement)this.dataFile.readObject(ded);
            }
            catch (IOException e) {
                log.error(this.logCacheName + "IO Exception, Problem reading object from file", e);
                throw e;
            }
            catch (Exception e) {
                log.error(this.logCacheName + "Exception, Problem reading object from file", e);
                throw new IOException(this.logCacheName + "Problem reading object from disk. " + e.getMessage());
            }
        }
        return object;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> keys = new HashSet<K>();
        this.storageLock.readLock().lock();
        try {
            keys.addAll(this.keyHash.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processRemove(K key) {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "No longer alive so returning false for key = " + key);
            return false;
        }
        if (key == null) {
            return false;
        }
        boolean reset = false;
        boolean removed = false;
        try {
            this.storageLock.writeLock().lock();
            removed = key instanceof String && key.toString().endsWith(":") ? this.performPartialKeyRemoval((String)key) : (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null ? this.performGroupRemoval(((GroupAttrName)key).groupId) : this.performSingleKeyRemoval(key));
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (reset) {
            this.reset();
        }
        if (removed) {
            this.doOptimizeRealTime();
        }
        return removed;
    }

    private boolean performPartialKeyRemoval(String key) {
        boolean removed = false;
        LinkedList<K> itemsToRemove = new LinkedList<K>();
        for (K k : this.keyHash.keySet()) {
            if (!(k instanceof String) || !k.toString().startsWith(key)) continue;
            itemsToRemove.add(k);
        }
        for (Object fullKey : itemsToRemove) {
            this.performSingleKeyRemoval(fullKey);
            removed = true;
        }
        return removed;
    }

    private boolean performGroupRemoval(GroupId key) {
        boolean removed = false;
        LinkedList<K> itemsToRemove = new LinkedList<K>();
        for (K k : this.keyHash.keySet()) {
            if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
            itemsToRemove.add(k);
        }
        for (Object fullKey : itemsToRemove) {
            this.performSingleKeyRemoval(fullKey);
            removed = true;
        }
        return removed;
    }

    private boolean performSingleKeyRemoval(K key) {
        IndexedDiskElementDescriptor ded = this.keyHash.remove(key);
        boolean removed = ded != null;
        this.addToRecycleBin(ded);
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Disk removal: Removed from key hash, key [" + key + "] removed = " + removed);
        }
        return removed;
    }

    @Override
    public void processRemoveAll() {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.getCacheName(), "all", "removeAll");
        try {
            this.reset();
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        if (log.isWarnEnabled()) {
            log.warn(this.logCacheName + "Resetting cache");
        }
        try {
            File keyFileTemp;
            File dataFileTemp;
            boolean result;
            this.storageLock.writeLock().lock();
            if (this.dataFile != null) {
                this.dataFile.close();
            }
            if (!(result = (dataFileTemp = new File(this.rafDir, this.fileName + ".data")).delete()) && log.isDebugEnabled()) {
                log.debug("Could not delete file " + dataFileTemp);
            }
            if (this.keyFile != null) {
                this.keyFile.close();
            }
            if (!(result = (keyFileTemp = new File(this.rafDir, this.fileName + ".key")).delete()) && log.isDebugEnabled()) {
                log.debug("Could not delete file " + keyFileTemp);
            }
            this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"), this.getElementSerializer());
            this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"), this.getElementSerializer());
            this.initializeRecycleBin();
            this.initializeKeyMap();
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Failure reseting state", e);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    private void initializeRecycleBin() {
        this.recycle = new ConcurrentSkipListSet();
    }

    private void initializeKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = this.diskLimitType == IDiskCacheAttributes.DiskLimitType.COUNT ? new LRUMapCountLimited(this.maxKeySize) : new LRUMapSizeLimited(this.maxKeySize);
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Set maxKeySize to: '" + this.maxKeySize + "'");
            }
        } else {
            this.keyHash = new HashMap<K, IndexedDiskElementDescriptor>();
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Set maxKeySize to unlimited'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDispose() {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.getCacheName(), "none", "dispose");
        try {
            Runnable disR = new Runnable(){

                @Override
                public void run() {
                    IndexedDiskCache.this.disposeInternal();
                }
            };
            Thread t = new Thread(disR, "IndexedDiskCache-DisposalThread");
            t.start();
            try {
                t.join(60000L);
            }
            catch (InterruptedException ex) {
                log.error(this.logCacheName + "Interrupted while waiting for disposal thread to finish.", ex);
            }
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected void disposeInternal() {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "Not alive and dispose was called, filename: " + this.fileName);
            return;
        }
        this.setAlive(false);
        Thread optimizationThread = this.currentOptimizationThread;
        if (this.isRealTimeOptimizationEnabled && optimizationThread != null) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "In dispose, optimization already in progress; waiting for completion.");
            }
            try {
                optimizationThread.join();
            }
            catch (InterruptedException e) {
                log.error(this.logCacheName + "Unable to join current optimization thread.", e);
            }
        } else if (this.isShutdownOptimizationEnabled && this.getBytesFree() > 0L) {
            this.optimizeFile();
        }
        this.saveKeys();
        try {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Closing files, base filename: " + this.fileName);
            }
            this.dataFile.close();
            this.dataFile = null;
            this.keyFile.close();
            this.keyFile = null;
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Failure closing files in dispose, filename: " + this.fileName, e);
        }
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Shutdown complete.");
        }
    }

    protected void addToRecycleBin(IndexedDiskElementDescriptor ded) {
        if (ded != null) {
            this.storageLock.readLock().lock();
            try {
                this.adjustBytesFree(ded, true);
                if (this.doRecycle) {
                    this.recycle.add(ded);
                    if (log.isDebugEnabled()) {
                        log.debug(this.logCacheName + "recycled ded" + ded);
                    }
                }
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }
    }

    protected void doOptimizeRealTime() {
        if (this.isRealTimeOptimizationEnabled && !this.isOptimizing && this.removeCount++ >= this.cattr.getOptimizeAtRemoveCount()) {
            this.isOptimizing = true;
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Optimizing file. removeCount [" + this.removeCount + "] OptimizeAtRemoveCount [" + this.cattr.getOptimizeAtRemoveCount() + "]");
            }
            if (this.currentOptimizationThread == null) {
                this.storageLock.writeLock().lock();
                try {
                    if (this.currentOptimizationThread == null) {
                        this.currentOptimizationThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                IndexedDiskCache.this.optimizeFile();
                                IndexedDiskCache.this.currentOptimizationThread = null;
                            }
                        }, "IndexedDiskCache-OptimizationThread");
                    }
                }
                finally {
                    this.storageLock.writeLock().unlock();
                }
                if (this.currentOptimizationThread != null) {
                    this.currentOptimizationThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimizeFile() {
        ElapsedTimer timer = new ElapsedTimer();
        ++this.timesOptimized;
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Beginning Optimization #" + this.timesOptimized);
        }
        IndexedDiskElementDescriptor[] defragList = null;
        this.storageLock.writeLock().lock();
        try {
            this.queueInput = true;
            this.doRecycle = false;
            defragList = this.createPositionSortedDescriptorList();
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        long expectedNextPos = this.defragFile(defragList, 0L);
        this.storageLock.writeLock().lock();
        try {
            try {
                if (!this.queuedPutList.isEmpty()) {
                    defragList = this.queuedPutList.toArray(new IndexedDiskElementDescriptor[this.queuedPutList.size()]);
                    expectedNextPos = this.defragFile(defragList, expectedNextPos);
                }
                this.dataFile.truncate(expectedNextPos);
            }
            catch (IOException e) {
                log.error(this.logCacheName + "Error optimizing queued puts.", e);
            }
            this.removeCount = 0;
            this.resetBytesFree();
            this.initializeRecycleBin();
            this.queuedPutList.clear();
            this.queueInput = false;
            this.doRecycle = true;
            this.isOptimizing = false;
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Finished #" + this.timesOptimized + " Optimization took " + timer.getElapsedTimeString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long defragFile(IndexedDiskElementDescriptor[] defragList, long startingPos) {
        ElapsedTimer timer = new ElapsedTimer();
        long preFileSize = 0L;
        long postFileSize = 0L;
        long expectedNextPos = 0L;
        try {
            preFileSize = this.dataFile.length();
            expectedNextPos = startingPos;
            for (int i = 0; i < defragList.length; ++i) {
                this.storageLock.writeLock().lock();
                try {
                    if (expectedNextPos != defragList[i].pos) {
                        this.dataFile.move(defragList[i], expectedNextPos);
                    }
                    expectedNextPos = defragList[i].pos + 4L + (long)defragList[i].len;
                    continue;
                }
                finally {
                    this.storageLock.writeLock().unlock();
                }
            }
            postFileSize = this.dataFile.length();
            long i = expectedNextPos;
            return i;
        }
        catch (IOException e) {
            log.error(this.logCacheName + "Error occurred during defragmentation.", e);
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Defragmentation took " + timer.getElapsedTimeString() + ". File Size (before=" + preFileSize + ") (after=" + postFileSize + ") (truncating to " + expectedNextPos + ")");
            }
        }
        return 0L;
    }

    private IndexedDiskElementDescriptor[] createPositionSortedDescriptorList() {
        IndexedDiskElementDescriptor[] defragList = new IndexedDiskElementDescriptor[this.keyHash.size()];
        Iterator<Map.Entry<K, IndexedDiskElementDescriptor>> iterator = this.keyHash.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<K, IndexedDiskElementDescriptor> next = iterator.next();
            defragList[i] = next.getValue();
            ++i;
        }
        Arrays.sort(defragList, new PositionComparator());
        return defragList;
    }

    @Override
    public int getSize() {
        return this.keyHash.size();
    }

    protected int getRecyleBinSize() {
        return this.recycle.size();
    }

    protected int getRecyleCount() {
        return this.recycleCnt;
    }

    protected long getBytesFree() {
        return this.bytesFree.get();
    }

    private void resetBytesFree() {
        this.bytesFree.set(0L);
    }

    private void adjustBytesFree(IndexedDiskElementDescriptor ded, boolean add) {
        if (ded != null) {
            int amount = ded.len + 4;
            if (add) {
                this.bytesFree.addAndGet(amount);
            } else {
                this.bytesFree.addAndGet(-amount);
            }
        }
    }

    protected long getDataFileSize() throws IOException {
        long size = 0L;
        this.storageLock.readLock().lock();
        try {
            if (this.dataFile != null) {
                size = this.dataFile.length();
            }
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return size;
    }

    public void dump() {
        this.dump(true);
    }

    public void dump(boolean dumpValues) {
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "[dump] Number of keys: " + this.keyHash.size());
            for (Map.Entry<K, IndexedDiskElementDescriptor> e : this.keyHash.entrySet()) {
                K key = e.getKey();
                IndexedDiskElementDescriptor ded = e.getValue();
                log.debug(this.logCacheName + "[dump] Disk element, key: " + key + ", pos: " + ded.pos + ", ded.len" + ded.len + (dumpValues ? ", val: " + this.get(key) : ""));
            }
        }
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cattr;
    }

    @Override
    public synchronized IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Indexed Disk Cache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Boolean>("Is Alive", this.isAlive()));
        elems.add(new StatElement<Integer>("Key Map Size", this.keyHash != null ? this.keyHash.size() : -1));
        try {
            elems.add(new StatElement<Long>("Data File Length", this.dataFile != null ? this.dataFile.length() : -1L));
        }
        catch (IOException e) {
            log.error(e);
        }
        elems.add(new StatElement<Integer>("Max Key Size", this.maxKeySize));
        elems.add(new StatElement<AtomicInteger>("Hit Count", this.hitCount));
        elems.add(new StatElement<AtomicLong>("Bytes Free", this.bytesFree));
        elems.add(new StatElement<Integer>("Optimize Operation Count", this.removeCount));
        elems.add(new StatElement<Integer>("Times Optimized", this.timesOptimized));
        elems.add(new StatElement<Integer>("Recycle Count", this.recycleCnt));
        elems.add(new StatElement<Integer>("Recycle Bin Size", this.recycle.size()));
        elems.add(new StatElement<Integer>("Startup Size", this.startupSize));
        IStats sStats = super.getStatistics();
        elems.addAll(sStats.getStatElements());
        stats.setStatElements(elems);
        return stats;
    }

    protected int getTimesOptimized() {
        return this.timesOptimized;
    }

    @Override
    protected String getDiskLocation() {
        return this.dataFile.getFilePath();
    }

    public class LRUMapCountLimited
    extends LRUMap<K, IndexedDiskElementDescriptor> {
        public LRUMapCountLimited(int maxKeySize) {
            super(maxKeySize);
        }

        @Override
        protected void processRemovedLRU(K key, IndexedDiskElementDescriptor value) {
            IndexedDiskCache.this.addToRecycleBin(value);
            if (log.isDebugEnabled()) {
                log.debug(IndexedDiskCache.this.logCacheName + "Removing key: [" + key + "] from key store.");
                log.debug(IndexedDiskCache.this.logCacheName + "Key store size: [" + this.size() + "].");
            }
            IndexedDiskCache.this.doOptimizeRealTime();
        }
    }

    public class LRUMapSizeLimited
    extends AbstractLRUMap<K, IndexedDiskElementDescriptor> {
        public static final String TAG = "orig";
        private AtomicInteger contentSize;
        private int maxSize;

        public LRUMapSizeLimited() {
            this(-1);
        }

        public LRUMapSizeLimited(int maxKeySize) {
            this.maxSize = maxKeySize;
            this.contentSize = new AtomicInteger(0);
        }

        private void subLengthFromCacheSize(IndexedDiskElementDescriptor value) {
            this.contentSize.addAndGet((value.len + 4) / -1024 - 1);
        }

        private void addLengthToCacheSize(IndexedDiskElementDescriptor value) {
            this.contentSize.addAndGet((value.len + 4) / 1024 + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexedDiskElementDescriptor put(K key, IndexedDiskElementDescriptor value) {
            IndexedDiskElementDescriptor oldValue = null;
            try {
                oldValue = super.put(key, value);
            }
            finally {
                if (value != null) {
                    this.addLengthToCacheSize(value);
                }
                if (oldValue != null) {
                    this.subLengthFromCacheSize(oldValue);
                }
            }
            return oldValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexedDiskElementDescriptor remove(Object key) {
            IndexedDiskElementDescriptor value = null;
            try {
                IndexedDiskElementDescriptor indexedDiskElementDescriptor = value = (IndexedDiskElementDescriptor)super.remove(key);
                return indexedDiskElementDescriptor;
            }
            finally {
                if (value != null) {
                    this.subLengthFromCacheSize(value);
                }
            }
        }

        @Override
        protected void processRemovedLRU(K key, IndexedDiskElementDescriptor value) {
            if (value != null) {
                this.subLengthFromCacheSize(value);
            }
            IndexedDiskCache.this.addToRecycleBin(value);
            if (log.isDebugEnabled()) {
                log.debug(IndexedDiskCache.this.logCacheName + "Removing key: [" + key + "] from key store.");
                log.debug(IndexedDiskCache.this.logCacheName + "Key store size: [" + this.size() + "].");
            }
            IndexedDiskCache.this.doOptimizeRealTime();
        }

        @Override
        protected boolean shouldRemove() {
            return this.maxSize > 0 && this.contentSize.get() > this.maxSize && this.size() > 0;
        }
    }

    protected static final class PositionComparator
    implements Comparator<IndexedDiskElementDescriptor>,
    Serializable {
        private static final long serialVersionUID = -8387365338590814113L;

        protected PositionComparator() {
        }

        @Override
        public int compare(IndexedDiskElementDescriptor ded1, IndexedDiskElementDescriptor ded2) {
            if (ded1.pos < ded2.pos) {
                return -1;
            }
            if (ded1.pos == ded2.pos) {
                return 0;
            }
            return 1;
        }
    }
}

