/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.data;

import java.awt.datatransfer.DataFlavor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.LayerTransferable;
import org.openstreetmap.josm.gui.datatransfer.data.LayerTransferData;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class OsmLayerTransferData
extends LayerTransferData {
    public static final DataFlavor OSM_FLAVOR = ClipboardUtils.newDataFlavor(OsmLayerTransferData.class, "Layer");
    public static final List<DataFlavor> FLAVORS = Collections.unmodifiableList(Arrays.asList(OSM_FLAVOR, LayerTransferData.FLAVOR, LayerTransferable.LAYER_DATA));
    private final OsmDataLayer osmLayer;

    public OsmLayerTransferData(LayerManager layerManager, OsmDataLayer layer) {
        super(layerManager, layer);
        this.osmLayer = layer;
    }

    public OsmDataLayer getOsmLayer() {
        return this.osmLayer;
    }

    @Override
    public List<DataFlavor> getSupportedFlavors() {
        return FLAVORS;
    }

    @Override
    public String toString() {
        return "OsmLayerTransferData [osmLayer=" + this.osmLayer + ']';
    }
}

