/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.tools.Logging;

public abstract class AbstractCredentialsAgent
implements CredentialsAgent {
    private static volatile CredentialsProvider credentialsProvider = (a, b, c, d, e, f) -> Logging.error("Credentials provider has not been set");
    protected Map<Authenticator.RequestorType, PasswordAuthentication> memoryCredentialsCache = new EnumMap<Authenticator.RequestorType, PasswordAuthentication>(Authenticator.RequestorType.class);

    public static void setCredentialsProvider(CredentialsProvider provider) {
        credentialsProvider = Objects.requireNonNull(provider, "provider");
    }

    @Override
    public CredentialsAgentResponse getCredentials(Authenticator.RequestorType requestorType, String host, boolean noSuccessWithLastResponse) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        PasswordAuthentication credentials = this.lookup(requestorType, host);
        String username = credentials == null || credentials.getUserName() == null ? "" : credentials.getUserName();
        String password = credentials == null || credentials.getPassword() == null ? "" : String.valueOf(credentials.getPassword());
        CredentialsAgentResponse response = new CredentialsAgentResponse();
        if (!noSuccessWithLastResponse && this.memoryCredentialsCache.containsKey((Object)requestorType) && (credentials == null || credentials.getPassword() == null || credentials.getPassword().length == 0)) {
            PasswordAuthentication pa = this.memoryCredentialsCache.get((Object)requestorType);
            response.setUsername(pa.getUserName());
            response.setPassword(pa.getPassword());
            response.setCanceled(false);
        } else if (noSuccessWithLastResponse || username.isEmpty() || password.isEmpty()) {
            credentialsProvider.provideCredentials(requestorType, this, response, username, password, host);
            if (response.isCanceled() || response.getUsername() == null || response.getPassword() == null) {
                return response;
            }
            if (response.isSaveCredentials()) {
                this.store(requestorType, host, new PasswordAuthentication(response.getUsername(), response.getPassword()));
            } else {
                this.memoryCredentialsCache.put(requestorType, new PasswordAuthentication(response.getUsername(), response.getPassword()));
            }
        } else {
            response.setUsername(username);
            response.setPassword(password.toCharArray());
            response.setCanceled(false);
        }
        return response;
    }

    @Override
    public final void purgeCredentialsCache(Authenticator.RequestorType requestorType) {
        this.memoryCredentialsCache.remove((Object)requestorType);
    }

    public abstract String getSaveUsernameAndPasswordCheckboxText();

    @FunctionalInterface
    public static interface CredentialsProvider {
        public void provideCredentials(Authenticator.RequestorType var1, AbstractCredentialsAgent var2, CredentialsAgentResponse var3, String var4, String var5, String var6);
    }
}

