/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiUtil;

public class ValueDocTagInfo
implements JavadocTagInfo {
    @Override
    public String getName() {
        return "value";
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        return true;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value) {
        PsiElement target;
        PsiReference reference;
        boolean hasReference;
        boolean bl = hasReference = value != null && value.getFirstChild() != null;
        if (hasReference && !PsiUtil.isLanguageLevel5OrHigher(value)) {
            return JavaErrorMessages.message("javadoc.value.tag.jdk15.required", new Object[0]);
        }
        if (value != null && (reference = value.getReference()) != null && (target = reference.resolve()) != null) {
            if (!(target instanceof PsiField)) {
                return JavaErrorMessages.message("javadoc.value.field.required", new Object[0]);
            }
            PsiField field = (PsiField)target;
            if (!field.hasModifierProperty("static")) {
                return JavaErrorMessages.message("javadoc.value.static.field.required", new Object[0]);
            }
            if (field.getInitializer() == null || JavaConstantExpressionEvaluator.computeConstantExpression(field.getInitializer(), false) == null) {
                return JavaErrorMessages.message("javadoc.value.field.with.initializer.required", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value) {
        return null;
    }
}

