/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing.effects;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.parsing.AbstractPsiEffectParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/effects/PsiConditionalEffectParser;", "Lorg/jetbrains/kotlin/contracts/parsing/AbstractPsiEffectParser;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "dispatcher", "Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;)V", "tryParseEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
public final class PsiConditionalEffectParser
extends AbstractPsiEffectParser {
    @Override
    @Nullable
    public EffectDeclaration tryParseEffect(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.getTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!PsiContractsUtilsKt.isImpliesCallDescriptor(resolvedCall3.getResultingDescriptor())) {
            return null;
        }
        PsiContractParserDispatcher psiContractParserDispatcher = this.getContractParserDispatcher();
        ReceiverValue $receiver$iv = resolvedCall3.getDispatchReceiver();
        ReceiverValue receiverValue = $receiver$iv;
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
        EffectDeclaration effectDeclaration = psiContractParserDispatcher.parseEffect(expressionReceiver != null ? expressionReceiver.getExpression() : null);
        if (effectDeclaration == null) {
            return null;
        }
        EffectDeclaration effect = effectDeclaration;
        BooleanExpression booleanExpression = this.getContractParserDispatcher().parseCondition(PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall3));
        if (booleanExpression == null) {
            return null;
        }
        BooleanExpression condition = booleanExpression;
        return new ConditionalEffectDeclaration(effect, condition);
    }

    public PsiConditionalEffectParser(@NotNull BindingTrace trace, @NotNull PsiContractParserDispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(dispatcher, "dispatcher");
        super(trace, dispatcher);
    }
}

