/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.i18n;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class LdLocale {
    @NotNull
    private final String language;
    @NotNull
    private final Optional<String> script;
    @NotNull
    private final Optional<String> region;

    private LdLocale(@NotNull String language, @NotNull Optional<String> script, @NotNull Optional<String> region) {
        this.language = language;
        this.script = script;
        this.region = region;
    }

    @NotNull
    public static LdLocale fromString(@NotNull String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("At least a language is required!");
        }
        String language = null;
        Optional script = null;
        Optional region = null;
        List strings = Splitter.on((char)'-').splitToList((CharSequence)string);
        for (int i = 0; i < strings.size(); ++i) {
            String chunk = (String)strings.get(i);
            if (i == 0) {
                language = LdLocale.assignLang(chunk);
                continue;
            }
            if (script == null && region == null && LdLocale.looksLikeScriptCode(chunk)) {
                script = Optional.of((Object)chunk);
                continue;
            }
            if (region == null && (LdLocale.looksLikeGeoCode3166_1(chunk) || LdLocale.looksLikeGeoCodeNumeric(chunk))) {
                region = Optional.of((Object)chunk);
                continue;
            }
            throw new IllegalArgumentException("Unknown part: >>>" + chunk + "<<<!");
        }
        assert (language != null);
        if (script == null) {
            script = Optional.absent();
        }
        if (region == null) {
            region = Optional.absent();
        }
        return new LdLocale(language, (Optional<String>)script, (Optional<String>)region);
    }

    private static boolean looksLikeScriptCode(String string) {
        return string.length() == 4 && string.matches("[A-Z][a-z]{3}");
    }

    private static boolean looksLikeGeoCode3166_1(String string) {
        return string.length() == 2 && string.matches("[A-Z]{2}");
    }

    private static boolean looksLikeGeoCodeNumeric(String string) {
        return string.length() == 3 && string.matches("[0-9]{3}");
    }

    private static String assignLang(String s) {
        if (!s.matches("[a-z]{2,3}")) {
            throw new IllegalArgumentException("Invalid language code syntax: >>>" + s + "<<<!");
        }
        return s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.language);
        if (this.script.isPresent()) {
            sb.append('-');
            sb.append((String)this.script.get());
        }
        if (this.region.isPresent()) {
            sb.append('-');
            sb.append((String)this.region.get());
        }
        return sb.toString();
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    @NotNull
    public Optional<String> getScript() {
        return this.script;
    }

    @NotNull
    public Optional<String> getRegion() {
        return this.region;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LdLocale ldLocale = (LdLocale)o;
        if (!this.language.equals(ldLocale.language)) {
            return false;
        }
        if (!this.region.equals(ldLocale.region)) {
            return false;
        }
        return this.script.equals(ldLocale.script);
    }

    public int hashCode() {
        int result = this.language.hashCode();
        result = 31 * result + this.script.hashCode();
        result = 31 * result + this.region.hashCode();
        return result;
    }
}

