/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.JLanguageTool;

public class WordCoherencyDataLoader {
    public Map<String, String> loadWords(String path) {
        InputStream stream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(path);
        HashMap<String, String> map = new HashMap<String, String>();
        try (InputStreamReader reader = new InputStreamReader(stream, "utf-8");
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + path + ", line: " + line);
                }
                map.put(parts[0], parts[1]);
                map.put(parts[1], parts[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load coherency data from " + path, e);
        }
        return Collections.unmodifiableMap(map);
    }
}

