/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.RowType;
import writer2latex.latex.TableFormatter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableReader;
import writer2latex.util.Misc;

public class TableConverter
extends ConverterHelper {
    private boolean bNeedLongtable = false;
    private boolean bNeedSupertabular = false;
    private boolean bNeedTabulary = false;
    private boolean bNeedColortbl = false;
    private boolean bContainsTables = false;

    public TableConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        pack.append("\\usepackage{array}").nl();
        if (this.bNeedLongtable) {
            pack.append("\\usepackage{longtable}").nl();
        }
        if (this.bNeedSupertabular) {
            pack.append("\\usepackage{supertabular}").nl();
        }
        if (this.bNeedTabulary) {
            pack.append("\\usepackage{tabulary}").nl();
        }
        pack.append("\\usepackage{hhline}").nl();
        if (this.bNeedColortbl) {
            pack.append("\\usepackage{colortbl}").nl();
        }
        if (this.bContainsTables) {
            decl.append("\\setlength\\tabcolsep{1mm}").nl();
            decl.append("\\renewcommand\\arraystretch{1.3}").nl();
        }
    }

    public void handleCaption(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append("\\captionof{table}");
        this.palette.getCaptionCv().handleCaptionBody(node, ldp, oc, true);
    }

    public void handleTable(Element node, Element caption, boolean bCaptionAbove, LaTeXDocumentPortion ldp, Context oc) {
        switch (this.config.tableContent()) {
            case 1: {
                new SingleTableConverter().handleTable(node, caption, bCaptionAbove, ldp, oc);
                this.bContainsTables = true;
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                System.err.println("Warning: Tables are not allowed");
                break;
            }
            case 3: {
                ldp.append("% Error in document: A table was ignored");
            }
        }
    }

    private class SingleTableConverter {
        private TableReader table;
        private TableFormatter formatter;
        private Element caption;
        private boolean bCaptionAbove;
        private BeforeAfter baTable;
        private BeforeAfter baTableAlign;
        private RowType[] rowTypes;

        private SingleTableConverter() {
        }

        private String getFirstParStyle(Element node) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (Misc.isElement(child, "text:p") || Misc.isElement(child, "text:h")) {
                    StyleWithProperties style;
                    String sStyleName = Misc.getAttribute(child, "text:style-name");
                    if (sStyleName != null && (style = TableConverter.this.ofr.getParStyle(sStyleName)) != null) {
                        if (style.isAutomatic()) {
                            sStyleName = style.getParentName();
                        }
                        return TableConverter.this.ofr.getParStyles().getDisplayName(sStyleName);
                    }
                    return null;
                }
                if (!OfficeReader.isTextElement(child)) continue;
                return this.getFirstParStyle((Element)child);
            }
            return null;
        }

        private boolean hasRowType(RowType test) {
            for (RowType type : this.rowTypes) {
                if (type != test) continue;
                return true;
            }
            return false;
        }

        private void handleTable(Element node, Element caption, boolean bCaptionAbove, LaTeXDocumentPortion ldp, Context oc) {
            this.caption = caption;
            this.bCaptionAbove = bCaptionAbove;
            this.table = TableConverter.this.ofr.getTableReader(node);
            if (TableConverter.this.palette.getMathCv().handleDisplayEquation(this.table, ldp)) {
                return;
            }
            this.formatter = new TableFormatter(TableConverter.this.ofr, TableConverter.this.config, TableConverter.this.palette, this.table, !oc.isInMulticols(), oc.isInTable());
            TableConverter.this.bContainsTables = true;
            TableConverter.this.bNeedLongtable = (byte)(TableConverter.this.bNeedLongtable | (this.formatter.isLongtable() ? 1 : 0));
            TableConverter.this.bNeedSupertabular = (byte)(TableConverter.this.bNeedSupertabular | (this.formatter.isSupertabular() ? 1 : 0));
            TableConverter.this.bNeedTabulary = (byte)(TableConverter.this.bNeedTabulary | (this.formatter.isTabulary() ? 1 : 0));
            TableConverter.this.bNeedColortbl = (byte)(TableConverter.this.bNeedColortbl | (this.formatter.isColortbl() ? 1 : 0));
            Context ic = (Context)oc.clone();
            ic.setInTable(true);
            ic.setInSimpleTable(this.formatter.isSimple());
            ic.setNoFootnotes(true);
            this.baTable = new BeforeAfter();
            this.baTableAlign = new BeforeAfter();
            this.formatter.applyTableStyle(this.baTable, this.baTableAlign, TableConverter.this.config.floatTables() && !ic.isInFrame() && !this.table.isSubTable());
            this.rowTypes = new RowType[this.table.getRowCount()];
            for (int nRow = 0; nRow < this.table.getRowCount(); ++nRow) {
                String sStyleName;
                this.rowTypes[nRow] = nRow < this.table.getFirstBodyRow() ? RowType.HEAD : RowType.BODY;
                if (!this.formatter.isLongtable() && !this.formatter.isSupertabular() || (sStyleName = this.getFirstParStyle(this.table.getCell(nRow, 0))) == null) continue;
                if (sStyleName.equals(TableConverter.this.config.getTableFirstHeadStyle())) {
                    this.rowTypes[nRow] = RowType.FIRST_HEAD;
                    continue;
                }
                if (sStyleName.equals(TableConverter.this.config.getTableHeadStyle())) {
                    this.rowTypes[nRow] = RowType.HEAD;
                    continue;
                }
                if (sStyleName.equals(TableConverter.this.config.getTableFootStyle())) {
                    this.rowTypes[nRow] = RowType.FOOT;
                    continue;
                }
                if (!sStyleName.equals(TableConverter.this.config.getTableLastFootStyle())) continue;
                this.rowTypes[nRow] = RowType.LAST_FOOT;
            }
            if (this.formatter.isSupertabular()) {
                this.handleSupertabular(ldp, ic);
            } else if (this.formatter.isLongtable()) {
                this.handleLongtable(ldp, ic);
            } else if (TableConverter.this.config.floatTables() && !ic.isInFrame() && !this.table.isSubTable()) {
                this.handleTableFloat(ldp, ic);
            } else {
                this.handleTabular(ldp, ic);
            }
            TableConverter.this.palette.getNoteCv().flushFootnotes(ldp, oc);
        }

        private void handleSupertabular(LaTeXDocumentPortion ldp, Context oc) {
            ldp.append(this.baTableAlign.getBefore());
            if (this.caption != null) {
                this.handleCaption(this.bCaptionAbove ? "\\topcaption" : "\\bottomcaption", ldp, oc);
            }
            ldp.append("\\tablefirsthead{");
            if (this.hasRowType(RowType.FIRST_HEAD)) {
                this.handleRows(ldp, oc, RowType.FIRST_HEAD, true, false);
            } else {
                this.handleRows(ldp, oc, RowType.HEAD, true, false);
            }
            ldp.append("}\n");
            ldp.append("\\tablehead{");
            this.handleRows(ldp, oc, RowType.HEAD, true, false);
            ldp.append("}\n");
            ldp.append("\\tabletail{");
            this.handleRows(ldp, oc, RowType.FOOT, true, true);
            ldp.append("}\n");
            ldp.append("\\tablelasttail{");
            if (this.hasRowType(RowType.LAST_FOOT)) {
                this.handleRows(ldp, oc, RowType.LAST_FOOT, true, true);
            } else {
                this.handleRows(ldp, oc, RowType.FOOT, true, true);
            }
            ldp.append("}\n");
            this.handleHyperTarget(ldp);
            ldp.append(this.baTable.getBefore()).nl();
            this.handleRows(ldp, oc, RowType.BODY, true, !this.hasRowType(RowType.FOOT) && !this.hasRowType(RowType.LAST_FOOT));
            ldp.nl().append(this.baTable.getAfter()).nl();
            ldp.append(this.baTableAlign.getAfter());
        }

        private void handleLongtable(LaTeXDocumentPortion ldp, Context oc) {
            this.handleHyperTarget(ldp);
            ldp.append(this.baTable.getBefore()).nl();
            if (this.caption != null && this.bCaptionAbove) {
                this.handleCaption("\\caption", ldp, oc);
                ldp.append("\\\\").nl();
                if (this.hasRowType(RowType.FIRST_HEAD)) {
                    this.handleRows(ldp, oc, RowType.FIRST_HEAD, true, true);
                } else {
                    this.handleRows(ldp, oc, RowType.HEAD, true, true);
                }
                ldp.nl().append("\\endfirsthead").nl();
            } else if (this.hasRowType(RowType.FIRST_HEAD)) {
                this.handleRows(ldp, oc, RowType.FIRST_HEAD, true, true);
                ldp.nl().append("\\endfirsthead").nl();
            }
            this.handleRows(ldp, oc, RowType.HEAD, true, true);
            ldp.nl().append("\\endhead").nl();
            this.handleRows(ldp, oc, RowType.FOOT, false, true);
            ldp.nl().append("\\endfoot").nl();
            if (this.caption != null && !this.bCaptionAbove) {
                if (this.hasRowType(RowType.LAST_FOOT)) {
                    this.handleRows(ldp, oc, RowType.LAST_FOOT, false, true);
                    ldp.nl();
                } else if (this.hasRowType(RowType.FOOT)) {
                    this.handleRows(ldp, oc, RowType.FOOT, false, true);
                    ldp.nl();
                }
                this.handleCaption("\\caption", ldp, oc);
                ldp.append("\\endlastfoot").nl();
            } else if (this.hasRowType(RowType.LAST_FOOT)) {
                this.handleRows(ldp, oc, RowType.LAST_FOOT, false, true);
                ldp.nl().append("\\endlastfoot").nl();
            }
            this.handleRows(ldp, oc, RowType.BODY, !this.hasRowType(RowType.HEAD) && !this.hasRowType(RowType.FIRST_HEAD), true);
            ldp.nl().append(this.baTable.getAfter()).nl();
        }

        private void handleTableFloat(LaTeXDocumentPortion ldp, Context oc) {
            ldp.append("\\begin{table}");
            if (TableConverter.this.config.getFloatOptions().length() > 0) {
                ldp.append("[").append(TableConverter.this.config.getFloatOptions()).append("]");
            }
            ldp.nl();
            ldp.append(this.baTableAlign.getBefore());
            if (this.caption != null && this.bCaptionAbove) {
                this.handleCaption("\\caption", ldp, oc);
            }
            this.handleHyperTarget(ldp);
            ldp.append(this.baTable.getBefore()).nl();
            this.handleRows(ldp, oc, RowType.HEAD, true, true);
            ldp.nl();
            this.handleRows(ldp, oc, RowType.BODY, !this.hasRowType(RowType.HEAD), true);
            ldp.append(this.baTable.getAfter()).nl();
            if (this.caption != null && !this.bCaptionAbove) {
                this.handleCaption("\\caption", ldp, oc);
            }
            ldp.nl().append(this.baTableAlign.getAfter());
            ldp.append("\\end{table}").nl();
        }

        private void handleTabular(LaTeXDocumentPortion ldp, Context oc) {
            ldp.append(this.baTableAlign.getBefore());
            if (this.caption != null && this.bCaptionAbove) {
                TableConverter.this.handleCaption(this.caption, ldp, oc);
            }
            this.handleHyperTarget(ldp);
            ldp.append(this.baTable.getBefore()).nl();
            this.handleRows(ldp, oc, RowType.HEAD, true, true);
            ldp.nl();
            this.handleRows(ldp, oc, RowType.BODY, !this.hasRowType(RowType.HEAD), true);
            ldp.nl().append(this.baTable.getAfter()).nl();
            if (this.caption != null && !this.bCaptionAbove) {
                TableConverter.this.handleCaption(this.caption, ldp, oc);
            }
            ldp.append(this.baTableAlign.getAfter());
        }

        private void handleCaption(String sCommand, LaTeXDocumentPortion ldp, Context oc) {
            ldp.append(sCommand);
            TableConverter.this.palette.getCaptionCv().handleCaptionBody(this.caption, ldp, oc, false);
        }

        private void handleHyperTarget(LaTeXDocumentPortion ldp) {
            if (!this.table.isSubTable()) {
                TableConverter.this.palette.getFieldCv().addTarget(this.table.getTableName(), "|table", ldp);
            }
        }

        private void handleRows(LaTeXDocumentPortion ldp, Context oc, RowType rowType, boolean bLineBefore, boolean bLineAfter) {
            int nRowCount = this.table.getRowCount();
            int nColCount = this.table.getColCount();
            boolean bFirst = true;
            boolean bProtect = false;
            int nPreviousRow = -1;
            for (int nRow = 0; nRow < nRowCount; ++nRow) {
                if (this.rowTypes[nRow] != rowType) continue;
                if (nPreviousRow > -1) {
                    String sInterRowMaterial = this.formatter.getInterrowMaterial(nPreviousRow + 1);
                    ldp.append(sInterRowMaterial).nl();
                    if (sInterRowMaterial.length() > 0) {
                        bProtect = false;
                    }
                }
                nPreviousRow = nRow;
                if (bFirst && bLineBefore) {
                    String sInter = this.formatter.getInterrowMaterial(nRow);
                    if (sInter.length() > 0) {
                        ldp.append(sInter).nl();
                    }
                    bFirst = false;
                }
                LaTeXDocumentPortion rowLdp = new LaTeXDocumentPortion(true);
                Context icRow = (Context)oc.clone();
                BeforeAfter baRow = new BeforeAfter();
                this.formatter.applyRowStyle(nRow, baRow, icRow);
                if (!baRow.isEmpty()) {
                    rowLdp.append(baRow.getBefore());
                    if (!this.formatter.isSimple()) {
                        rowLdp.nl();
                    }
                }
                int nCol = 0;
                while (nCol < nColCount) {
                    Element cell = this.table.getCell(nRow, nCol);
                    if (cell != null) {
                        int nColSpan;
                        if ("table:table-cell".equals(cell.getNodeName())) {
                            Context icCell = (Context)icRow.clone();
                            BeforeAfter baCell = new BeforeAfter();
                            this.formatter.applyCellStyle(nRow, nCol, baCell, icCell);
                            rowLdp.append(baCell.getBefore());
                            if (nCol == nColCount - 1) {
                                icCell.setInLastTableColumn(true);
                            }
                            TableConverter.this.palette.getBlockCv().traverseBlockText(cell, rowLdp, icCell);
                            rowLdp.append(baCell.getAfter());
                        }
                        if (nCol + (nColSpan = Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1)) < nColCount) {
                            if (this.formatter.isSimple()) {
                                rowLdp.append(" & ");
                            } else {
                                rowLdp.append(" &").nl();
                            }
                        }
                        nCol += nColSpan;
                        continue;
                    }
                    ++nCol;
                }
                rowLdp.append("\\\\");
                String sRowLdp = rowLdp.toString();
                if (bProtect && (sRowLdp.length() > 0 && sRowLdp.charAt(0) == '[' || sRowLdp.startsWith("\n["))) {
                    ldp.append("{}");
                }
                ldp.append(sRowLdp);
                bProtect = true;
            }
            if (nPreviousRow > -1 && bLineAfter) {
                ldp.append(this.formatter.getInterrowMaterial(nPreviousRow + 1));
            }
        }
    }
}

