/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.helper;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.ui.dialogs.XFilePicker;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

public class FilePicker {
    private XComponentContext xContext;
    private String sDirectoryURL;

    public FilePicker(XComponentContext xContext) {
        this.xContext = xContext;
        this.sDirectoryURL = null;
    }

    public String[] getPaths() {
        return this.getPaths(true);
    }

    public String getPath() {
        String[] sPaths = this.getPaths(false);
        if (sPaths != null && sPaths.length > 0) {
            return sPaths[0];
        }
        return null;
    }

    private String[] getPaths(boolean bAllowMultiSelection) {
        Object filePicker = null;
        try {
            filePicker = this.xContext.getServiceManager().createInstanceWithContext("com.sun.star.ui.dialogs.FilePicker", this.xContext);
        }
        catch (Exception e) {
            return null;
        }
        XFilePicker xFilePicker = (XFilePicker)UnoRuntime.queryInterface(XFilePicker.class, (Object)filePicker);
        XExecutableDialog xExecutable = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)xFilePicker);
        xFilePicker.setMultiSelectionMode(bAllowMultiSelection);
        if (this.sDirectoryURL != null) {
            try {
                xFilePicker.setDisplayDirectory(this.sDirectoryURL);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        String[] sPaths = null;
        if (xExecutable.execute() == 1) {
            this.sDirectoryURL = xFilePicker.getDisplayDirectory();
            String[] sPathList = xFilePicker.getFiles();
            int nCount = sPathList.length;
            if (nCount > 1) {
                sPaths = new String[nCount - 1];
                for (int i = 1; i < nCount; ++i) {
                    sPaths[i - 1] = sPathList[0] + sPathList[i];
                }
            } else if (nCount == 1) {
                sPaths = sPathList;
            }
        }
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xFilePicker);
        xComponent.dispose();
        return sPaths;
    }
}

