# dialogscreens.py - Copyright (C) 2009 Red Hat, Inc.
# Written by Darryl L. Pierce <dpierce@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.  A copy of the GNU General Public License is
# also available at http://www.gnu.org/copyleft/gpl.html.

from snack import *

import _snack
import traceback

class DialogScreen:
    """
    Lets the user present a single dialog box with a message.
    """

    def __init__(self, title, message, colorset = None):
        self.__title = title
        self.__message = message
        self.__colorset = colorset

    def show(self):
        screen = SnackScreen()

        # apply the colorset
        if self.__colorset is not None:
            for item in self.__colorset.keys():
                colors = self.__colorset.get(item)
                screen.setColor(item, colors[0], colors[1])

        ButtonChoiceWindow(screen,
                           self.__title,
                           self.__message,
                           buttons = ["Close"])
        screen.popWindow()
        screen.finish()

