/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.perl.inline.java.InlineJavaClass;
import org.perl.inline.java.InlineJavaException;

public class InlineJavaHandle {
    private static final String charset = "ISO-8859-1";

    static String read(Object o, int len) throws InlineJavaException, IOException {
        String ret = null;
        if (InlineJavaClass.ClassIsReadHandle(o.getClass())) {
            if (o instanceof Reader) {
                char[] buf = new char[len];
                int rc = ((Reader)o).read(buf);
                if (rc != -1) {
                    ret = new String(buf);
                }
            } else {
                byte[] buf = new byte[len];
                int rc = ((InputStream)o).read(buf);
                if (rc != -1) {
                    ret = new String(buf, charset);
                }
            }
        } else {
            throw new InlineJavaException("Can't read from non-readhandle object (" + o.getClass().getName() + ")");
        }
        return ret;
    }

    static String readLine(Object o) throws InlineJavaException, IOException {
        String ret = null;
        if (InlineJavaClass.ClassIsReadHandle(o.getClass())) {
            if (!(o instanceof BufferedReader)) {
                throw new InlineJavaException("Can't read line from non-buffered Reader or InputStream");
            }
        } else {
            throw new InlineJavaException("Can't read line from non-readhandle object (" + o.getClass().getName() + ")");
        }
        ret = ((BufferedReader)o).readLine();
        return ret;
    }

    static Object makeBuffered(Object o) throws InlineJavaException, IOException {
        Closeable ret = null;
        if (InlineJavaClass.ClassIsReadHandle(o.getClass())) {
            ret = o instanceof BufferedReader ? (BufferedReader)o : (o instanceof Reader ? new BufferedReader((Reader)o) : new BufferedReader(new InputStreamReader((InputStream)o, charset)));
        } else if (InlineJavaClass.ClassIsWriteHandle(o.getClass())) {
            ret = o instanceof BufferedWriter ? (BufferedWriter)o : (o instanceof Writer ? new BufferedWriter((Writer)o) : new BufferedWriter(new OutputStreamWriter((OutputStream)o, charset)));
        } else {
            throw new InlineJavaException("Can't make non-handle object buffered (" + o.getClass().getName() + ")");
        }
        return ret;
    }

    static int write(Object o, String str) throws InlineJavaException, IOException {
        int ret = -1;
        if (InlineJavaClass.ClassIsWriteHandle(o.getClass())) {
            if (o instanceof Writer) {
                ((Writer)o).write(str);
                ret = str.length();
            } else {
                byte[] b = str.getBytes(charset);
                ((OutputStream)o).write(b);
                ret = b.length;
            }
        } else {
            throw new InlineJavaException("Can't write to non-writehandle object (" + o.getClass().getName() + ")");
        }
        return ret;
    }

    static void close(Object o) throws InlineJavaException, IOException {
        if (InlineJavaClass.ClassIsReadHandle(o.getClass())) {
            if (o instanceof Reader) {
                ((Reader)o).close();
            } else {
                ((InputStream)o).close();
            }
        } else if (InlineJavaClass.ClassIsWriteHandle(o.getClass())) {
            if (o instanceof Writer) {
                ((Writer)o).close();
            } else {
                ((OutputStream)o).close();
            }
        } else {
            throw new InlineJavaException("Can't close non-handle object (" + o.getClass().getName() + ")");
        }
    }
}

