// This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
// To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
// letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

// Persistence Of Vision Ray Tracer Include File
// File: ChessPieces.pov
// Desc: Chesspieces
// Date: 1999-06-19
// Auth: ingo
//
// Lathe and prism made with SpilinEditor v1.2

// Updated: 09Aug2008 (jh) for v3.7 distribution

//The King fits in box{<-0.43490,-0.00165,-0.43490>, < 0.43490, 1.99845, 0.43490>}
#declare Koning = difference {
   lathe {
      cubic_spline
   	39,
   	< 0.000000, 0.997627>,
   	< 0.000000, 0.997627>,
   	< 0.030908, 0.994193>,
   	< 0.030908, 0.942680>,
   	< 0.082420, 0.942680>,
   	< 0.082420, 0.908339>,
   	< 0.030908, 0.908339>,
   	< 0.030908, 0.856826>,
   	< 0.051513, 0.843089>,
   	< 0.068683, 0.843089>,
   	< 0.085854, 0.825918>,
   	< 0.103025, 0.825918>,
   	< 0.103025, 0.808748>,
   	< 0.137367, 0.791577>,
   	< 0.154538, 0.774406>,
   	< 0.154538, 0.757235>,
   	< 0.127064, 0.736630>,
   	< 0.108176, 0.698854>,
   	< 0.123630, 0.667947>,
   	< 0.157972, 0.637039>,
   	< 0.115045, 0.618151>,
   	< 0.118479, 0.580375>,
   	< 0.137367, 0.551185>,
   	< 0.120196, 0.534014>,
   	< 0.073835, 0.509975>,
   	< 0.103025, 0.345134>,
   	< 0.085854, 0.242109>,
   	< 0.137367, 0.224938>,
   	< 0.154538, 0.190597>,
   	< 0.154538, 0.139084>,
   	< 0.171709, 0.121913>,
   	< 0.154538, 0.104742>,
   	< 0.137367, 0.087571>,
   	< 0.188879, 0.070401>,
   	< 0.154538, 0.053230>,
   	< 0.188879, 0.036059>,
   	< 0.206050, 0.001717>,
   	< 0.000000, 0.001717>,
   	< 0.000000, 0.001717>
      scale 2
   }
   box {<-0.5, 0,-0.3>, < 0.5, 0.5,-0.05> translate < 0, 1.7, 0>}
   box {<-0.5, 0, 0.3>, < 0.5, 0.5, 0.05> translate < 0, 1.7, 0>}
}

//The Queen fits in box{<-0.462711,-0.00175,-0.462711>, < 0.462711, 1.899390, 0.462711>}
#declare Dame= lathe {
	cubic_spline
	33,
	< 0.000000, 0.999680>,
	< 0.000000, 0.999680>,
	< 0.044132, 0.988167>,
	< 0.028782, 0.953629>,
	< 0.053726, 0.913335>,
	< 0.084426, 0.919091>,
	< 0.099776, 0.903741>,
	< 0.113207, 0.903741>,
	< 0.113207, 0.888391>,
	< 0.143908, 0.873041>,
	< 0.159258, 0.857691>,
	< 0.159258, 0.842340>,
	< 0.143908, 0.828909>,
	< 0.128558, 0.794371>,
	< 0.147745, 0.761752>,
	< 0.159258, 0.736808>,
	< 0.117045, 0.721458>,
	< 0.109370, 0.688839>,
	< 0.084426, 0.640869>,
	< 0.053726, 0.416373>,
	< 0.095939, 0.270547>,
	< 0.153502, 0.251359>,
	< 0.172689, 0.212984>,
	< 0.172689, 0.155420>,
	< 0.191877, 0.136233>,
	< 0.172689, 0.117045>,
	< 0.153502, 0.097857>,
	< 0.211065, 0.078670>,
	< 0.172689, 0.059482>,
	< 0.211065, 0.040294>,
	< 0.230252, 0.001919>,
	< 0.000000, 0.001919>,
	< 0.000000, 0.001919>
	scale 1.9
}

//The Bishop fits in box{<-0.433431,-0.00164,-0.433431>, < 0.433431, 1.710890, 0.433431>}
#declare Loper = difference {
   lathe {
   	cubic_spline
   	22,
   	< 0.000000, 1.006408>,
   	< 0.000000, 1.006408>,
   	< 0.140616, 0.885880>,
   	< 0.080352, 0.805528>,
   	< 0.140616, 0.785440>,
   	< 0.154677, 0.763343>,
   	< 0.136598, 0.753300>,
   	< 0.080352, 0.685000>,
   	< 0.060264, 0.383681>,
   	< 0.100440, 0.283241>,
   	< 0.160704, 0.263153>,
   	< 0.180792, 0.222977>,
   	< 0.180792, 0.162713>,
   	< 0.200880, 0.142625>,
   	< 0.180792, 0.122537>,
   	< 0.160704, 0.102449>,
   	< 0.220968, 0.082361>,
   	< 0.180792, 0.062273>,
   	< 0.220968, 0.042185>,
   	< 0.241056, 0.002009>,
   	< 0.000000, 0.002009>,
   	< 0.000000, 0.002009>
   	scale 1.7
   }
   box {
      < 0, 0,-0.5>, < 0.5, 0.03, 0.5>
      rotate < 0, 0, 45>
      translate < 0, 1.5, 0>
   }
}

//The Knight fits in box {<-0.44857,-0.00170,-0.44857>, < 0.44857, 1.63799, 0.44857>}
#declare Paard = union {
   lathe {                          // The foot
   	cubic_spline
   	15,
   	< 0.000000, 0.925991>,
   	< 0.000000, 0.925991>,
   	< 0.353432, 0.996678>,
   	< 0.565491, 0.925991>,
   	< 0.636177, 0.784618>,
   	< 0.636177, 0.572559>,
   	< 0.706863, 0.501873>,
   	< 0.636177, 0.431187>,
   	< 0.565491, 0.360500>,
   	< 0.777550, 0.289814>,
   	< 0.636177, 0.219128>,
   	< 0.777550, 0.148441>,
   	< 0.848236, 0.007069>,
   	< 0.000000, 0.007069>,
   	< 0.000000, 0.007069>
   	scale 0.5
   }
   difference {                    // The head
      prism {
      	cubic_spline
      	0,
      	1,
      	26,
      	< 0.900127, 0.016366>,
      	< 0.981957, 0.016366>,
      	< 1.104701, 0.016366>,
      	< 1.227446, 0.261855>,
      	< 1.063786, 0.343685>,
      	< 0.981957, 0.466429>,
      	< 1.022871, 0.589174>,
      	< 1.186531, 0.589174>,
      	< 1.186531, 0.630089>,
      	< 1.227446, 0.671004>,
      	< 1.227446, 0.711918>,
      	< 1.145616, 0.752833>,
      	< 1.022871, 0.834663>,
      	< 0.981957, 0.875578>,
      	< 0.941042, 0.998322>,
      	< 0.900127, 0.875578>,
      	< 0.818297, 0.834663>,
      	< 0.736467, 0.711918>,
      	< 0.695553, 0.507344>,
      	< 0.736467, 0.220940>,
      	< 0.777382, 0.057281>,
      	< 0.818297, 0.016366>,
      	< 0.859212, 0.016366>,
      	< 0.900127, 0.016366>,
      	< 0.981957, 0.016366>,
      	< 1.104701, 0.016366>
      	rotate <-90, 0, 0>
      	translate <-1, 0.45, 0.5>
      	scale < 1, 1, 0.4>
      }
      box {                        // The back
         <-1, 0, 0.2>, < 1, 2, 1>
         rotate <-3,-10, 0>
      }
      box {
         <-1, 0,-0.2>, < 1, 2,-1>
         rotate < 3, 10, 0>
      }
      cylinder {                   // The front
         < 0, 0, 0>, < 0, 0,-1>, 1
         rotate < 0,-10, 0>
         translate < 0.86, 1.1, 0.056>
      }
      cylinder {
         < 0, 0, 0>, < 0, 0, 1>, 1
         rotate < 0, 10, 0>
         translate < 0.86, 1.1,-0.056>
      }
      box {                        // Split the ears
         -0.25,0.25
         rotate < 45, 0, 0>
         scale < 1, 1, 0.6>
         translate < 0, 1.65, 0>
      }
      cylinder {                   // The eyes
         < 0, 0, 0>, < 0, 1, 0>, 0.05
         scale < 2, 1, 0.5>
         rotate < 45, 0, 0>
         translate < 0.15, 1,-0.32>
      }
      cylinder {
         < 0, 0, 0>, < 0, 1, 0>, 0.05
         scale < 2, 1, 0.5>
         rotate <-45, 0, 0>
         translate < 0.15, 1, 0.32>
      }
      scale 1.2
      translate < 0,-0.1, 0>
   }
}


//The Rook fits in box{<-0.417871,-0.00158,-0.417871>, <0.417871, 1.398450, 0.417871>}
#declare Toren = difference {
   lathe {
   	cubic_spline
   	22,
   	< 0.000000, 0.990076>,
   	< 0.000000, 0.990076>,
   	< 0.117586, 0.919524>,
   	< 0.164621, 0.990076>,
   	< 0.188138, 0.990076>,
   	< 0.188138, 0.919524>,
   	< 0.188138, 0.848972>,
   	< 0.117586, 0.801938>,
   	< 0.141103, 0.449179>,
   	< 0.117586, 0.331593>,
   	< 0.188138, 0.308076>,
   	< 0.211655, 0.261041>,
   	< 0.211655, 0.190490>,
   	< 0.235172, 0.166972>,
   	< 0.211655, 0.143455>,
   	< 0.188138, 0.119938>,
   	< 0.258690, 0.096421>,
   	< 0.211655, 0.072903>,
   	< 0.258690, 0.049386>,
   	< 0.282207, 0.002352>,
   	< 0.000000, 0.002352>,
   	< 0.000000, 0.002352>
   	scale 1.4
   }
   cylinder {
      < 0, 0,-0.5>, < 0, 0,-0.15>, 0.1
      translate < 0, 1.39, 0>
   }
   cylinder {
      < 0, 0,-0.5>, < 0, 0,-0.15>, 0.1
      translate < 0, 1.39, 0>
      rotate <0,90,0>
   }
   cylinder {
      < 0, 0,-0.5>, < 0, 0,-0.15>, 0.1
      translate < 0, 1.39, 0>
      rotate <0,180,0>
   }
   cylinder {
      < 0, 0,-0.5>, < 0, 0,-0.15>, 0.1
      translate < 0, 1.39, 0>
      rotate <0,270,0>
   }
}

//A Pawn fits in box{<-0.33132,-0.00126,-0.33132>, <0.33132, 1.09902, 0.33132>}
#declare Pion = lathe {
	cubic_spline
	24,
	< 0.000000, 0.975367>,
	< 0.000000, 0.999098>,
	< 0.059329, 0.977740>,
	< 0.109165, 0.935023>,
	< 0.137643, 0.892306>,
	< 0.142389, 0.847216>,
	< 0.116285, 0.797380>,
	< 0.064075, 0.764156>,
	< 0.161375, 0.733305>,
	< 0.066448, 0.683469>,
	< 0.151882, 0.448526>,
	< 0.118658, 0.334615>,
	< 0.187479, 0.308510>,
	< 0.213584, 0.263420>,
	< 0.213584, 0.192226>,
	< 0.237316, 0.168494>,
	< 0.213584, 0.144762>,
	< 0.189852, 0.121031>,
	< 0.261047, 0.097299>,
	< 0.213584, 0.073568>,
	< 0.261047, 0.049836>,
	< 0.284779, 0.002373>,
	< 0.000000, 0.002373>,
	< 0.000000, 0.002373>
	scale 1.1
}

//============ Test Scene ==============//

/*
#version 3.1;
global_settings{assumed_gamma 1}
light_source{<500,500,-500>rgb 1}
camera{location <7,5,-12> look_at <2,2,0> angle 30}
light_source{<500,500,-500>rgb 1}

object{Toren translate<-3.5*1.2,0,3.5*1.2> pigment{rgb 1}}
object{Paard rotate<0,90,0> translate <-2.5*1.2,0,3.5*1.2> pigment {rgb 1}}
object{Loper translate<-1.5*1.2,0,3.5*1.2> pigment{rgb 1}}
object{Koning translate<-0.5*1.2,0,3.5*1.2> pigment{rgb 1}}
object{Dame translate< 0.5*1.2,0,3.5*1.2> pigment{rgb 1}}
object{Loper translate< 1.5*1.2,0,3.5*1.2> pigment{rgb 1}}
object{Paard rotate<0,90,0> translate <2.5*1.2,0,3.5*1.2> pigment{rgb 1}}
object{Toren translate< 3.5*1.2,0,3.5*1.2> pigment{rgb 1}}

#declare P=-3.5;
#while (P<4)
   object{Pion translate<P*1.2,0,2.5*1.2> pigment{rgb 1}}
   #declare P=P+1;
#end //while
*/
