/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.actionVisibility.CvsActionVisibility;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.DeletedCVSDirectoryStorage;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddedFileInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.ui.AbstractAddOptionsDialog;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.ui.Options;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.OptionsDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class AddFileOrDirectoryAction
extends ActionOnSelectedElement {
    private final String myTitle;
    private final Options myOptions;

    public static AddFileOrDirectoryAction createActionToAddNewFileAutomatically() {
        return new AddFileOrDirectoryAction(CvsBundle.getAddingFilesOperationName(), Options.ON_FILE_ADDING);
    }

    public AddFileOrDirectoryAction() {
        this(CvsBundle.getAddingFilesOperationName(), Options.ADD_ACTION);
        this.getVisibility().canBePerformedOnSeveralFiles();
    }

    public AddFileOrDirectoryAction(String title, Options options) {
        super(false);
        this.myTitle = title;
        this.myOptions = options;
        CvsActionVisibility visibility = this.getVisibility();
        visibility.addCondition(FILES_ARENT_UNDER_CVS);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        if (!e.getPresentation().isVisible()) {
            return;
        }
        Project project = CvsContextWrapper.createInstance(e).getProject();
        if (project == null) {
            return;
        }
        AddFileOrDirectoryAction.adjustName(CvsVcs2.getInstance(project).getAddOptions().getValue(), e);
    }

    @Override
    protected String getTitle(VcsContext context) {
        return this.myTitle;
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        Project project = context.getProject();
        boolean showDialog = this.myOptions.isToBeShown(project) || OptionsDialog.shiftIsPressed((int)context.getModifiers());
        return AddFileOrDirectoryAction.getCvsHandler(project, context.getSelectedFiles(), showDialog, this.myOptions);
    }

    public static CvsHandler getDefaultHandler(Project project, VirtualFile[] files) {
        return AddFileOrDirectoryAction.getCvsHandler(project, files, true, Options.NULL);
    }

    private static CvsHandler getCvsHandler(Project project, VirtualFile[] files, boolean showDialog, Options dialogOptions) {
        ArrayList<VirtualFile> filesToAdd = AddFileOrDirectoryAction.collectFilesToAdd(files);
        if (filesToAdd.isEmpty()) {
            return CvsHandler.NULL;
        }
        LOG.assertTrue(!filesToAdd.isEmpty());
        Collection<AddedFileInfo> roots = new CreateTreeOnFileList(filesToAdd, project).getRoots();
        if (roots.isEmpty()) {
            LOG.error(filesToAdd);
        }
        if (!showDialog) {
            return CommandCvsHandler.createAddFilesHandler(project, roots);
        }
        Ref handler = new Ref();
        Runnable runnable = () -> {
            AbstractAddOptionsDialog dialog = AbstractAddOptionsDialog.createDialog(project, roots, dialogOptions);
            handler.set((Object)(!dialog.showAndGet() ? CvsHandler.NULL : CommandCvsHandler.createAddFilesHandler(project, roots)));
        };
        ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.any());
        return (CvsHandler)handler.get();
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        VirtualFile[] filesToAdd = context.getSelectedFiles();
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)context.getProject());
        for (VirtualFile file : filesToAdd) {
            if (file.isDirectory()) {
                dirtyScopeManager.dirDirtyRecursively(file);
                continue;
            }
            dirtyScopeManager.fileDirty(file);
        }
    }

    private static ArrayList<VirtualFile> collectFilesToAdd(VirtualFile[] files) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            VirtualFile parent;
            ArrayList<VirtualFile> parentsToAdd = new ArrayList<VirtualFile>();
            for (parent = file.getParent(); parent != null && !CvsUtil.fileExistsInCvs(parent) && !result.contains(parent); parent = parent.getParent()) {
                parentsToAdd.add(parent);
            }
            if (parent != null) {
                result.addAll(parentsToAdd);
            }
            AddFileOrDirectoryAction.addFilesToCollection(result, file);
        }
        Collections.sort(result, Comparator.comparing(VirtualFile::getPath));
        return result;
    }

    private static void addFilesToCollection(Collection<VirtualFile> collection, VirtualFile file) {
        if (DeletedCVSDirectoryStorage.isAdminDir(file)) {
            return;
        }
        collection.add(file);
        VirtualFile[] children = file.getChildren();
        if (children == null) {
            return;
        }
        for (VirtualFile child : children) {
            AddFileOrDirectoryAction.addFilesToCollection(collection, child);
        }
    }

    static class CreateTreeOnFileList {
        private final Collection<VirtualFile> myFiles;
        private final Map<VirtualFile, AddedFileInfo> myResult = new HashMap();
        private final Project myProject;

        public CreateTreeOnFileList(Collection<VirtualFile> files, Project project) {
            this.myFiles = files;
            this.myProject = project;
            this.fillFileToInfoMap();
            this.setAllParents();
            CvsEntriesManager entriesManager = CvsEntriesManager.getInstance();
            for (VirtualFile file : files) {
                if (!entriesManager.fileIsIgnored(file) && !FileTypeManager.getInstance().isFileIgnored(file)) continue;
                this.myResult.get(file).setIncluded(false);
            }
            this.removeFromMapInfoWithParentAndResortAll();
        }

        public Collection<AddedFileInfo> getRoots() {
            return this.myResult.values();
        }

        private void removeFromMapInfoWithParentAndResortAll() {
            for (VirtualFile file : this.myFiles) {
                if (!this.myResult.containsKey(file)) continue;
                AddedFileInfo info = this.myResult.get(file);
                if (info.getParent() != null) {
                    this.myResult.remove(file);
                    continue;
                }
                info.sort();
            }
        }

        private void setAllParents() {
            for (VirtualFile file : this.myFiles) {
                if (!this.myResult.containsKey(file.getParent()) || !this.myResult.containsKey(file)) continue;
                AddedFileInfo info = this.myResult.get(file);
                info.setParent(this.myResult.get(file.getParent()));
            }
        }

        private void fillFileToInfoMap() {
            for (VirtualFile file : this.myFiles) {
                this.myResult.put(file, new AddedFileInfo(file, this.myProject, CvsConfiguration.getInstance(this.myProject)));
            }
        }
    }
}

