/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SingleAttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.Structure;
import com.thaiopensource.relaxng.output.xsd.basic.StructureVisitor;
import com.thaiopensource.util.Equal;

public class Attribute
extends SingleAttributeUse
implements Structure {
    private final Name name;
    private final SimpleType type;

    public Attribute(SourceLocation sourceLocation, Annotation annotation, Name name, SimpleType simpleType) {
        super(sourceLocation, annotation);
        this.name = name;
        this.type = simpleType;
    }

    public Name getName() {
        return this.name;
    }

    public SimpleType getType() {
        return this.type;
    }

    public Object accept(AttributeUseVisitor attributeUseVisitor) {
        return attributeUseVisitor.visitAttribute(this);
    }

    public Object accept(StructureVisitor structureVisitor) {
        return structureVisitor.visitAttribute(this);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return Equal.equal((Object)this.type, (Object)attribute.type) && this.name.equals(attribute.name);
    }

    public int hashCode() {
        int n = super.hashCode() ^ this.name.hashCode();
        if (this.type != null) {
            n ^= this.type.hashCode();
        }
        return n;
    }

    public boolean isOptional() {
        return false;
    }
}

