/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.pluginExport;

import com.intellij.application.options.colors.pluginExport.ColorSchemePluginTemplate;
import com.intellij.application.options.colors.pluginExport.PluginExportData;
import com.intellij.application.options.colors.pluginExport.PluginInfoDialog;
import com.intellij.application.options.schemes.SerializableSchemeExporter;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.options.ConfigurableSchemeExporter;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSchemePluginExporter
extends ConfigurableSchemeExporter<PluginExportData, EditorColorsScheme> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportScheme(@NotNull EditorColorsScheme scheme2, @NotNull OutputStream outputStream, @Nullable PluginExportData exportData) throws Exception {
        if (scheme2 == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(1);
        }
        if (exportData != null) {
            try (ZipOutputStream zipStream = new ZipOutputStream(outputStream);){
                zipStream.putNextEntry(new ZipEntry("META-INF/plugin.xml"));
                ColorSchemePluginExporter.writePluginXml(scheme2, zipStream, exportData);
                zipStream.putNextEntry(new ZipEntry("colors/" + scheme2.getName() + ".xml"));
                SerializableSchemeExporter.writeToStream((SerializableScheme)scheme2, zipStream);
            }
        }
    }

    public String getExtension() {
        return "jar";
    }

    @Nullable
    public PluginExportData getConfiguration(@NotNull Component parent, @NotNull EditorColorsScheme scheme2) {
        if (parent == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(2);
        }
        if (scheme2 == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(3);
        }
        PluginExportData exportData = ColorSchemePluginExporter.getPluginExportData(scheme2);
        EditorColorsScheme schemeToUpdate = ColorSchemePluginExporter.getSchemeToUpdate(scheme2);
        PluginInfoDialog infoDialog = new PluginInfoDialog(parent, exportData);
        if (infoDialog.showAndGet()) {
            infoDialog.apply();
            exportData.saveToProperties(schemeToUpdate.getMetaProperties());
            if (schemeToUpdate instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)schemeToUpdate).setSaveNeeded(true);
            }
            return exportData;
        }
        return null;
    }

    private static void writePluginXml(@NotNull EditorColorsScheme scheme2, @NotNull OutputStream outputStream, @NotNull PluginExportData exportData) throws IOException {
        if (scheme2 == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(4);
        }
        if (outputStream == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(5);
        }
        if (exportData == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(6);
        }
        ColorSchemePluginTemplate template = new ColorSchemePluginTemplate(scheme2, exportData);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write(template.getText());
        writer.flush();
    }

    @NotNull
    private static EditorColorsScheme getSchemeToUpdate(@NotNull EditorColorsScheme scheme2) {
        AbstractColorsScheme original;
        if (scheme2 == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(7);
        }
        if (scheme2 instanceof AbstractColorsScheme && (original = ((AbstractColorsScheme)scheme2).getOriginal()) != null) {
            AbstractColorsScheme abstractColorsScheme = original;
            if (abstractColorsScheme == null) {
                ColorSchemePluginExporter.$$$reportNull$$$0(8);
            }
            return abstractColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme2;
        if (editorColorsScheme == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(9);
        }
        return editorColorsScheme;
    }

    @NotNull
    private static PluginExportData getPluginExportData(@NotNull EditorColorsScheme scheme2) {
        AbstractColorsScheme original;
        PluginExportData data;
        if (scheme2 == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(10);
        }
        if ((data = new PluginExportData(scheme2.getMetaProperties())).isEmpty() && scheme2 instanceof AbstractColorsScheme && !(scheme2 instanceof ReadOnlyColorsScheme) && (original = ((AbstractColorsScheme)scheme2).getOriginal()) != null) {
            PluginExportData pluginExportData = ColorSchemePluginExporter.getPluginExportData(original);
            if (pluginExportData == null) {
                ColorSchemePluginExporter.$$$reportNull$$$0(11);
            }
            return pluginExportData;
        }
        PluginExportData pluginExportData = data;
        if (pluginExportData == null) {
            ColorSchemePluginExporter.$$$reportNull$$$0(12);
        }
        return pluginExportData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportData";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/pluginExport/ColorSchemePluginExporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/pluginExport/ColorSchemePluginExporter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeToUpdate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginExportData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exportScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writePluginXml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSchemeToUpdate";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPluginExportData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

