/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainText;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class NaturalLanguageTextSelectioner
extends ExtendWordSelectionHandlerBase {
    private static final Set<Character> NATURAL = ContainerUtil.newTroveSet((Object[])new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('$'), Character.valueOf('@'), Character.valueOf('%'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('_')});
    private static final Set<Character> SENTENCE_END = ContainerUtil.newTroveSet((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?')});

    @Override
    public boolean canSelect(PsiElement e) {
        return (e instanceof PsiPlainText || e instanceof PsiComment) && !(e.getContainingFile().getFileType() instanceof CustomSyntaxTableFileType);
    }

    private static TextRange findParagraphRange(String text, int start, int end) {
        int paragraphEnd;
        int paragraphStart = text.lastIndexOf("\n\n", start);
        if (paragraphStart >= (paragraphEnd = text.indexOf("\n\n", end))) {
            return new TextRange(0, text.length());
        }
        return new TextRange(paragraphStart >= 0 ? paragraphStart + 2 : 0, paragraphEnd < 0 ? text.length() : paragraphEnd);
    }

    @Nullable
    private static TextRange findCustomRange(String text, int start, int end, char startChar, char endChar) {
        int prev = text.lastIndexOf(startChar, start);
        int next = text.indexOf(endChar, end);
        if (prev < 0 || next < 0) {
            return null;
        }
        if (StringUtil.contains((CharSequence)text, (int)(prev + 1), (int)start, (char)endChar) || StringUtil.contains((CharSequence)text, (int)end, (int)next, (char)startChar)) {
            return null;
        }
        if (prev + 1 < start || next > end) {
            return new TextRange(prev + 1, next);
        }
        return new TextRange(prev, next + 1);
    }

    @Nullable
    private static TextRange findSentenceRange(String editorText, int start, int end) {
        int sentenceStart;
        for (sentenceStart = start; sentenceStart > 0; --sentenceStart) {
            if (start - sentenceStart > 1000) {
                return null;
            }
            if (NaturalLanguageTextSelectioner.isSentenceEnd(editorText, sentenceStart - 1) || !NaturalLanguageTextSelectioner.isNatural(editorText.charAt(sentenceStart - 1))) break;
        }
        while (sentenceStart < end && Character.isWhitespace(editorText.charAt(sentenceStart))) {
            ++sentenceStart;
        }
        int sentenceEnd = Math.max(0, end - 1);
        while (sentenceEnd < editorText.length()) {
            if (++sentenceEnd - end > 1000) {
                return null;
            }
            if (!NaturalLanguageTextSelectioner.isSentenceEnd(editorText, sentenceEnd - 1)) continue;
        }
        return new TextRange(sentenceStart, sentenceEnd);
    }

    private static boolean isSentenceEnd(String text, int i) {
        return SENTENCE_END.contains(Character.valueOf(text.charAt(i))) && (i + 1 == text.length() || Character.isWhitespace(text.charAt(i + 1)));
    }

    private static TextRange findNaturalRange(String editorText, int start, int end) {
        char c;
        while (start > 0 && NaturalLanguageTextSelectioner.isNatural(editorText.charAt(start - 1))) {
            --start;
        }
        while (end < editorText.length() && NaturalLanguageTextSelectioner.isNatural(c = editorText.charAt(end))) {
            ++end;
        }
        return new TextRange(start, end);
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        NaturalLanguageTextSelectioner.addWordRange(editorText, cursorOffset, result2);
        TextRange range = NaturalLanguageTextSelectioner.expandSelection(e, editorText, cursorOffset, cursorOffset);
        if (range != null) {
            TextRange next;
            result2.add(range);
            while ((next = NaturalLanguageTextSelectioner.expandSelection(e, editorText, range.getStartOffset(), range.getEndOffset())) != null && !range.contains(next)) {
                result2.add(next);
                range = next;
            }
        }
        return result2;
    }

    private static void addWordRange(CharSequence editorText, int cursorOffset, ArrayList<TextRange> result2) {
        SelectWordUtil.addWordSelection(false, editorText, cursorOffset, result2, ch -> Character.isJavaIdentifierPart(ch) || ch == '\'');
        SelectWordUtil.addWordSelection(false, editorText, cursorOffset, result2, ch -> Character.isJavaIdentifierPart(ch) || ch == '\'' || ch == '-');
    }

    @Nullable
    private static TextRange expandSelection(PsiElement e, CharSequence editorText, int selStart, int selEnd) {
        int end;
        int start;
        TextRange range = e.getTextRange();
        int shift = range.getStartOffset();
        if (selStart <= shift || selEnd >= range.getEndOffset()) {
            return null;
        }
        String elementText = editorText.subSequence(shift, range.getEndOffset()).toString();
        TextRange best = NaturalLanguageTextSelectioner.findSentenceRange(elementText, start = selStart - shift, end = selEnd - shift);
        if (best == null) {
            return null;
        }
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start, end, '\"', '\"'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start, end, '(', ')'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start, end, '<', '>'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start, end, '[', ']'));
        TextRange natural = NaturalLanguageTextSelectioner.findNaturalRange(elementText, start, end);
        if (!natural.contains(best)) {
            return null;
        }
        TextRange paragraph = NaturalLanguageTextSelectioner.findParagraphRange(elementText, start, end);
        if (best.getStartOffset() == start && best.getEndOffset() == end || !paragraph.contains(best)) {
            return paragraph.shiftRight(shift);
        }
        return best.shiftRight(shift);
    }

    private static TextRange narrowRange(TextRange best, TextRange candidate) {
        return candidate != null && best.contains(candidate) ? candidate : best;
    }

    private static boolean isNatural(char c) {
        return Character.isWhitespace(c) || Character.isLetterOrDigit(c) || NATURAL.contains(Character.valueOf(c));
    }
}

