/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.TripleFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDescriptorsUtil {
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT = (tool, element, context) -> {
        PsiNamedElement problemElement = LocalDescriptorsUtil.getContainerElement(element, tool, context);
        RefElement refElement = context.getRefManager().getReference((PsiElement)problemElement);
        if (refElement == null && problemElement != null) {
            refElement = GlobalInspectionContextUtil.retrieveRefElement(element, context);
        }
        return refElement;
    };

    static void addProblemDescriptors(@NotNull List<ProblemDescriptor> descriptors, boolean filterSuppressed, @NotNull GlobalInspectionContext context, @Nullable LocalInspectionTool tool, @NotNull TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> getProblemElementFunction, @NotNull InspectionToolPresentation dpi) {
        RefElement refElement;
        if (descriptors == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(1);
        }
        if (getProblemElementFunction == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(2);
        }
        if (dpi == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(3);
        }
        if (descriptors.isEmpty()) {
            return;
        }
        HashMap<RefElement, ArrayList<ProblemDescriptor>> problems = new HashMap<RefElement, ArrayList<ProblemDescriptor>>();
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        for (ProblemDescriptor problemDescriptor : descriptors) {
            String alternativeId;
            String id;
            PsiElement element = problemDescriptor.getPsiElement();
            if (element == null || filterSuppressed && (refManager.isDeclarationsFound() && (context.isSuppressed(element, id = tool.getID()) || (alternativeId = tool.getAlternativeID()) != null && !alternativeId.equals(id) && context.isSuppressed(element, alternativeId)) || SuppressionUtil.inspectionResultSuppressed(element, tool))) continue;
            refElement = (RefElement)getProblemElementFunction.fun((Object)tool, (Object)element, (Object)context);
            ArrayList<ProblemDescriptor> elementProblems = (ArrayList<ProblemDescriptor>)problems.get(refElement);
            if (elementProblems == null) {
                elementProblems = new ArrayList<ProblemDescriptor>();
                problems.put(refElement, elementProblems);
            }
            elementProblems.add(problemDescriptor);
        }
        for (Map.Entry entry : problems.entrySet()) {
            List problemDescriptors = (List)entry.getValue();
            refElement = (RefElement)entry.getKey();
            CommonProblemDescriptor[] descriptions = problemDescriptors.toArray(new CommonProblemDescriptor[problemDescriptors.size()]);
            dpi.addProblemElement((RefEntity)refElement, filterSuppressed, descriptions);
        }
    }

    public static void addProblemDescriptors(@NotNull List<ProblemDescriptor> descriptors, @NotNull InspectionToolPresentation dpi, boolean filterSuppressed, @NotNull GlobalInspectionContext inspectionContext, @NotNull LocalInspectionTool tool) {
        if (descriptors == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(4);
        }
        if (dpi == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(5);
        }
        if (inspectionContext == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(6);
        }
        if (tool == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(7);
        }
        LocalDescriptorsUtil.addProblemDescriptors(descriptors, filterSuppressed, inspectionContext, tool, CONVERT, dpi);
    }

    public static PsiNamedElement getContainerElement(@Nullable PsiElement element, @NotNull LocalInspectionTool tool, @NotNull GlobalInspectionContext context) {
        if (tool == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            LocalDescriptorsUtil.$$$reportNull$$$0(9);
        }
        if (element == null) {
            return null;
        }
        PsiNamedElement containerFromTool = tool.getProblemElement(element);
        if (containerFromTool != null && !(containerFromTool instanceof PsiFile)) {
            return containerFromTool;
        }
        PsiNamedElement container = context.getRefManager().getContainerElement(element);
        return container != null ? container : containerFromTool;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getProblemElementFunction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dpi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ex/LocalDescriptorsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addProblemDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainerElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

