/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

class ApdexData {
    public static final ApdexData EMPTY = new ApdexData(0L, 0L, 0L);
    private final long myTotalCount;
    private final long mySatisfiedCount;
    private final long mySluggishCount;

    private ApdexData(long totalCount, long satisfiedCount, long sluggishCount) {
        assert (totalCount >= 0L);
        assert (satisfiedCount >= 0L);
        assert (sluggishCount >= 0L);
        assert (satisfiedCount + sluggishCount <= totalCount);
        this.myTotalCount = totalCount;
        this.mySatisfiedCount = satisfiedCount;
        this.mySluggishCount = sluggishCount;
    }

    ApdexData withEvent(long requiredTime, long actualTime) {
        boolean satisfied = actualTime < requiredTime;
        boolean sluggish = !satisfied && actualTime < requiredTime * 4L;
        return new ApdexData(this.myTotalCount + 1L, this.mySatisfiedCount + (long)(satisfied ? 1 : 0), this.mySluggishCount + (long)(sluggish ? 1 : 0));
    }

    private long getSlowCount() {
        return this.myTotalCount - this.mySluggishCount - this.mySatisfiedCount;
    }

    String summarizePerformanceSince(ApdexData since) {
        long total = this.myTotalCount - since.myTotalCount;
        long sluggish = this.mySluggishCount - since.mySluggishCount;
        long slow = this.getSlowCount() - since.getSlowCount();
        if (sluggish == 0L && slow == 0L) {
            return "ok";
        }
        if (slow == 0L) {
            return sluggish + "/" + total + " sluggish";
        }
        return sluggish + "/" + total + " sluggish, " + slow + "/" + total + " very slow";
    }
}

