/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.MasqueradingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateMasqueradingLexer
extends MasqueradingLexer {
    public static final IElementType MINUS_TYPE = new IElementType("MINUS", null);

    public TemplateMasqueradingLexer(@NotNull Lexer delegate) {
        if (delegate == null) {
            TemplateMasqueradingLexer.$$$reportNull$$$0(0);
        }
        super(delegate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/embedding/TemplateMasqueradingLexer", "<init>"));
    }

    protected static abstract class MyLexer
    extends LexerBase {
        protected static final int LEXING_BY_SELF = 0;
        protected static final int DELEGATE_IS_LEXING_LINE = 1;
        protected static final int DELEGATE_IS_LEXING_BLOCK = 2;
        protected static final int EOF = 3;
        protected final int myIndent;
        protected final Lexer myDelegate;
        protected int myStartOffset;
        protected int myEndOffset;
        protected CharSequence myBuffer;
        protected int myState;
        protected IElementType myTokenType;
        protected int myTokenStart;
        protected int myTokenEnd;

        public MyLexer(int indent, Lexer delegateLexer) {
            this.myIndent = indent;
            this.myDelegate = delegateLexer;
        }

        protected abstract IElementType getIndentTokenType();

        protected abstract IElementType getEmbeddedContentTokenType();

        protected abstract int getEmbeddedCodeStartMarkerLength();

        protected int getDelegateState(int state2) {
            return state2;
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                MyLexer.$$$reportNull$$$0(0);
            }
            this.myBuffer = buffer;
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myState = initialState % 239;
            this.myTokenEnd = startOffset;
            if (this.myState == 1 || this.myState == 2) {
                this.myTokenEnd = this.myState == 1 ? this.findEol(startOffset) : this.findEndByIndent(startOffset);
                this.myDelegate.start(buffer, startOffset, this.myTokenEnd, this.getDelegateState(initialState / 239));
            } else {
                this.myDelegate.start(buffer, startOffset, startOffset, this.getDelegateState(0));
                this.advance();
            }
        }

        public int getState() {
            return this.myDelegate.getState() * 239 + this.myState;
        }

        @Nullable
        public IElementType getTokenType() {
            if (this.myState == 3) {
                return null;
            }
            if (this.myState == 1 || this.myState == 2) {
                return this.myDelegate.getTokenType();
            }
            return this.myTokenType;
        }

        @NotNull
        public String getTokenText() {
            if (this.myState == 3) {
                if ("" == null) {
                    MyLexer.$$$reportNull$$$0(1);
                }
                return "";
            }
            if (this.myState == 1 || this.myState == 2) {
                String string = this.myDelegate.getTokenText();
                if (string == null) {
                    MyLexer.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = super.getTokenText();
            if (string == null) {
                MyLexer.$$$reportNull$$$0(3);
            }
            return string;
        }

        public int getTokenStart() {
            if (this.myState == 1 || this.myState == 2) {
                return this.myDelegate.getTokenStart();
            }
            return this.myTokenStart;
        }

        public int getTokenEnd() {
            if (this.myState == 1 || this.myState == 2) {
                return this.myDelegate.getTokenEnd();
            }
            return this.myTokenEnd;
        }

        public void advance() {
            if (this.myState == 1 || this.myState == 2) {
                this.myDelegate.advance();
                if (this.myDelegate.getTokenType() == null) {
                    this.myState = 0;
                    this.myTokenEnd = this.myDelegate.getBufferEnd();
                    this.advance();
                }
            } else {
                if (this.myTokenEnd == this.myEndOffset) {
                    this.myState = 3;
                    return;
                }
                this.myTokenStart = this.myTokenEnd;
                if (StringUtil.isWhiteSpace((char)this.myBuffer.charAt(this.myTokenStart))) {
                    this.myTokenType = this.getIndentTokenType();
                    this.myTokenEnd = this.findNonWhitespace(this.myTokenStart);
                    return;
                }
                int curIndent = this.calcIndent(this.myTokenStart);
                if (curIndent > this.myIndent) {
                    this.myTokenEnd = this.findEndByIndent(this.myTokenStart + 1);
                    if (this.prevLineWithMinusIsEmpty(this.myTokenStart)) {
                        this.myDelegate.start(this.myBuffer, this.myTokenStart, this.myTokenEnd, this.myDelegate.getState());
                        this.myState = 2;
                    } else {
                        this.myTokenType = this.getEmbeddedContentTokenType();
                    }
                    return;
                }
                int embeddedCodeStartMarkerLength = this.getEmbeddedCodeStartMarkerLength();
                if (embeddedCodeStartMarkerLength > 0) {
                    this.myTokenType = MINUS_TYPE;
                    this.myTokenEnd = this.myTokenStart + embeddedCodeStartMarkerLength;
                } else {
                    this.myTokenEnd = this.findEol(this.myTokenStart);
                    this.myDelegate.start(this.myBuffer, this.myTokenStart, this.myTokenEnd, this.getDelegateState(this.myDelegate.getState()));
                    this.myState = 1;
                }
            }
        }

        private boolean prevLineWithMinusIsEmpty(int offset) {
            int minusOffset = StringUtil.lastIndexOf((CharSequence)this.myBuffer, (char)'-', (int)this.myStartOffset, (int)offset);
            if (minusOffset == -1) {
                return false;
            }
            int eolPos = this.findEol(minusOffset);
            if (eolPos == -1) {
                return false;
            }
            return StringUtil.isEmptyOrSpaces((CharSequence)this.myBuffer.subSequence(minusOffset + 1, eolPos));
        }

        protected int findEndByIndent(int offset) {
            while (offset < this.myEndOffset) {
                if (offset > this.myStartOffset && !StringUtil.isWhiteSpace((char)this.myBuffer.charAt(offset)) && StringUtil.isWhiteSpace((char)this.myBuffer.charAt(offset - 1))) {
                    int indent = this.calcIndent(offset);
                    if (indent != -1 && indent <= this.myIndent) {
                        return offset;
                    }
                    offset = this.findEol(offset);
                    continue;
                }
                ++offset;
            }
            return offset;
        }

        protected int calcIndent(int offset) {
            if (offset == this.myStartOffset) {
                return this.myIndent;
            }
            int answer = 0;
            --offset;
            while (offset >= this.myStartOffset) {
                char c = this.myBuffer.charAt(offset);
                if (c == '\n') {
                    return answer;
                }
                if (!StringUtil.isWhiteSpace((char)c)) {
                    return -1;
                }
                ++answer;
                --offset;
            }
            return answer + this.myIndent;
        }

        protected int findNonWhitespace(int offset) {
            while (offset < this.myEndOffset) {
                if (!StringUtil.isWhiteSpace((char)this.myBuffer.charAt(offset))) {
                    return offset;
                }
                ++offset;
            }
            return offset;
        }

        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myBuffer;
            if (charSequence == null) {
                MyLexer.$$$reportNull$$$0(4);
            }
            return charSequence;
        }

        public int getBufferEnd() {
            return this.myEndOffset;
        }

        protected int findEol(int offset) {
            while (offset < this.myEndOffset) {
                if (this.myBuffer.charAt(offset) == '\n') {
                    return offset;
                }
                ++offset;
            }
            return offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/embedding/TemplateMasqueradingLexer$MyLexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/embedding/TemplateMasqueradingLexer$MyLexer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

