/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.revertion.SelectionReverter;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.FileHistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.history.integration.ui.models.SelectionDifferenceModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class SelectionHistoryDialogModel
extends FileHistoryDialogModel {
    private SelectionCalculator myCalculatorCache;
    private final int myFrom;
    private final int myTo;

    public SelectionHistoryDialogModel(Project p, IdeaGateway gw, LocalHistoryFacade vcs, VirtualFile f, int from, int to) {
        super(p, gw, vcs, f);
        this.myFrom = from;
        this.myTo = to;
    }

    @Override
    protected Pair<Revision, List<RevisionItem>> calcRevisionsCache() {
        this.myCalculatorCache = null;
        return super.calcRevisionsCache();
    }

    @Override
    public FileDifferenceModel getDifferenceModel() {
        return new SelectionDifferenceModel(this.myProject, this.myGateway, this.getCalculator(), this.getLeftRevision(), this.getRightRevision(), this.myFrom, this.myTo, this.isCurrentRevisionSelected());
    }

    private SelectionCalculator getCalculator() {
        if (this.myCalculatorCache == null) {
            ArrayList<Revision> revisionList = new ArrayList<Revision>();
            revisionList.add(this.getCurrentRevision());
            revisionList.addAll(ContainerUtil.map(this.getRevisions(), revisionItem -> revisionItem.revision));
            this.myCalculatorCache = new SelectionCalculator(this.myGateway, revisionList, this.myFrom, this.myTo);
        }
        return this.myCalculatorCache;
    }

    @Override
    public Reverter createReverter() {
        return new SelectionReverter(this.myProject, this.myVcs, this.myGateway, this.getCalculator(), this.getLeftRevision(), this.getRightEntry(), this.myFrom, this.myTo);
    }
}

