/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.internal.psiView.ViewerNodeDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ViewerTreeStructure
extends AbstractTreeStructure {
    private boolean myShowWhiteSpaces = true;
    private boolean myShowTreeNodes = true;
    private final Project myProject;
    private PsiElement myRootPsiElement = null;
    private final Object myRootElement = new Object();

    public ViewerTreeStructure(Project project) {
        this.myProject = project;
    }

    public void setRootPsiElement(PsiElement rootPsiElement) {
        this.myRootPsiElement = rootPsiElement;
    }

    public PsiElement getRootPsiElement() {
        return this.myRootPsiElement;
    }

    public Object getRootElement() {
        return this.myRootElement;
    }

    public Object[] getChildElements(Object element) {
        if (this.myRootElement == element) {
            if (this.myRootPsiElement == null) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            if (!(this.myRootPsiElement instanceof PsiFile)) {
                return new Object[]{this.myRootPsiElement};
            }
            List files = ((PsiFile)this.myRootPsiElement).getViewProvider().getAllFiles();
            return PsiUtilCore.toPsiFileArray((Collection)files);
        }
        Object[][] children2 = new Object[][]{ArrayUtil.EMPTY_OBJECT_ARRAY};
        ApplicationManager.getApplication().runReadAction(() -> {
            Object[] result2;
            if (this.myShowTreeNodes) {
                ASTNode root;
                ArrayList<ASTNode> list2 = new ArrayList<ASTNode>();
                Object object = element instanceof PsiElement ? SourceTreeToPsiMap.psiElementToTree((PsiElement)element) : (root = element instanceof ASTNode ? (ASTNode)element : null);
                if (element instanceof Inject) {
                    root = SourceTreeToPsiMap.psiElementToTree(((Inject)element).getPsi());
                }
                if (root != null) {
                    for (ASTNode child = root.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                        if (!this.myShowWhiteSpaces && child.getElementType() == TokenType.WHITE_SPACE) continue;
                        PsiElement childElement = child.getPsi();
                        list2.add((ASTNode)(childElement == null ? child : childElement));
                    }
                    PsiElement psi = root.getPsi();
                    if (psi instanceof PsiLanguageInjectionHost) {
                        InjectedLanguageUtil.enumerate(psi, (injectedPsi, places) -> list2.add((ASTNode)new Inject(psi, (PsiElement)injectedPsi)));
                    }
                }
                result2 = ArrayUtil.toObjectArray(list2);
            } else {
                PsiElement[] elementChildren = ((PsiElement)element).getChildren();
                if (!this.myShowWhiteSpaces) {
                    ArrayList<PsiElement> childrenList = new ArrayList<PsiElement>(elementChildren.length);
                    for (PsiElement psiElement : elementChildren) {
                        if (!this.myShowWhiteSpaces && psiElement instanceof PsiWhiteSpace) continue;
                        childrenList.add(psiElement);
                    }
                    result2 = PsiUtilCore.toPsiElementArray(childrenList);
                } else {
                    result2 = elementChildren;
                }
            }
            children2[0] = result2;
        });
        return children2[0];
    }

    public Object getParentElement(Object element) {
        if (element == this.myRootElement) {
            return null;
        }
        if (element == this.myRootPsiElement) {
            return this.myRootElement;
        }
        if (element instanceof PsiFile && InjectedLanguageManager.getInstance((Project)((PsiFile)element).getProject()).getInjectionHost((PsiElement)((PsiFile)element)) != null) {
            return new Inject((PsiElement)InjectedLanguageManager.getInstance((Project)((PsiFile)element).getProject()).getInjectionHost((PsiElement)((PsiFile)element)), (PsiElement)element);
        }
        return element instanceof Inject ? ((Inject)element).getParent() : ((PsiElement)element).getContext();
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        if (element == this.myRootElement) {
            NodeDescriptor nodeDescriptor = new NodeDescriptor(this.myProject, null){

                public boolean update() {
                    return false;
                }

                public Object getElement() {
                    return ViewerTreeStructure.this.myRootElement;
                }
            };
            if (nodeDescriptor == null) {
                ViewerTreeStructure.$$$reportNull$$$0(0);
            }
            return nodeDescriptor;
        }
        ViewerNodeDescriptor viewerNodeDescriptor = new ViewerNodeDescriptor(this.myProject, element, parentDescriptor);
        if (viewerNodeDescriptor == null) {
            ViewerTreeStructure.$$$reportNull$$$0(1);
        }
        return viewerNodeDescriptor;
    }

    public boolean isShowWhiteSpaces() {
        return this.myShowWhiteSpaces;
    }

    public void setShowWhiteSpaces(boolean showWhiteSpaces) {
        this.myShowWhiteSpaces = showWhiteSpaces;
    }

    public boolean isShowTreeNodes() {
        return this.myShowTreeNodes;
    }

    public void setShowTreeNodes(boolean showTreeNodes) {
        this.myShowTreeNodes = showTreeNodes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/psiView/ViewerTreeStructure", "createDescriptor"));
    }

    static class Inject {
        private final PsiElement myParent;
        private final PsiElement myPsi;

        Inject(PsiElement parent, PsiElement psi) {
            this.myParent = parent;
            this.myPsi = psi;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        public PsiElement getPsi() {
            return this.myPsi;
        }

        public String toString() {
            return "INJECTION " + this.myPsi.getLanguage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Inject inject = (Inject)o;
            if (!this.myParent.equals(inject.myParent)) {
                return false;
            }
            return this.myPsi.equals(inject.myPsi);
        }

        public int hashCode() {
            int result2 = this.myParent.hashCode();
            result2 = 31 * result2 + this.myPsi.hashCode();
            return result2;
        }
    }
}

