/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.connect.RemotelyConfigurableStatisticsService;
import com.intellij.internal.statistic.connect.StatisticsConnectionService;
import com.intellij.internal.statistic.connect.StatisticsHttpClientSender;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.persistence.SentUsagesPersistence;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StatisticsUploadAssistant {
    private static final Logger LOG = Logger.getInstance(UsagesCollector.class);
    public static final Object LOCK = new Object();
    private static final KeyedExtensionCollector<StatisticsService, String> COLLECTOR = new KeyedExtensionCollector("com.intellij.statisticsService");

    public String getData() {
        return this.getData(Collections.emptySet());
    }

    public static boolean isShouldShowNotification() {
        return UsageStatisticsPersistenceComponent.getInstance().isShowNotification() && System.currentTimeMillis() - 604800000L > ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFirstRunTime();
    }

    public static boolean isTimeToSend() {
        return StatisticsUploadAssistant.isTimeToSend(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isTimeToSend(UsageStatisticsPersistenceComponent settings) {
        long timeDelta = System.currentTimeMillis() - settings.getLastTimeSent();
        return Math.abs(timeDelta) > settings.getPeriod().getMillis();
    }

    public static boolean isSendAllowed() {
        return StatisticsUploadAssistant.isSendAllowed(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isSendAllowed(SentUsagesPersistence settings) {
        return settings != null && settings.isAllowed();
    }

    public String getData(@NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(0);
        }
        return StatisticsUploadAssistant.getDataString(disabledGroups);
    }

    public static void updateSentTime() {
        UsageStatisticsPersistenceComponent.getInstance().setSentTime(System.currentTimeMillis());
    }

    @NotNull
    public static String getDataString(@NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(1);
        }
        String string = StatisticsUploadAssistant.getDataString(disabledGroups, 0);
        if (string == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getDataString(@NotNull Set<String> disabledGroups, int maxSize) {
        if (disabledGroups == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(3);
        }
        String string = StatisticsUploadAssistant.getDataString(StatisticsUploadAssistant.getAllUsages(disabledGroups), maxSize);
        if (string == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static <T extends UsageDescriptor> String getDataString(@NotNull Map<GroupDescriptor, Set<T>> usages, int maxSize) {
        if (usages == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(5);
        }
        if (usages.isEmpty()) {
            return "";
        }
        String dataStr = ConvertUsagesUtil.convertUsages(usages);
        return maxSize > 0 && dataStr.getBytes(CharsetToolkit.UTF8_CHARSET).length > maxSize ? ConvertUsagesUtil.cutDataString(dataStr, maxSize) : dataStr;
    }

    public static StatisticsService getStatisticsService() {
        StatisticsService service;
        String key = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getStatisticsServiceKey();
        StatisticsService statisticsService = service = key == null ? null : (StatisticsService)COLLECTOR.findSingle((Object)key);
        if (service != null) {
            return service;
        }
        return new RemotelyConfigurableStatisticsService(new StatisticsConnectionService(), new StatisticsHttpClientSender(), new StatisticsUploadAssistant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static Map<GroupDescriptor, Set<UsageDescriptor>> getAllUsages(@NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(6);
        }
        Object object = LOCK;
        // MONITORENTER : object
        LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> usageDescriptors = new LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>>();
        UsagesCollector[] usagesCollectorArray = (UsagesCollector[])UsagesCollector.EP_NAME.getExtensions();
        int n = usagesCollectorArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> linkedHashMap = usageDescriptors;
                // MONITOREXIT : object
                if (linkedHashMap != null) return linkedHashMap;
                StatisticsUploadAssistant.$$$reportNull$$$0(7);
                return linkedHashMap;
            }
            UsagesCollector usagesCollector = usagesCollectorArray[n2];
            GroupDescriptor groupDescriptor = usagesCollector.getGroupId();
            if (!disabledGroups.contains(groupDescriptor.getId())) {
                try {
                    usageDescriptors.merge(groupDescriptor, usagesCollector.getUsages(), ContainerUtil::union);
                }
                catch (CollectUsagesException e) {
                    LOG.info((Throwable)e);
                }
            }
            ++n2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledGroups";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDataString";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

