/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl.actionholder;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.actionholder.IdActionRef;
import com.intellij.openapi.actionSystem.impl.actionholder.SimpleActionRef;

public abstract class ActionRef<T extends AnAction> {
    private static ActionManager ourManager;

    static ActionManager getManager() {
        if (ourManager == null) {
            ourManager = ActionManager.getInstance();
        }
        return ourManager;
    }

    public static <T extends AnAction> ActionRef<T> fromAction(T action) {
        String id = ActionRef.getManager().getId(action);
        return id == null ? new SimpleActionRef<T>(action) : new IdActionRef(id);
    }

    public abstract T getAction();
}

