/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diff.impl.settings.DiffMergeEditorSetting;
import com.intellij.openapi.diff.impl.settings.DiffMergeSettings;
import com.intellij.openapi.editor.Editor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffMergeSettingsAction
extends ActionGroup {
    @NotNull
    private final Collection<Editor> myEditors;
    @NotNull
    private final DiffMergeSettings mySettings;

    public DiffMergeSettingsAction(@NotNull Collection<Editor> editors, @NotNull DiffMergeSettings settings) {
        if (editors == null) {
            DiffMergeSettingsAction.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DiffMergeSettingsAction.$$$reportNull$$$0(1);
        }
        super("Settings", null, AllIcons.General.SecondaryGroup);
        this.setPopup(true);
        this.myEditors = editors;
        this.mySettings = settings;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = new AnAction[]{new DiffMergeToggleAction("EditorToggleShowWhitespaces", DiffMergeEditorSetting.WHITESPACES, this.myEditors, this.mySettings), new DiffMergeToggleAction("EditorToggleShowLineNumbers", DiffMergeEditorSetting.LINE_NUMBERS, this.myEditors, this.mySettings), new DiffMergeToggleAction("EditorToggleShowIndentLines", DiffMergeEditorSetting.INDENT_LINES, this.myEditors, this.mySettings), new DiffMergeToggleAction("EditorToggleUseSoftWraps", DiffMergeEditorSetting.SOFT_WRAPS, this.myEditors, this.mySettings)};
        if (anActionArray == null) {
            DiffMergeSettingsAction.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DiffMergeToggleAction
    extends ToggleAction {
        @NotNull
        private final DiffMergeEditorSetting mySetting;
        @NotNull
        private final Collection<Editor> myEditors;
        @NotNull
        private final DiffMergeSettings mySettings;

        private DiffMergeToggleAction(@NotNull String actionId, @NotNull DiffMergeEditorSetting setting, @NotNull Collection<Editor> editors, @NotNull DiffMergeSettings settings) {
            if (actionId == null) {
                DiffMergeToggleAction.$$$reportNull$$$0(0);
            }
            if (setting == null) {
                DiffMergeToggleAction.$$$reportNull$$$0(1);
            }
            if (editors == null) {
                DiffMergeToggleAction.$$$reportNull$$$0(2);
            }
            if (settings == null) {
                DiffMergeToggleAction.$$$reportNull$$$0(3);
            }
            super(ActionsBundle.actionText((String)actionId), ActionsBundle.actionDescription((String)actionId), null);
            this.mySetting = setting;
            this.myEditors = editors;
            this.mySettings = settings;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.getPreference(this.mySetting);
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            this.setPreference(this.mySetting, state2);
            for (Editor editor : this.myEditors) {
                this.mySetting.apply(editor, state2);
            }
        }

        private void setPreference(DiffMergeEditorSetting preference, boolean state2) {
            this.mySettings.setPreference(preference, state2);
        }

        private boolean getPreference(DiffMergeEditorSetting preference) {
            return this.mySettings.getPreference(preference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "setting";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editors";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/diff/impl/settings/DiffMergeSettingsAction$DiffMergeToggleAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

