/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;

public class FoldingTransformation
implements Transformation {
    private final Editor myEditor;
    private final ArrayList<FoldRegion> myCollapsed = new ArrayList();
    private final int[] myFoldBeginings;

    public FoldingTransformation(Editor editor) {
        this.myEditor = editor;
        FoldRegion[] foldRegions = this.myEditor.getFoldingModel().getAllFoldRegions();
        Arrays.sort(foldRegions, RangeMarker.BY_START_OFFSET);
        TIntArrayList foldBeginings = new TIntArrayList();
        for (FoldRegion foldRegion : foldRegions) {
            if (!foldRegion.isValid() || foldRegion.isExpanded()) continue;
            foldBeginings.add(this.getStartLine(foldRegion));
            this.myCollapsed.add(foldRegion);
        }
        this.myFoldBeginings = foldBeginings.toNativeArray();
    }

    private int getStartLine(FoldRegion foldRegion) {
        return this.myEditor.offsetToLogicalPosition((int)foldRegion.getStartOffset()).line;
    }

    @Override
    public int transform(int line) {
        JComponent header;
        FoldRegion foldRegion = this.findFoldRegion(line);
        int yOffset = 0;
        if (foldRegion != null) {
            int startLine = this.getStartLine(foldRegion);
            yOffset = (int)((double)(line - startLine) / (double)this.getLineLength(foldRegion) * (double)this.myEditor.getLineHeight());
            line = startLine;
        }
        int headerOffset = (header = this.myEditor.getHeaderComponent()) == null ? 0 : header.getHeight();
        return (yOffset += this.myEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y) - this.myEditor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
    }

    private int getLineLength(FoldRegion foldRegion) {
        return this.getEndLine(foldRegion) - this.getStartLine(foldRegion);
    }

    private int getEndLine(FoldRegion foldRegion) {
        return this.myEditor.offsetToLogicalPosition((int)foldRegion.getEndOffset()).line;
    }

    private FoldRegion findFoldRegion(int line) {
        FoldRegion region;
        int index = Arrays.binarySearch(this.myFoldBeginings, line);
        if (index >= 0) {
            region = this.myCollapsed.get(index);
        } else {
            if ((index = -index - 1) == 0) {
                return null;
            }
            region = this.myCollapsed.get(index - 1);
        }
        if (this.getEndLine(region) < line) {
            return null;
        }
        return region;
    }
}

