/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressSuspender {
    private static final Key<ProgressSuspender> PROGRESS_SUSPENDER = Key.create((String)"PROGRESS_SUSPENDER");
    private final Object myLock;
    private final Thread myThread;
    private static final Application ourApp = ApplicationManager.getApplication();
    private volatile boolean mySuspended;
    private final CoreProgressManager.CheckCanceledHook myHook;

    private ProgressSuspender(@NotNull ProgressIndicatorEx progress) {
        if (progress == null) {
            ProgressSuspender.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myHook = this::freezeIfNeeded;
        assert (progress.isRunning());
        assert (ProgressIndicatorProvider.getGlobalProgressIndicator() == progress);
        this.myThread = Thread.currentThread();
        ((UserDataHolder)progress).putUserData(PROGRESS_SUSPENDER, (Object)this);
        new ProgressIndicatorListenerAdapter(){

            @Override
            public void cancelled() {
                ProgressSuspender.this.setSuspended(false);
            }
        }.installToProgress(progress);
    }

    public static void markSuspendable(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressSuspender.$$$reportNull$$$0(1);
        }
        new ProgressSuspender((ProgressIndicatorEx)indicator);
    }

    @Nullable
    public static ProgressSuspender getSuspender(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressSuspender.$$$reportNull$$$0(2);
        }
        return indicator instanceof UserDataHolder ? (ProgressSuspender)((UserDataHolder)indicator).getUserData(PROGRESS_SUSPENDER) : null;
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(boolean suspended) {
        Object object = this.myLock;
        synchronized (object) {
            if (suspended == this.mySuspended) {
                return;
            }
            this.mySuspended = suspended;
            ProgressManagerImpl manager = (ProgressManagerImpl)ProgressManager.getInstance();
            if (suspended) {
                manager.addCheckCanceledHook(this.myHook);
            } else {
                manager.removeCheckCanceledHook(this.myHook);
                this.myLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean freezeIfNeeded(@Nullable ProgressIndicator current) {
        if (current == null || ourApp.isReadAccessAllowed() || !CoreProgressManager.isThreadUnderIndicator(current, this.myThread)) {
            return false;
        }
        Object object = this.myLock;
        synchronized (object) {
            while (this.mySuspended) {
                try {
                    this.myLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressSuspender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "markSuspendable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuspender";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

