/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.changes.FictiveBackgroundable;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.Waiter;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CallbackData {
    private static final Logger LOG = Logger.getInstance(CallbackData.class);
    @NotNull
    private final Runnable myCallback;
    @NotNull
    private final Runnable myWrapperStarter;

    CallbackData(@NotNull Runnable callback, @NotNull Runnable wrapperStarter) {
        if (callback == null) {
            CallbackData.$$$reportNull$$$0(0);
        }
        if (wrapperStarter == null) {
            CallbackData.$$$reportNull$$$0(1);
        }
        this.myCallback = callback;
        this.myWrapperStarter = wrapperStarter;
    }

    @NotNull
    public Runnable getCallback() {
        Runnable runnable2 = this.myCallback;
        if (runnable2 == null) {
            CallbackData.$$$reportNull$$$0(2);
        }
        return runnable2;
    }

    @NotNull
    public Runnable getWrapperStarter() {
        Runnable runnable2 = this.myWrapperStarter;
        if (runnable2 == null) {
            CallbackData.$$$reportNull$$$0(3);
        }
        return runnable2;
    }

    @NotNull
    public static CallbackData create(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, @Nullable String title, @Nullable ModalityState state2) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(5);
        }
        if (afterUpdate == null) {
            CallbackData.$$$reportNull$$$0(6);
        }
        CallbackData callbackData = mode.isSilent() ? CallbackData.createSilent(project, mode, afterUpdate) : CallbackData.createInteractive(project, mode, afterUpdate, title, state2);
        if (callbackData == null) {
            CallbackData.$$$reportNull$$$0(7);
        }
        return callbackData;
    }

    @NotNull
    private static CallbackData createSilent(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(9);
        }
        if (afterUpdate == null) {
            CallbackData.$$$reportNull$$$0(10);
        }
        Consumer<Runnable> callbackCaller = mode.isCallbackOnAwt() ? arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0) : arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
        Runnable callback = () -> {
            if (project == null) {
                CallbackData.$$$reportNull$$$0(21);
            }
            if (mode == null) {
                CallbackData.$$$reportNull$$$0(22);
            }
            if (afterUpdate == null) {
                CallbackData.$$$reportNull$$$0(23);
            }
            CallbackData.logUpdateFinished(project, mode);
            if (!project.isDisposed()) {
                afterUpdate.run();
            }
        };
        CallbackData callbackData = new CallbackData(() -> callbackCaller.accept(callback), EmptyRunnable.INSTANCE);
        if (callbackData == null) {
            CallbackData.$$$reportNull$$$0(11);
        }
        return callbackData;
    }

    @NotNull
    private static CallbackData createInteractive(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, String title, @Nullable ModalityState state2) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(12);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(13);
        }
        if (afterUpdate == null) {
            CallbackData.$$$reportNull$$$0(14);
        }
        Object task2 = mode.isSynchronous() ? new Waiter(project, afterUpdate, title, mode.isCancellable()) : new FictiveBackgroundable(project, afterUpdate, title, mode.isCancellable(), state2);
        Runnable callback = () -> CallbackData.lambda$createInteractive$2(project, mode, (Task)task2);
        CallbackData callbackData = new CallbackData(callback, () -> CallbackData.lambda$createInteractive$3((Task)task2));
        if (callbackData == null) {
            CallbackData.$$$reportNull$$$0(15);
        }
        return callbackData;
    }

    private static void setDone(@NotNull Task task2) {
        if (task2 == null) {
            CallbackData.$$$reportNull$$$0(16);
        }
        if (task2 instanceof Waiter) {
            ((Waiter)task2).done();
        } else if (task2 instanceof FictiveBackgroundable) {
            ((FictiveBackgroundable)task2).done();
        } else {
            throw new IllegalArgumentException("Unknown task type " + task2.getClass());
        }
    }

    private static void logUpdateFinished(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(17);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(18);
        }
        LOG.debug(mode + " changes update finished for project " + project.getName());
    }

    private static /* synthetic */ void lambda$createInteractive$3(Task task2) {
        ProgressManager.getInstance().run(task2);
    }

    private static /* synthetic */ void lambda$createInteractive$2(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, Task task2) {
        if (project == null) {
            CallbackData.$$$reportNull$$$0(19);
        }
        if (mode == null) {
            CallbackData.$$$reportNull$$$0(20);
        }
        CallbackData.logUpdateFinished(project, mode);
        CallbackData.setDone(task2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperStarter";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/CallbackData";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/CallbackData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallback";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperStarter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSilent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createInteractive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSilent";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createInteractive";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDone";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logUpdateFinished";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createInteractive$2";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSilent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

