/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.Arrays;

public class RollbackDialogAction
extends AnAction
implements DumbAware {
    public RollbackDialogAction() {
        ActionUtil.copyFrom((AnAction)this, (String)"ChangesView.Revert");
    }

    public void actionPerformed(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Change[] changes = (Change[])e.getRequiredData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        RollbackChangesDialog.rollbackChanges(project, Arrays.asList(changes));
    }

    public void update(AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = changes != null && project != null;
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            String operationName = RollbackUtil.getRollbackOperationName(project);
            e.getPresentation().setText(operationName + "...");
            e.getPresentation().setDescription(operationName + " selected changes");
        }
    }
}

