/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddList
implements ChangeListCommand {
    @NotNull
    private final String myName;
    @Nullable
    private final String myComment;
    @Nullable
    private final ChangeListData myData;
    private boolean myWasListCreated;
    private LocalChangeList myNewListCopy;
    private String myOldComment;

    public AddList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        if (name == null) {
            AddList.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myComment = comment;
        this.myData = data;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        LocalChangeList list2 = worker.getChangeListByName(this.myName);
        if (list2 == null) {
            String id = this.myNewListCopy != null ? this.myNewListCopy.getId() : null;
            this.myWasListCreated = true;
            this.myOldComment = null;
            this.myNewListCopy = worker.addChangeList(this.myName, this.myComment, id, this.myData).copy();
        } else if (StringUtil.isNotEmpty((String)this.myComment)) {
            this.myWasListCreated = false;
            this.myOldComment = worker.editComment(this.myName, this.myComment);
            this.myNewListCopy = list2.copy();
        } else {
            this.myWasListCreated = false;
            this.myOldComment = null;
            this.myNewListCopy = list2.copy();
        }
    }

    @Override
    public void doNotify(EventDispatcher<ChangeListListener> dispatcher) {
        if (this.myWasListCreated) {
            ((ChangeListListener)dispatcher.getMulticaster()).changeListAdded((ChangeList)this.myNewListCopy);
        } else if (this.myOldComment != null) {
            ((ChangeListListener)dispatcher.getMulticaster()).changeListCommentChanged((ChangeList)this.myNewListCopy, this.myOldComment);
        }
    }

    @NotNull
    public LocalChangeList getNewListCopy() {
        LocalChangeList localChangeList = this.myNewListCopy;
        if (localChangeList == null) {
            AddList.$$$reportNull$$$0(1);
        }
        return localChangeList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/local/AddList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/local/AddList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewListCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

