/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ClipboardAnalyzeListener;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchFromClipboardAction;
import com.intellij.openapi.wm.IdeFrame;
import org.jetbrains.annotations.NotNull;

public class PatchClipboardTracker
implements Disposable,
ApplicationComponent {
    private static final PatchClipboardListener LISTENER = new PatchClipboardListener();

    public void initComponent() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ApplicationActivationListener.TOPIC, (Object)LISTENER);
    }

    public void dispose() {
    }

    private static class PatchClipboardListener
    extends ClipboardAnalyzeListener {
        private PatchClipboardListener() {
        }

        @Override
        public void applicationActivated(IdeFrame ideFrame) {
            if (!VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY) {
                return;
            }
            super.applicationActivated(ideFrame);
        }

        @Override
        public void applicationDeactivated(IdeFrame ideFrame) {
            if (!VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY) {
                return;
            }
            super.applicationDeactivated(ideFrame);
        }

        @Override
        protected void handle(@NotNull Project project, @NotNull String value) {
            if (project == null) {
                PatchClipboardListener.$$$reportNull$$$0(0);
            }
            if (value == null) {
                PatchClipboardListener.$$$reportNull$$$0(1);
            }
            new ApplyPatchFromClipboardAction.MyApplyPatchFromClipboardDialog(project, value).show();
        }

        @Override
        public boolean canHandle(@NotNull String value) {
            if (value == null) {
                PatchClipboardListener.$$$reportNull$$$0(2);
            }
            return PatchReader.isPatchContent(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/PatchClipboardTracker$PatchClipboardListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canHandle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

