/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vcs.actions.ShowNextChangeMarkerAction;
import com.intellij.openapi.vcs.actions.ShowPrevChangeMarkerAction;
import com.intellij.openapi.vcs.ex.CopyLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopup;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.ShowLineStatusRangeDiffAction;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTrackerDrawing {
    private LineStatusTrackerDrawing() {
    }

    public static void moveToRange(Range range, Editor editor, LineStatusTracker tracker) {
        new MyLineStatusMarkerPopup(tracker, editor, range).scrollAndShow();
    }

    public static void showHint(Range range, Editor editor, LineStatusTracker tracker) {
        new MyLineStatusMarkerPopup(tracker, editor, range).showAfterScroll();
    }

    private static class ToggleByWordDiffAction
    extends LineStatusMarkerPopup.ToggleByWordDiffActionBase {
        @NotNull
        private final Range myRange;
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final LineStatusTracker myTracker;
        @Nullable
        private final Point myMousePosition;

        public ToggleByWordDiffAction(@NotNull Range range, @NotNull Editor editor, @NotNull LineStatusTracker tracker, @Nullable Point mousePosition) {
            if (range == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(1);
            }
            if (tracker == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(2);
            }
            this.myRange = range;
            this.myEditor = editor;
            this.myTracker = tracker;
            this.myMousePosition = mousePosition;
        }

        @Override
        protected void reshowPopup() {
            new MyLineStatusMarkerPopup(this.myTracker, this.myEditor, this.myRange).showHintAt(this.myMousePosition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tracker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$ToggleByWordDiffAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyLineStatusMarkerPopup
    extends LineStatusMarkerPopup {
        @NotNull
        private final LineStatusTracker myTracker;

        public MyLineStatusMarkerPopup(@NotNull LineStatusTracker tracker, @NotNull Editor editor, @NotNull Range range) {
            if (tracker == null) {
                MyLineStatusMarkerPopup.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyLineStatusMarkerPopup.$$$reportNull$$$0(1);
            }
            if (range == null) {
                MyLineStatusMarkerPopup.$$$reportNull$$$0(2);
            }
            super(tracker, editor, range);
            this.myTracker = tracker;
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions(@Nullable Point mousePosition) {
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            actions.add((AnAction)new ShowPrevChangeMarkerAction(this.myTracker.getPrevRange(this.myRange), this.myTracker, this.myEditor));
            actions.add((AnAction)new ShowNextChangeMarkerAction(this.myTracker.getNextRange(this.myRange), this.myTracker, this.myEditor));
            actions.add((AnAction)new RollbackLineStatusRangeAction(this.myTracker, this.myRange, this.myEditor));
            actions.add((AnAction)new ShowLineStatusRangeDiffAction(this.myTracker, this.myRange, this.myEditor));
            actions.add((AnAction)new CopyLineStatusRangeAction(this.myTracker, this.myRange));
            actions.add((AnAction)new ToggleByWordDiffAction(this.myRange, this.myEditor, this.myTracker, mousePosition));
            ArrayList<AnAction> arrayList = actions;
            if (arrayList == null) {
                MyLineStatusMarkerPopup.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            FileType fileType = this.myTracker.getVirtualFile().getFileType();
            if (fileType == null) {
                MyLineStatusMarkerPopup.$$$reportNull$$$0(4);
            }
            return fileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

