/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ActionType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RestoreUpdateTree;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommonUpdateAction
extends AbstractVcsAction {
    private final boolean myAlwaysVisible;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.update.AbstractCommonUpdateAction");
    private final ActionInfo myActionInfo;
    private final ScopeInfo myScopeInfo;

    protected AbstractCommonUpdateAction(ActionInfo actionInfo, ScopeInfo scopeInfo, boolean alwaysVisible) {
        this.myActionInfo = actionInfo;
        this.myScopeInfo = scopeInfo;
        this.myAlwaysVisible = alwaysVisible;
    }

    private String getCompleteActionName(VcsContext dataContext) {
        return this.myActionInfo.getActionName(this.myScopeInfo.getScopeName(dataContext, this.myActionInfo));
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(0);
        }
        Project project = context.getProject();
        boolean showUpdateOptions = this.myActionInfo.showOptions(project);
        LOG.debug(String.format("project: %s, show update options: %s", project, showUpdateOptions));
        if (project != null) {
            try {
                FilePath[] filePaths = this.myScopeInfo.getRoots(context, this.myActionInfo);
                FilePath[] roots = DescindingFilesFilter.filterDescindingFiles(this.filterRoots(filePaths, context), project);
                if (roots.length == 0) {
                    LOG.debug("No roots found.");
                    return;
                }
                Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles = this.createVcsToFilesMap(roots, project);
                for (AbstractVcs vcs : vcsToVirtualFiles.keySet()) {
                    UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                    if (updateEnvironment == null || updateEnvironment.validateOptions(vcsToVirtualFiles.get(vcs))) continue;
                    LOG.debug("Options not valid for files: " + vcsToVirtualFiles);
                    return;
                }
                if (showUpdateOptions || OptionsDialog.shiftIsPressed((int)context.getModifiers())) {
                    this.showOptionsDialog(vcsToVirtualFiles, project, context);
                }
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    ApplicationManager.getApplication().saveAll();
                }
                Updater task2 = new Updater(project, roots, vcsToVirtualFiles);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    task2.run((ProgressIndicator)new EmptyProgressIndicator());
                } else {
                    ProgressManager.getInstance().run((Task)task2);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    private boolean canGroupByChangelist(Set<AbstractVcs> abstractVcses) {
        if (this.myActionInfo.canGroupByChangelist()) {
            for (AbstractVcs vcs : abstractVcses) {
                if (vcs.getCachingCommittedChangesProvider() == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean someSessionWasCanceled(List<UpdateSession> updateSessions) {
        for (UpdateSession updateSession : updateSessions) {
            if (!updateSession.isCanceled()) continue;
            return true;
        }
        return false;
    }

    private static String getAllFilesAreUpToDateMessage(FilePath[] roots) {
        if (roots.length == 1 && !roots[0].isDirectory()) {
            return VcsBundle.message((String)"message.text.file.is.up.to.date", (Object[])new Object[0]);
        }
        return VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0]);
    }

    private void showOptionsDialog(Map<AbstractVcs, Collection<FilePath>> updateEnvToVirtualFiles, Project project, VcsContext dataContext) {
        UpdateOrStatusOptionsDialog dialogOrStatus;
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = this.createConfigurableToEnvMap(updateEnvToVirtualFiles);
        LOG.debug("configurables map: " + envToConfMap);
        if (!envToConfMap.isEmpty() && !(dialogOrStatus = this.myActionInfo.createOptionsDialog(project, envToConfMap, this.myScopeInfo.getScopeName(dataContext, this.myActionInfo))).showAndGet()) {
            throw new ProcessCanceledException();
        }
    }

    private LinkedHashMap<Configurable, AbstractVcs> createConfigurableToEnvMap(Map<AbstractVcs, Collection<FilePath>> updateEnvToVirtualFiles) {
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = new LinkedHashMap<Configurable, AbstractVcs>();
        for (AbstractVcs vcs : updateEnvToVirtualFiles.keySet()) {
            Configurable configurable = this.myActionInfo.getEnvironment(vcs).createConfigurable(updateEnvToVirtualFiles.get(vcs));
            if (configurable == null) continue;
            envToConfMap.put(configurable, vcs);
        }
        return envToConfMap;
    }

    private Map<AbstractVcs, Collection<FilePath>> createVcsToFilesMap(@NotNull FilePath[] roots, @NotNull Project project) {
        if (roots == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(2);
        }
        MultiMap resultPrep = MultiMap.createSet();
        for (FilePath file2 : roots) {
            UpdateEnvironment updateEnvironment;
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file2);
            if (vcs == null || (updateEnvironment = this.myActionInfo.getEnvironment(vcs)) == null) continue;
            resultPrep.putValue((Object)vcs, (Object)file2);
        }
        THashMap result2 = new THashMap();
        for (Map.Entry entry : resultPrep.entrySet()) {
            AbstractVcs vcs = (AbstractVcs)entry.getKey();
            result2.put(vcs, vcs.filterUniqueRoots(new ArrayList((Collection)entry.getValue()), FilePath::getVirtualFile));
        }
        return result2;
    }

    @NotNull
    private FilePath[] filterRoots(FilePath[] roots, VcsContext vcsContext) {
        ArrayList<FilePath> result2 = new ArrayList<FilePath>();
        Project project = vcsContext.getProject();
        assert (project != null);
        for (FilePath file2 : roots) {
            VirtualFile[] vcsRoots;
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file2);
            if (vcs == null) continue;
            if (!this.myScopeInfo.filterExistsInVcs() || AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)file2)) {
                UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                if (updateEnvironment == null) continue;
                result2.add(file2);
                continue;
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null || !virtualFile.isDirectory()) continue;
            for (VirtualFile vcsRoot : vcsRoots = ProjectLevelVcsManager.getInstance((Project)vcsContext.getProject()).getAllVersionedRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)vcsRoot, (boolean)false)) continue;
                result2.add(file2);
            }
        }
        FilePath[] filePathArray = result2.toArray(new FilePath[result2.size()]);
        if (filePathArray == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(3);
        }
        return filePathArray;
    }

    protected abstract boolean filterRootsBeforeAction();

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        Project project;
        if (vcsContext == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(4);
        }
        if (presentation == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(5);
        }
        if ((project = vcsContext.getProject()) != null) {
            FilePath[] roots;
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            boolean underVcs = vcsManager.hasActiveVcss();
            if (!underVcs) {
                presentation.setVisible(false);
                return;
            }
            String actionName = this.getCompleteActionName(vcsContext);
            if (this.myActionInfo.showOptions(project) || OptionsDialog.shiftIsPressed((int)vcsContext.getModifiers())) {
                actionName = actionName + "...";
            }
            presentation.setText(actionName);
            presentation.setVisible(true);
            presentation.setEnabled(true);
            if (AbstractCommonUpdateAction.supportingVcsesAreEmpty(vcsManager, this.myActionInfo)) {
                presentation.setVisible(this.myAlwaysVisible);
                presentation.setEnabled(false);
                return;
            }
            if (this.filterRootsBeforeAction() && (roots = this.filterRoots(this.myScopeInfo.getRoots(vcsContext, this.myActionInfo), vcsContext)).length == 0) {
                presentation.setVisible(this.myAlwaysVisible);
                presentation.setEnabled(false);
                return;
            }
            if (presentation.isVisible() && presentation.isEnabled() && vcsManager.isBackgroundVcsOperationRunning()) {
                presentation.setEnabled(false);
            }
        } else {
            presentation.setVisible(false);
            presentation.setEnabled(false);
        }
    }

    private static boolean supportingVcsesAreEmpty(ProjectLevelVcsManager vcsManager, ActionInfo actionInfo) {
        AbstractVcs[] allActiveVcss;
        for (AbstractVcs activeVcs : allActiveVcss = vcsManager.getAllActiveVcss()) {
            if (actionInfo.getEnvironment(activeVcs) == null) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVcsToFilesMap";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Updater
    extends Task.Backgroundable {
        private final String LOCAL_HISTORY_ACTION;
        private final Project myProject;
        private final ProjectLevelVcsManagerEx myProjectLevelVcsManager;
        private UpdatedFiles myUpdatedFiles;
        private final FilePath[] myRoots;
        private final Map<AbstractVcs, Collection<FilePath>> myVcsToVirtualFiles;
        private final Map<HotfixData, List<VcsException>> myGroupedExceptions;
        private final List<UpdateSession> myUpdateSessions;
        private int myUpdateNumber;
        private final Map<AbstractVcs, SequentialUpdatesContext> myContextInfo;
        private final VcsDirtyScopeManager myDirtyScopeManager;
        private Label myBefore;
        private Label myAfter;
        private LocalHistoryAction myLocalHistoryAction;

        public Updater(Project project, FilePath[] roots, Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles) {
            super(project, AbstractCommonUpdateAction.this.getTemplatePresentation().getText(), true, VcsConfiguration.getInstance((Project)project).getUpdateOption());
            this.LOCAL_HISTORY_ACTION = VcsBundle.message((String)"local.history.update.from.vcs", (Object[])new Object[0]);
            this.myProject = project;
            this.myProjectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx(project);
            this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
            this.myRoots = roots;
            this.myVcsToVirtualFiles = vcsToVirtualFiles;
            this.myUpdatedFiles = UpdatedFiles.create();
            this.myGroupedExceptions = new HashMap<HotfixData, List<VcsException>>();
            this.myUpdateSessions = new ArrayList<UpdateSession>();
            this.myContextInfo = new HashMap<AbstractVcs, SequentialUpdatesContext>();
            this.myUpdateNumber = 1;
        }

        private void reset() {
            this.myUpdatedFiles = UpdatedFiles.create();
            this.myGroupedExceptions.clear();
            this.myUpdateSessions.clear();
            ++this.myUpdateNumber;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                Updater.$$$reportNull$$$0(0);
            }
            this.runImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runImpl() {
            ProjectManagerEx.getInstanceEx().blockReloadingProjectOnExternalChanges();
            this.myProjectLevelVcsManager.startBackgroundVcsOperation();
            this.myBefore = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before update");
            this.myLocalHistoryAction = LocalHistory.getInstance().startAction(this.LOCAL_HISTORY_ACTION);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            try {
                int toBeProcessed = this.myVcsToVirtualFiles.size();
                int processed2 = 0;
                for (AbstractVcs vcs : this.myVcsToVirtualFiles.keySet()) {
                    UpdateEnvironment updateEnvironment = AbstractCommonUpdateAction.this.myActionInfo.getEnvironment(vcs);
                    updateEnvironment.fillGroups(this.myUpdatedFiles);
                    Collection<FilePath> files = this.myVcsToVirtualFiles.get(vcs);
                    SequentialUpdatesContext context = this.myContextInfo.get(vcs);
                    Ref refContext = new Ref((Object)context);
                    UpdateSession updateSession = updateEnvironment.updateDirectories(files.toArray(new FilePath[files.size()]), this.myUpdatedFiles, progressIndicator, refContext);
                    this.myContextInfo.put(vcs, (SequentialUpdatesContext)refContext.get());
                    ++processed2;
                    if (progressIndicator != null) {
                        progressIndicator.setFraction((double)processed2 / (double)toBeProcessed);
                        progressIndicator.setText2("");
                    }
                    List exceptionList = updateSession.getExceptions();
                    this.gatherExceptions(vcs, exceptionList);
                    this.myUpdateSessions.add(updateSession);
                }
            }
            finally {
                try {
                    ProgressManager.progress((String)VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
                    this.doVfsRefresh();
                }
                finally {
                    this.myProjectLevelVcsManager.stopBackgroundVcsOperation();
                    BackgroundTaskUtil.syncPublisher(this.myProject, UpdatedFilesListener.UPDATED_FILES).consume(UpdatedFilesReverseSide.getPathsFromUpdatedFiles((UpdatedFiles)this.myUpdatedFiles));
                }
            }
        }

        private void gatherExceptions(AbstractVcs vcs, List<VcsException> exceptionList) {
            VcsExceptionsHotFixer fixer = vcs.getVcsExceptionsHotFixer();
            if (fixer == null) {
                this.putExceptions(null, exceptionList);
            } else {
                this.putExceptions(fixer.groupExceptions(ActionType.update, exceptionList));
            }
        }

        private void putExceptions(Map<HotfixData, List<VcsException>> map2) {
            for (Map.Entry<HotfixData, List<VcsException>> entry : map2.entrySet()) {
                this.putExceptions(entry.getKey(), entry.getValue());
            }
        }

        private void putExceptions(HotfixData key, @NotNull List<VcsException> list2) {
            if (list2 == null) {
                Updater.$$$reportNull$$$0(1);
            }
            if (list2.isEmpty()) {
                return;
            }
            this.myGroupedExceptions.computeIfAbsent(key, k -> new ArrayList()).addAll(list2);
        }

        private void doVfsRefresh() {
            LOG.info("Calling refresh files after update for roots: " + Arrays.toString(this.myRoots));
            RefreshVFsSynchronously.updateAllChanged(this.myUpdatedFiles);
            this.notifyAnnotations();
        }

        private void notifyAnnotations() {
            final VcsAnnotationRefresher refresher = BackgroundTaskUtil.syncPublisher(this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED);
            UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(this.myUpdatedFiles, new UpdateFilesHelper.Callback(){

                @Override
                public void onFile(String filePath, String groupId) {
                    refresher.dirty(filePath);
                }
            });
        }

        @NotNull
        private Notification prepareNotification(@NotNull UpdateInfoTree tree, boolean someSessionWasCancelled) {
            NotificationType type;
            String content;
            String title;
            if (tree == null) {
                Updater.$$$reportNull$$$0(2);
            }
            int allFiles = this.getUpdatedFilesCount();
            if (someSessionWasCancelled) {
                title = "Project Partially Updated";
                content = allFiles + " " + StringUtil.pluralize((String)"file", (int)allFiles) + " updated";
                type = NotificationType.WARNING;
            } else {
                title = allFiles + " Project " + StringUtil.pluralize((String)"File", (int)allFiles) + " Updated";
                content = StringUtil.notNullize((String)this.prepareScopeUpdatedText(tree));
                type = NotificationType.INFORMATION;
            }
            Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification(title, content, type, null);
            if (notification == null) {
                Updater.$$$reportNull$$$0(3);
            }
            return notification;
        }

        private int getUpdatedFilesCount() {
            return this.myUpdatedFiles.getTopLevelGroups().stream().mapToInt(this::getFilesCount).sum();
        }

        private int getFilesCount(@NotNull FileGroup group) {
            if (group == null) {
                Updater.$$$reportNull$$$0(4);
            }
            return group.getFiles().size() + group.getChildren().stream().mapToInt(g -> this.getFilesCount((FileGroup)g)).sum();
        }

        @Nullable
        private String prepareScopeUpdatedText(@NotNull UpdateInfoTree tree) {
            if (tree == null) {
                Updater.$$$reportNull$$$0(5);
            }
            String scopeText = null;
            NamedScope scopeFilter = tree.getFilterScope();
            if (scopeFilter != null) {
                int filteredFiles = tree.getFilteredFilesCount();
                String filterName = scopeFilter.getName();
                scopeText = filteredFiles == 0 ? filterName + " wasn't modified" : filteredFiles + " in " + filterName;
            }
            return scopeText;
        }

        public void onSuccess() {
            this.onSuccessImpl(false);
        }

        private void onSuccessImpl(boolean wasCanceled) {
            if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
                ProjectManagerEx.getInstanceEx().unblockReloadingProjectOnExternalChanges();
                LocalHistory.getInstance().putSystemLabel(this.myProject, this.LOCAL_HISTORY_ACTION);
                return;
            }
            boolean continueChain = false;
            for (SequentialUpdatesContext context : this.myContextInfo.values()) {
                continueChain |= context != null && context.shouldFail();
            }
            boolean continueChainFinal = continueChain;
            boolean someSessionWasCancelled = wasCanceled || AbstractCommonUpdateAction.someSessionWasCanceled(this.myUpdateSessions);
            for (UpdateSession updateSession : this.myUpdateSessions) {
                updateSession.onRefreshFilesCompleted();
            }
            if (this.myLocalHistoryAction != null) {
                this.myLocalHistoryAction.finish();
            }
            this.myAfter = LocalHistory.getInstance().putSystemLabel(this.myProject, "After update");
            if (AbstractCommonUpdateAction.this.myActionInfo.canChangeFileStatus()) {
                final ArrayList files = new ArrayList();
                RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
                revisionsCache.invalidate(this.myUpdatedFiles);
                UpdateFilesHelper.iterateFileGroupFiles(this.myUpdatedFiles, new UpdateFilesHelper.Callback(){

                    @Override
                    public void onFile(String filePath, String groupId) {
                        String path = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
                        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(path);
                        if (file2 != null) {
                            files.add(file2);
                        }
                    }
                });
                this.myDirtyScopeManager.filesDirty(files, null);
            }
            boolean updateSuccess = !someSessionWasCancelled && this.myGroupedExceptions.isEmpty();
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> {
                if (this.myProject.isDisposed()) {
                    ProjectManagerEx.getInstanceEx().unblockReloadingProjectOnExternalChanges();
                    return;
                }
                if (!this.myGroupedExceptions.isEmpty()) {
                    if (continueChainFinal) {
                        this.gatherContextInterruptedMessages();
                    }
                    AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myGroupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{AbstractCommonUpdateAction.this.getTemplatePresentation().getText()}));
                } else if (someSessionWasCancelled) {
                    ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]));
                } else {
                    ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.done", (Object[])new Object[0]));
                }
                boolean noMerged = this.myUpdatedFiles.getGroupById("MERGED_WITH_CONFLICTS").isEmpty();
                if (this.myUpdatedFiles.isEmpty() && this.myGroupedExceptions.isEmpty()) {
                    NotificationType type;
                    String content;
                    if (someSessionWasCancelled) {
                        content = VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]);
                        type = NotificationType.WARNING;
                    } else {
                        content = AbstractCommonUpdateAction.getAllFilesAreUpToDateMessage(this.myRoots);
                        type = NotificationType.INFORMATION;
                    }
                    VcsNotifier.getInstance(this.myProject).notify(VcsNotifier.STANDARD_NOTIFICATION.createNotification(content, type));
                } else if (!this.myUpdatedFiles.isEmpty()) {
                    UpdateInfoTree tree = this.showUpdateTree(continueChainFinal && updateSuccess && noMerged, someSessionWasCancelled);
                    CommittedChangesCache cache = CommittedChangesCache.getInstance(this.myProject);
                    cache.processUpdatedFiles(this.myUpdatedFiles, (Consumer<List<CommittedChangeList>>)((Consumer)incomingChangeLists -> tree.setChangeLists((List<CommittedChangeList>)incomingChangeLists)));
                    Notification notification = this.prepareNotification(tree, someSessionWasCancelled);
                    notification.addAction((AnAction)new ViewUpdateInfoNotification(this.myProject, tree, "View", notification));
                    VcsNotifier.getInstance(this.myProject).notify(notification);
                }
                ProjectManagerEx.getInstanceEx().unblockReloadingProjectOnExternalChanges();
                if (continueChainFinal && updateSuccess) {
                    if (!noMerged) {
                        this.showContextInterruptedError();
                    } else {
                        this.reset();
                        ProgressManager.getInstance().run((Task)this);
                    }
                }
            }, null, (Project)this.myProject);
        }

        private void showContextInterruptedError() {
            this.gatherContextInterruptedMessages();
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myGroupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{AbstractCommonUpdateAction.this.getTemplatePresentation().getText()}));
        }

        private void gatherContextInterruptedMessages() {
            for (Map.Entry<AbstractVcs, SequentialUpdatesContext> entry : this.myContextInfo.entrySet()) {
                SequentialUpdatesContext context = entry.getValue();
                if (context == null || !context.shouldFail()) continue;
                VcsException exception = new VcsException(context.getMessageWhenInterruptedBeforeStart());
                this.gatherExceptions(entry.getKey(), Collections.singletonList(exception));
            }
        }

        @NotNull
        private UpdateInfoTree showUpdateTree(boolean willBeContinued, boolean wasCanceled) {
            RestoreUpdateTree restoreUpdateTree = RestoreUpdateTree.getInstance(this.myProject);
            restoreUpdateTree.registerUpdateInformation(this.myUpdatedFiles, AbstractCommonUpdateAction.this.myActionInfo);
            String text = AbstractCommonUpdateAction.this.getTemplatePresentation().getText() + (willBeContinued || this.myUpdateNumber > 1 ? "#" + this.myUpdateNumber : "");
            UpdateInfoTree updateInfoTree = (UpdateInfoTree)((Object)ObjectUtils.notNull((Object)((Object)this.myProjectLevelVcsManager.showUpdateProjectInfo(this.myUpdatedFiles, text, AbstractCommonUpdateAction.this.myActionInfo, wasCanceled))));
            updateInfoTree.setBefore(this.myBefore);
            updateInfoTree.setAfter(this.myAfter);
            updateInfoTree.setCanGroupByChangeList(AbstractCommonUpdateAction.this.canGroupByChangelist(this.myVcsToVirtualFiles.keySet()));
            UpdateInfoTree updateInfoTree2 = updateInfoTree;
            if (updateInfoTree2 == null) {
                Updater.$$$reportNull$$$0(6);
            }
            return updateInfoTree2;
        }

        public void onCancel() {
            this.onSuccessImpl(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareNotification";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showUpdateTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "putExceptions";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareNotification";
                    break;
                }
                case 3: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilesCount";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareScopeUpdatedText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

