/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenamePsiElementProcessor {
    protected static final ExtensionPointName<RenamePsiElementProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.renamePsiElementProcessor");
    public static final RenamePsiElementProcessor DEFAULT = new RenamePsiElementProcessor(){

        @Override
        public boolean canProcessElement(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor$1", "canProcessElement"));
        }
    };

    public abstract boolean canProcessElement(@NotNull PsiElement var1);

    public RenameDialog createRenameDialog(Project project, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new RenameDialog(project, element, nameSuggestionContext, editor);
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        RenameUtil.doRenameGenericNamedElement(element, newName, usages, listener2);
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element, boolean searchInCommentsAndStrings) {
        Collection<PsiReference> collection = this.findReferences(element);
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject())).findAll();
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameAfterRename(PsiElement element, String newName, boolean nonJava) {
        return null;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        this.prepareRenaming(element, newName, allRenames, element.getUseScope());
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
    }

    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts) {
    }

    public void findExistingNameConflicts(PsiElement element, String newName, MultiMap<PsiElement, String> conflicts, Map<PsiElement, String> allRenames) {
        this.findExistingNameConflicts(element, newName, conflicts);
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    public static List<RenamePsiElementProcessor> allForElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(4);
        }
        ArrayList<RenamePsiElementProcessor> result2 = new ArrayList<RenamePsiElementProcessor>();
        for (RenamePsiElementProcessor processor2 : (RenamePsiElementProcessor[])EP_NAME.getExtensions()) {
            if (!processor2.canProcessElement(element)) continue;
            result2.add(processor2);
        }
        return result2;
    }

    @NotNull
    public static RenamePsiElementProcessor forElement(@NotNull PsiElement element) {
        RenamePsiElementProcessor[] extensions;
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(5);
        }
        for (RenamePsiElementProcessor processor2 : extensions = (RenamePsiElementProcessor[])Extensions.getExtensions(EP_NAME)) {
            if (!processor2.canProcessElement(element)) continue;
            RenamePsiElementProcessor renamePsiElementProcessor = processor2;
            if (renamePsiElementProcessor == null) {
                RenamePsiElementProcessor.$$$reportNull$$$0(6);
            }
            return renamePsiElementProcessor;
        }
        RenamePsiElementProcessor renamePsiElementProcessor = DEFAULT;
        if (renamePsiElementProcessor == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(7);
        }
        return renamePsiElementProcessor;
    }

    @Nullable
    public Runnable getPostRenameCallback(PsiElement element, String newName, RefactoringElementListener elementListener) {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        if (element instanceof PsiFile) {
            return "refactoring.renameFile";
        }
        return "refactoring.renameDialogs";
    }

    public boolean isToSearchInComments(PsiElement element) {
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
        }
    }

    public boolean showRenamePreviewButton(PsiElement psiElement) {
        return true;
    }

    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        return element;
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        PsiElement psiElement;
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(9);
        }
        if (renameCallback == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(10);
        }
        if ((psiElement = this.substituteElementToRename(element, editor)) == null) {
            return;
        }
        if (!PsiElementRenameHandler.canRename(psiElement.getProject(), editor, psiElement)) {
            return;
        }
        renameCallback.pass((Object)psiElement);
    }

    public void findCollisions(PsiElement element, String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result2) {
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(PsiElement element) {
        return element;
    }

    public UsageInfo createUsageInfo(@NotNull PsiElement element, PsiReference ref, PsiElement referenceElement) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(11);
        }
        return new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, ref.resolve() == null && (!(ref instanceof PsiPolyVariantReference) || ((PsiPolyVariantReference)ref).multiResolve(true).length <= 0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenamePsiElementProcessor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenamePsiElementProcessor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrenceSearchStrings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "allForElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

