/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.Cell;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.Convertor;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

public class TableSpeedSearch
extends SpeedSearchBase<JTable> {
    private static final PairFunction<Object, Cell, String> TO_STRING = (o, cell) -> o == null || o instanceof Boolean ? "" : o.toString();
    private final PairFunction<Object, Cell, String> myToStringConvertor;

    public TableSpeedSearch(JTable table) {
        this(table, TO_STRING);
    }

    public TableSpeedSearch(JTable table, Convertor<Object, String> toStringConvertor) {
        this(table, (PairFunction<Object, Cell, String>)((PairFunction)(o, c) -> (String)toStringConvertor.convert(o)));
    }

    public TableSpeedSearch(JTable table, PairFunction<Object, Cell, String> toStringConvertor) {
        super(table);
        this.myToStringConvertor = toStringConvertor;
        table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        new MySelectAllAction(table, this).registerCustomShortcutSet(table, null);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        boolean tableIsNotEmpty = ((JTable)this.myComponent).getRowCount() != 0 && ((JTable)this.myComponent).getColumnCount() != 0;
        return tableIsNotEmpty && !((JTable)this.myComponent).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    protected ListIterator<Object> getElementIterator(int startingIndex) {
        return new MyListIterator(startingIndex);
    }

    @Override
    protected int getElementCount() {
        return ((JTable)this.myComponent).getRowCount() * ((JTable)this.myComponent).getColumnCount();
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        if (element instanceof Integer) {
            int index = (Integer)element;
            int row = index / ((JTable)this.myComponent).getColumnCount();
            int col = index % ((JTable)this.myComponent).getColumnCount();
            ((JTable)this.myComponent).getSelectionModel().setSelectionInterval(row, row);
            ((JTable)this.myComponent).getColumnModel().getSelectionModel().setSelectionInterval(col, col);
            TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
        } else {
            ((JTable)this.myComponent).getSelectionModel().clearSelection();
            ((JTable)this.myComponent).getColumnModel().getSelectionModel().clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        int row = ((JTable)this.myComponent).getSelectedRow();
        int col = ((JTable)this.myComponent).getSelectedColumn();
        return row > -1 && col > -1 ? row * ((JTable)this.myComponent).getColumnCount() + col : -1;
    }

    @Override
    protected Object[] getAllElements() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected String getElementText(Object element) {
        int index = (Integer)element;
        int row = index / ((JTable)this.myComponent).getColumnCount();
        int col = index % ((JTable)this.myComponent).getColumnCount();
        Object value = ((JTable)this.myComponent).getValueAt(row, col);
        return (String)this.myToStringConvertor.fun(value, (Object)new Cell(row, col));
    }

    @NotNull
    private TIntArrayList findAllFilteredRows(String s) {
        TIntArrayList rows = new TIntArrayList();
        String _s = s.trim();
        block0: for (int row = 0; row < ((JTable)this.myComponent).getRowCount(); ++row) {
            for (int col = 0; col < ((JTable)this.myComponent).getColumnCount(); ++col) {
                int index = row * ((JTable)this.myComponent).getColumnCount() + col;
                if (!this.isMatchingElement(index, _s)) continue;
                rows.add(row);
                continue block0;
            }
        }
        TIntArrayList tIntArrayList = rows;
        if (tIntArrayList == null) {
            TableSpeedSearch.$$$reportNull$$$0(0);
        }
        return tIntArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TableSpeedSearch", "findAllFilteredRows"));
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final TableSpeedSearch mySearch;

        public MySelectAllAction(@NotNull JTable table, @NotNull TableSpeedSearch search2) {
            if (table == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search2 == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myTable = table;
            this.mySearch = search2;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myTable.getRowSelectionAllowed() && this.myTable.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(AnActionEvent e) {
            ListSelectionModel sm = this.myTable.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            TIntArrayList filtered = this.mySearch.findAllFilteredRows(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered.toNativeArray(), this.myTable.getSelectedRows());
            if (alreadySelected) {
                int anchor = sm.getAnchorSelectionIndex();
                sm.setSelectionInterval(anchor, anchor);
                sm.setAnchorSelectionIndex(anchor);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement instanceof Integer) {
                    int index = (Integer)currentElement;
                    anchor = index / this.myTable.getColumnCount();
                }
                if (anchor == -1) {
                    anchor = filtered.get(0);
                }
                sm.clearSelection();
                for (int i = 0; i < filtered.size(); ++i) {
                    int value = filtered.get(i);
                    sm.addSelectionInterval(value, value);
                }
                sm.setAnchorSelectionIndex(anchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "search";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/TableSpeedSearch$MySelectAllAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyListIterator
    implements ListIterator<Object> {
        private int myCursor;

        public MyListIterator(int startingIndex) {
            int total = TableSpeedSearch.this.getElementCount();
            this.myCursor = startingIndex < 0 ? total : startingIndex;
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < TableSpeedSearch.this.getElementCount();
        }

        @Override
        public Object next() {
            return this.myCursor++;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0;
        }

        @Override
        public Object previous() {
            return this.myCursor-- - 1;
        }

        @Override
        public int nextIndex() {
            return this.myCursor;
        }

        @Override
        public int previousIndex() {
            return this.myCursor - 1;
        }

        @Override
        public void remove() {
            throw new AssertionError((Object)"Not Implemented");
        }

        @Override
        public void set(Object o) {
            throw new AssertionError((Object)"Not Implemented");
        }

        @Override
        public void add(Object o) {
            throw new AssertionError((Object)"Not Implemented");
        }
    }
}

