/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class VcsLogBranchFilterImpl
implements VcsLogBranchFilter {
    private static final Logger LOG = Logger.getInstance(VcsLogBranchFilterImpl.class);
    @NotNull
    private final List<String> myBranches;
    @NotNull
    private final List<Pattern> myPatterns;
    @NotNull
    private final List<String> myExcludedBranches;
    @NotNull
    private final List<Pattern> myExcludedPatterns;

    private VcsLogBranchFilterImpl(@NotNull List<String> branches, @NotNull List<Pattern> patterns, @NotNull List<String> excludedBranches, @NotNull List<Pattern> excludedPatterns) {
        if (branches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(1);
        }
        if (excludedBranches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(2);
        }
        if (excludedPatterns == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(3);
        }
        this.myBranches = branches;
        this.myPatterns = patterns;
        this.myExcludedBranches = excludedBranches;
        this.myExcludedPatterns = excludedPatterns;
    }

    @Deprecated
    public VcsLogBranchFilterImpl(@NotNull Collection<String> branches, @NotNull Collection<String> excludedBranches) {
        if (branches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(4);
        }
        if (excludedBranches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(5);
        }
        this.myBranches = new ArrayList<String>(branches);
        this.myPatterns = new ArrayList<Pattern>();
        this.myExcludedBranches = new ArrayList<String>(excludedBranches);
        this.myExcludedPatterns = new ArrayList<Pattern>();
    }

    @NotNull
    public static VcsLogBranchFilterImpl fromBranch(@NotNull String branchName) {
        if (branchName == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(6);
        }
        VcsLogBranchFilterImpl vcsLogBranchFilterImpl = new VcsLogBranchFilterImpl(Collections.singletonList(branchName), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        if (vcsLogBranchFilterImpl == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(7);
        }
        return vcsLogBranchFilterImpl;
    }

    @NotNull
    public static VcsLogBranchFilterImpl fromTextPresentation(@NotNull Collection<String> strings, @NotNull Set<String> existingBranches) {
        if (strings == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(8);
        }
        if (existingBranches == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(9);
        }
        ArrayList<String> branchNames = new ArrayList<String>();
        ArrayList<String> excludedBranches = new ArrayList<String>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        ArrayList<Pattern> excludedPatterns = new ArrayList<Pattern>();
        for (String string : strings) {
            boolean isRegexp;
            boolean isExcluded = string.startsWith("-");
            string = isExcluded ? string.substring(1) : string;
            boolean bl = isRegexp = !existingBranches.contains(string);
            if (isRegexp) {
                try {
                    Pattern pattern = Pattern.compile(string);
                    if (isExcluded) {
                        excludedPatterns.add(pattern);
                        continue;
                    }
                    patterns.add(pattern);
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("Pattern " + string + " is not a proper regular expression and no branch can be found with that name.", (Throwable)e);
                    if (isExcluded) {
                        excludedBranches.add(string);
                        continue;
                    }
                    branchNames.add(string);
                }
                continue;
            }
            if (isExcluded) {
                excludedBranches.add(string);
                continue;
            }
            branchNames.add(string);
        }
        VcsLogBranchFilterImpl vcsLogBranchFilterImpl = new VcsLogBranchFilterImpl(branchNames, patterns, excludedBranches, excludedPatterns);
        if (vcsLogBranchFilterImpl == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(10);
        }
        return vcsLogBranchFilterImpl;
    }

    @NotNull
    public Collection<String> getTextPresentation() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.addAll(this.myBranches);
        result2.addAll(ContainerUtil.map(this.myPatterns, pattern -> pattern.pattern()));
        result2.addAll(ContainerUtil.map(this.myExcludedBranches, branchName -> "-" + branchName));
        result2.addAll(ContainerUtil.map(this.myExcludedPatterns, pattern -> "-" + pattern.pattern()));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public String toString() {
        String result2 = "";
        if (!this.myPatterns.isEmpty()) {
            result2 = result2 + "on patterns: " + StringUtil.join(this.myPatterns, (String)", ");
        }
        if (!this.myBranches.isEmpty()) {
            if (!result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "on branches: " + StringUtil.join(this.myBranches, (String)", ");
        }
        if (!this.myExcludedPatterns.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on patterns: " + StringUtil.join(this.myExcludedPatterns, (String)", ");
        }
        if (!this.myExcludedBranches.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on branches: " + StringUtil.join(this.myExcludedBranches, (String)", ");
        }
        return result2;
    }

    public boolean matches(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(12);
        }
        return this.isIncluded(name) && !this.isExcluded(name);
    }

    private boolean isIncluded(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(13);
        }
        if (this.myPatterns.isEmpty() && this.myBranches.isEmpty()) {
            return true;
        }
        if (this.myBranches.contains(name)) {
            return true;
        }
        for (Pattern regexp : this.myPatterns) {
            if (!regexp.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(@NotNull String name) {
        if (name == null) {
            VcsLogBranchFilterImpl.$$$reportNull$$$0(14);
        }
        if (this.myExcludedBranches.contains(name)) {
            return true;
        }
        for (Pattern regexp : this.myExcludedPatterns) {
            if (!regexp.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedBranches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPatterns";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogBranchFilterImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingBranches";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogBranchFilterImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromBranch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTextPresentation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromBranch";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromTextPresentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isIncluded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

