/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.FileContentUtil;
import com.intellij.util.FileContentUtilCore;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.ReSTService;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.PyTestFrameworkService;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.TestRunnerService;
import com.jetbrains.python.testing.VFSTestFrameworkListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyIntegratedToolsConfigurable
implements SearchableConfigurable {
    private JPanel myMainPanel;
    private JComboBox myTestRunnerComboBox;
    private JComboBox myDocstringFormatComboBox;
    private PythonTestConfigurationsModel myModel;
    @NotNull
    private final Module myModule;
    @NotNull
    private final Project myProject;
    private final PyDocumentationSettings myDocumentationSettings;
    private TextFieldWithBrowseButton myWorkDir;
    private JCheckBox txtIsRst;
    private JPanel myErrorPanel;
    private TextFieldWithBrowseButton myRequirementsPathField;
    private JCheckBox analyzeDoctest;
    private JPanel myDocStringsPanel;
    private JPanel myRestPanel;
    private JCheckBox renderExternal;

    public PyIntegratedToolsConfigurable(@NotNull Module module2) {
        if (module2 == null) {
            PyIntegratedToolsConfigurable.$$$reportNull$$$0(0);
        }
        this.myModule = module2;
        this.$$$setupUI$$$();
        this.myProject = this.myModule.getProject();
        this.myDocumentationSettings = PyDocumentationSettings.getInstance(this.myModule);
        this.myDocstringFormatComboBox.setModel(new CollectionComboBoxModel(Arrays.asList(DocStringFormat.values()), (Object)this.myDocumentationSettings.getFormat()));
        this.myDocstringFormatComboBox.setRenderer(new ListCellRendererWrapper<DocStringFormat>(){

            public void customize(JList list2, DocStringFormat value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getName());
            }
        });
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myWorkDir.addBrowseFolderListener("Please choose working directory:", null, this.myProject, fileChooserDescriptor2);
        ReSTService service = ReSTService.getInstance(this.myModule);
        this.myWorkDir.setText(service.getWorkdir());
        this.txtIsRst.setSelected(service.txtIsRst());
        this.analyzeDoctest.setSelected(this.myDocumentationSettings.isAnalyzeDoctest());
        this.renderExternal.setSelected(this.myDocumentationSettings.isRenderExternalDocumentation());
        this.myRequirementsPathField.addBrowseFolderListener("Choose path to the package requirements file:", null, this.myProject, FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
        this.myRequirementsPathField.setText(this.getRequirementsPath());
        this.myDocStringsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Docstrings"));
        this.myRestPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"reStructuredText"));
    }

    @NotNull
    private String getRequirementsPath() {
        String path = PyPackageRequirementsSettings.getInstance(this.myModule).getRequirementsPath();
        if (path.equals("requirements.txt") && !PyPackageUtil.hasRequirementsTxt(this.myModule)) {
            if ("" == null) {
                PyIntegratedToolsConfigurable.$$$reportNull$$$0(1);
            }
            return "";
        }
        String string = path;
        if (string == null) {
            PyIntegratedToolsConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void initErrorValidation() {
        final FacetErrorPanel facetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)facetErrorPanel.getComponent(), "Center");
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                Sdk sdk = PythonSdkType.findPythonSdk(PyIntegratedToolsConfigurable.this.myModule);
                if (sdk != null) {
                    Object selectedItem = PyIntegratedToolsConfigurable.this.myTestRunnerComboBox.getSelectedItem();
                    for (String framework : PyTestFrameworkService.getFrameworkNamesArray()) {
                        if (!PyTestFrameworkService.getSdkReadableNameByFramework(framework).equals(selectedItem) || VFSTestFrameworkListener.getInstance().isTestFrameworkInstalled(sdk, framework)) continue;
                        ValidationResult validationResult = new ValidationResult(PyBundle.message("runcfg.testing.no.test.framework", framework), PyIntegratedToolsConfigurable.this.createQuickFix(sdk, facetErrorPanel, framework));
                        if (validationResult == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return validationResult;
                    }
                }
                ValidationResult validationResult = ValidationResult.OK;
                if (validationResult == null) {
                    2.$$$reportNull$$$0(1);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/configuration/PyIntegratedToolsConfigurable$2", "check"));
            }
        }, new JComponent[]{this.myTestRunnerComboBox});
        facetErrorPanel.getValidatorsManager().validate();
    }

    private FacetConfigurationQuickFix createQuickFix(final Sdk sdk, final FacetErrorPanel facetErrorPanel, final String name) {
        return new FacetConfigurationQuickFix(){

            public void run(JComponent place) {
                PyPackageManagerUI ui = new PyPackageManagerUI(PyIntegratedToolsConfigurable.this.myProject, sdk, new PyPackageManagerUI.Listener(){

                    @Override
                    public void started() {
                    }

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        if (exceptions.isEmpty()) {
                            VFSTestFrameworkListener.getInstance().setTestFrameworkInstalled(true, sdk.getHomePath(), name);
                            facetErrorPanel.getValidatorsManager().validate();
                        }
                    }
                });
                ui.install(Collections.singletonList(new PyRequirement(name)), Collections.emptyList());
            }
        };
    }

    @Nls
    public String getDisplayName() {
        return "Python Integrated Tools";
    }

    public String getHelpTopic() {
        return "test_runner_configuration";
    }

    public JComponent createComponent() {
        List<String> configurations = TestRunnerService.getInstance(this.myModule).getConfigurations();
        this.myModel = new PythonTestConfigurationsModel(configurations, TestRunnerService.getInstance(this.myModule).getProjectConfiguration(), this.myModule);
        this.updateConfigurations();
        this.initErrorValidation();
        return this.myMainPanel;
    }

    private void updateConfigurations() {
        this.myTestRunnerComboBox.setModel(this.myModel);
    }

    public boolean isModified() {
        if (this.myTestRunnerComboBox.getSelectedItem() != this.myModel.getTestRunner()) {
            return true;
        }
        if (this.myDocstringFormatComboBox.getSelectedItem() != this.myDocumentationSettings.getFormat()) {
            return true;
        }
        if (this.analyzeDoctest.isSelected() != this.myDocumentationSettings.isAnalyzeDoctest()) {
            return true;
        }
        if (this.renderExternal.isSelected() != this.myDocumentationSettings.isRenderExternalDocumentation()) {
            return true;
        }
        if (!ReSTService.getInstance(this.myModule).getWorkdir().equals(this.myWorkDir.getText())) {
            return true;
        }
        if (!ReSTService.getInstance(this.myModule).txtIsRst() == this.txtIsRst.isSelected()) {
            return true;
        }
        return !this.getRequirementsPath().equals(this.myRequirementsPathField.getText());
    }

    public void apply() throws ConfigurationException {
        if (this.myDocstringFormatComboBox.getSelectedItem() != this.myDocumentationSettings.getFormat()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
        if (this.analyzeDoctest.isSelected() != this.myDocumentationSettings.isAnalyzeDoctest()) {
            ArrayList files = Lists.newArrayList();
            ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().iterateContent(fileOrDir -> {
                if (!fileOrDir.isDirectory() && PythonFileType.INSTANCE.getDefaultExtension().equals(fileOrDir.getExtension())) {
                    files.add(fileOrDir);
                }
                return true;
            });
            FileContentUtil.reparseFiles((Project)this.myProject, (Collection)Lists.newArrayList((Iterable)files), (boolean)false);
        }
        this.myModel.apply();
        this.myDocumentationSettings.setRenderExternalDocumentation(this.renderExternal.isSelected());
        this.myDocumentationSettings.setFormat((DocStringFormat)((Object)this.myDocstringFormatComboBox.getSelectedItem()));
        ReSTService reSTService = ReSTService.getInstance(this.myModule);
        reSTService.setWorkdir(this.myWorkDir.getText());
        if (this.txtIsRst.isSelected() != reSTService.txtIsRst()) {
            reSTService.setTxtIsRst(this.txtIsRst.isSelected());
            this.reparseFiles(Collections.singletonList(PlainTextFileType.INSTANCE.getDefaultExtension()));
        }
        this.myDocumentationSettings.setAnalyzeDoctest(this.analyzeDoctest.isSelected());
        PyPackageRequirementsSettings.getInstance(this.myModule).setRequirementsPath(this.myRequirementsPathField.getText());
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    public void reparseFiles(List<String> extensions) {
        ArrayList filesToReparse = Lists.newArrayList();
        ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().iterateContent(fileOrDir -> {
            if (!fileOrDir.isDirectory() && extensions.contains(fileOrDir.getExtension())) {
                filesToReparse.add(fileOrDir);
            }
            return true;
        });
        FileContentUtilCore.reparseFiles((Collection)filesToReparse);
        PyUtil.rehighlightOpenEditors(this.myProject);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    public void reset() {
        this.myTestRunnerComboBox.setSelectedItem(this.myModel.getTestRunner());
        this.myTestRunnerComboBox.repaint();
        this.myModel.reset();
        this.myDocstringFormatComboBox.setSelectedItem((Object)this.myDocumentationSettings.getFormat());
        this.myWorkDir.setText(ReSTService.getInstance(this.myModule).getWorkdir());
        this.txtIsRst.setSelected(ReSTService.getInstance(this.myModule).txtIsRst());
        this.analyzeDoctest.setSelected(this.myDocumentationSettings.isAnalyzeDoctest());
        this.renderExternal.setSelected(this.myDocumentationSettings.isRenderExternalDocumentation());
        this.myRequirementsPathField.setText(this.getRequirementsPath());
    }

    @NotNull
    public String getId() {
        if ("PyIntegratedToolsConfigurable" == null) {
            PyIntegratedToolsConfigurable.$$$reportNull$$$0(3);
        }
        return "PyIntegratedToolsConfigurable";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PyIntegratedToolsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PyIntegratedToolsConfigurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirementsPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JComboBox jComboBox;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel3;
        JComboBox jComboBox2;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTestRunnerComboBox = jComboBox2 = new JComboBox();
        jPanel4.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Default test runner:");
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Package requirements file:");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRequirementsPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myDocStringsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Docstring format:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDocstringFormatComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.analyzeDoctest = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Analyze Python code in docstrings");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.renderExternal = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Render external documentation for stdlib");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRestPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(4, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Sphinx working directory:");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.txtIsRst = jCheckBox = new JCheckBox();
        jCheckBox.setText("Treat *.txt files as reStructuredText ");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox);
        jBLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

