/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.IPydevXmlRpcClient;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.console.pydev.PydevXmlRpcClient;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.PydevXmlUtils;
import com.jetbrains.python.debugger.containerview.PyViewNumericContainerAction;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleCommunication
extends AbstractConsoleCommunication
implements XmlRpcHandler,
PyFrameAccessor {
    private static final String EXEC_LINE = "execLine";
    private static final String EXEC_MULTILINE = "execMultipleLines";
    private static final String GET_COMPLETIONS = "getCompletions";
    private static final String GET_DESCRIPTION = "getDescription";
    private static final String GET_FRAME = "getFrame";
    private static final String GET_VARIABLE = "getVariable";
    private static final String CHANGE_VARIABLE = "changeVariable";
    private static final String CONNECT_TO_DEBUGGER = "connectToDebugger";
    private static final String HANDSHAKE = "handshake";
    private static final String CLOSE = "close";
    private static final String EVALUATE = "evaluate";
    private static final String GET_ARRAY = "getArray";
    private static final String LOAD_FULL_VALUE = "loadFullValue";
    private static final String PYDEVD_EXTRA_ENVS = "PYDEVD_EXTRA_ENVS";
    private IPydevXmlRpcClient myClient;
    @Nullable
    private MyWebServer myWebServer;
    private static final Logger LOG = Logger.getInstance((String)PydevConsoleCommunication.class.getName());
    protected volatile String inputReceived;
    protected volatile InterpreterResponse nextResponse;
    private volatile Object lock2 = new Object();
    private volatile boolean firstCommWorked = false;
    private boolean myExecuting;
    private PythonDebugConsoleCommunication myDebugCommunication;
    private boolean myNeedsMore = false;
    private PythonConsoleView myConsoleView;
    private List<PyFrameListener> myFrameListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private volatile Object lock = new Object();

    public PydevConsoleCommunication(Project project, int port, Process process2, int clientPort) throws Exception {
        this(project, null, port, process2, clientPort);
    }

    public PydevConsoleCommunication(Project project, String host, int port, Process process2, int clientPort) throws Exception {
        super(project);
        this.myWebServer = new MyWebServer(clientPort);
        this.myWebServer.addHandler("$default", (Object)this);
        this.myWebServer.start();
        this.myClient = new PydevXmlRpcClient(process2, host, port);
        final PyDebugValueExecutionService executionService = PyDebugValueExecutionService.getInstance((Project)this.myProject);
        executionService.sessionStarted((PyFrameAccessor)this);
        this.addFrameListener(new PyFrameListener(){

            public void frameChanged() {
                executionService.cancelSubmittedTasks((PyFrameAccessor)PydevConsoleCommunication.this);
            }
        });
    }

    public boolean handshake() throws XmlRpcException {
        Object ret;
        if (this.myClient != null && (ret = this.myClient.execute(HANDSHAKE, new Object[0])) instanceof String) {
            String retVal = (String)ret;
            return "PyCharm".equals(retVal);
        }
        return false;
    }

    private void sendCloseMessageToScript() {
        if (this.myClient != null) {
            new Task.Backgroundable(this.myProject, "Close Console Communication", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        PydevConsoleCommunication.this.myClient.execute(PydevConsoleCommunication.CLOSE, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PydevConsoleCommunication.this.myClient = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$2", "run"));
                }
            }.queue();
        }
    }

    public synchronized void close() {
        this.sendCloseMessageToScript();
        PyDebugValueExecutionService.getInstance((Project)this.myProject).sessionStopped((PyFrameAccessor)this);
        if (this.myWebServer != null) {
            this.myWebServer.shutdown();
            this.myWebServer = null;
        }
    }

    @NotNull
    public synchronized Future<Void> closeAsync() {
        this.sendCloseMessageToScript();
        PyDebugValueExecutionService.getInstance((Project)this.myProject).sessionStopped((PyFrameAccessor)this);
        if (this.myWebServer != null) {
            Future<Void> shutdownFuture = this.myWebServer.shutdownAsync();
            this.myWebServer = null;
            Future<Void> future2 = shutdownFuture;
            if (future2 == null) {
                PydevConsoleCommunication.$$$reportNull$$$0(0);
            }
            return future2;
        }
        Future<Void> future3 = PydevConsoleCommunication.completedFuture();
        if (future3 == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(1);
        }
        return future3;
    }

    public Object execute(String method, Vector params) throws Exception {
        if ("NotifyFinished".equals(method)) {
            return this.execNotifyFinished((Boolean)params.get(0));
        }
        if ("RequestInput".equals(method)) {
            return this.execRequestInput();
        }
        if ("IPythonEditor".equals(method)) {
            return this.execIPythonEditor(params);
        }
        if ("NotifyAboutMagic".equals(method)) {
            return this.execNotifyAboutMagic(params);
        }
        if ("ShowConsole".equals(method)) {
            this.myConsoleView.setConsoleEnabled(true);
            return "";
        }
        throw new UnsupportedOperationException();
    }

    private Object execNotifyAboutMagic(Vector params) {
        List commands = (List)params.get(0);
        boolean isAutoMagic = (Boolean)params.get(1);
        if (this.getConsoleFile() != null) {
            PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(this.getConsoleFile());
            consoleData.setIPythonAutomagic(isAutoMagic);
            consoleData.setIPythonMagicCommands(commands);
        }
        return "";
    }

    private Object execIPythonEditor(Vector params) {
        VirtualFile file2;
        String path = (String)params.get(0);
        int line = Integer.parseInt((String)params.get(1));
        VirtualFile virtualFile = file2 = StringUtil.isEmpty((String)path) ? null : LocalFileSystem.getInstance().findFileByPath(path);
        if (file2 != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                AccessToken at = ApplicationManager.getApplication().acquireReadActionLock();
                try {
                    FileEditorManager.getInstance((Project)this.myProject).openFile(file2, true);
                }
                finally {
                    at.finish();
                }
            });
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object execNotifyFinished(boolean more) {
        this.myNeedsMore = more;
        this.setExecuting(false);
        this.notifyCommandExecuted(more);
        return true;
    }

    private void setExecuting(boolean executing) {
        this.myExecuting = executing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execRequestInput() {
        this.waitingForInput = true;
        this.inputReceived = null;
        boolean needInput = true;
        this.nextResponse = new InterpreterResponse(false, needInput);
        this.notifyInputRequested();
        while (this.inputReceived == null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.inputReceived;
    }

    protected Pair<String, Boolean> exec(ConsoleCommunication.ConsoleCodeFragment command) throws XmlRpcException {
        this.setExecuting(true);
        Object execute2 = this.myClient.execute(command.isSingleLine() ? EXEC_LINE : EXEC_MULTILINE, new Object[]{command.getText()});
        Object object = execute2 instanceof Vector ? ((Vector)execute2).get(0) : (execute2.getClass().isArray() ? ((Object[])execute2)[0] : execute2);
        Pair<String, Boolean> result2 = this.parseResult(object);
        if (((Boolean)result2.second).booleanValue()) {
            this.setExecuting(false);
        }
        return result2;
    }

    private Pair<String, Boolean> parseResult(Object object) {
        if (object instanceof Boolean) {
            return new Pair(null, (Object)((Boolean)object));
        }
        return PydevConsoleCommunication.parseExecResponseString((String)object.toString());
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text, String actTok) throws Exception {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            List<PydevCompletionVariant> list2 = this.myDebugCommunication.getCompletions(text, actTok);
            if (list2 == null) {
                PydevConsoleCommunication.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (this.waitingForInput) {
            List<PydevCompletionVariant> list3 = Collections.emptyList();
            if (list3 == null) {
                PydevConsoleCommunication.$$$reportNull$$$0(3);
            }
            return list3;
        }
        Object fromServer = this.myClient.execute(GET_COMPLETIONS, new Object[]{text, actTok});
        List list4 = PydevXmlUtils.decodeCompletions((Object)fromServer, (String)actTok);
        if (list4 == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(4);
        }
        return list4;
    }

    public String getDescription(String text) throws Exception {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            return this.myDebugCommunication.getDescription(text);
        }
        if (this.waitingForInput) {
            return "Unable to get description: waiting for input.";
        }
        ThrowableComputable doGetDesc = () -> this.myClient.execute(GET_DESCRIPTION, new Object[]{text}, 5000L).toString();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(doGetDesc, "Getting Description", true, this.myProject);
        }
        return (String)doGetDesc.compute();
    }

    public void execInterpreter(final ConsoleCommunication.ConsoleCodeFragment command, Function<InterpreterResponse, Object> onResponseReceived) {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            this.myDebugCommunication.execInterpreter(command, onResponseReceived);
            return;
        }
        this.nextResponse = null;
        if (this.waitingForInput && this.myConsoleView.isInitialized()) {
            this.inputReceived = command.getText();
            this.waitingForInput = false;
        } else {
            new Task.Backgroundable(this.myProject, "REPL Communication", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    boolean needInput = false;
                    try {
                        Pair executed = null;
                        int commAttempts = 0;
                        while (true) {
                            if (indicator.isCanceled()) {
                                return;
                            }
                            executed = PydevConsoleCommunication.this.exec(command);
                            String refusedConnPattern = "Failed to read servers response";
                            if (executed.first == null || ((String)executed.first).indexOf(refusedConnPattern) == -1 || PydevConsoleCommunication.this.firstCommWorked || commAttempts >= 3) break;
                            ++commAttempts;
                            Thread.sleep(250L);
                            executed = Pair.create((Object)"", (Object)executed.second);
                        }
                        PydevConsoleCommunication.this.firstCommWorked = true;
                        boolean more = (Boolean)executed.second;
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(more, needInput);
                    }
                    catch (ProcessCanceledException executed) {
                    }
                    catch (Exception e) {
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, needInput);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$3", "run"));
                }
            }.queue();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                progressIndicator.setText("Waiting for REPL response with 10s timeout");
                long startTime = System.nanoTime();
                while (this.nextResponse == null) {
                    if (progressIndicator.isCanceled()) {
                        LOG.debug("Canceled");
                        this.nextResponse = new InterpreterResponse(false, false);
                    }
                    long time = System.nanoTime() - startTime;
                    progressIndicator.setFraction((double)time / 1.0E10);
                    if (time > 10000000000L) {
                        LOG.debug("Timeout exceeded");
                        this.nextResponse = new InterpreterResponse(false, false);
                    }
                    Object object = this.lock2;
                    synchronized (object) {
                        try {
                            this.lock2.wait(20L);
                        }
                        catch (InterruptedException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                if (this.nextResponse.more) {
                    this.myNeedsMore = true;
                    this.notifyCommandExecuted(true);
                }
                onResponseReceived.fun((Object)this.nextResponse);
            }, "Waiting for REPL response", true, this.myProject);
        }
    }

    public void interrupt() {
        try {
            this.myClient.execute("interrupt", new Object[0]);
        }
        catch (XmlRpcException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean isExecuting() {
        return this.myExecuting;
    }

    public boolean needsMore() {
        return this.myNeedsMore;
    }

    public PyDebugValue evaluate(String expression, boolean execute2, boolean doTrunc) throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(EVALUATE, new Object[]{expression});
                if (ret instanceof String) {
                    return ProtocolParser.parseValue((String)((String)ret), (PyFrameAccessor)this);
                }
                PydevConsoleCommunication.checkError(ret);
            }
            catch (Exception e) {
                throw new PyDebuggerException("Evaluate in console failed", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public XValueChildrenList loadFrame() throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(GET_FRAME, new Object[0]);
                if (ret instanceof String) {
                    return this.parseVars((String)ret, null);
                }
                PydevConsoleCommunication.checkError(ret);
            }
            catch (XmlRpcException e) {
                throw new PyDebuggerException("Get frame from console failed", (Throwable)e);
            }
        }
        return new XValueChildrenList();
    }

    public void loadAsyncVariablesValues(@NotNull List<PyFrameAccessor.PyAsyncValue<String>> pyAsyncValues) {
        if (pyAsyncValues == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(5);
        }
        PyDebugValueExecutionService.getInstance((Project)this.myProject).submitTask((PyFrameAccessor)this, () -> {
            block11: {
                if (pyAsyncValues == null) {
                    PydevConsoleCommunication.$$$reportNull$$$0(11);
                }
                if (this.myClient != null) {
                    try {
                        ArrayList<String> evaluationExpressions = new ArrayList<String>();
                        for (PyFrameAccessor.PyAsyncValue asyncValue : pyAsyncValues) {
                            evaluationExpressions.add(asyncValue.getDebugValue().getEvaluationExpression());
                        }
                        Object ret = this.myClient.execute(LOAD_FULL_VALUE, new Object[]{evaluationExpressions.toArray()});
                        if (ret instanceof String) {
                            List debugValues = ProtocolParser.parseValues((String)((String)ret), (PyFrameAccessor)this);
                            for (int i = 0; i < pyAsyncValues.size(); ++i) {
                                ((PyFrameAccessor.PyAsyncValue)pyAsyncValues.get(i)).getCallback().ok((Object)((PyDebugValue)debugValues.get(i)).getValue());
                            }
                        } else {
                            PydevConsoleCommunication.checkError(ret);
                        }
                    }
                    catch (PyDebuggerException e) {
                        if (this.myWebServer == null || e.getMessage().startsWith("Console already exited")) break block11;
                        LOG.error((Throwable)e);
                    }
                    catch (XmlRpcException e) {
                        for (PyFrameAccessor.PyAsyncValue asyncValue : pyAsyncValues) {
                            PyDebugValue value = asyncValue.getDebugValue();
                            XValueNode node = value.getLastNode();
                            if (node == null || node.isObsolete()) continue;
                            if (e.getMessage().startsWith("Timeout") || e.getMessage().startsWith("Console already exited")) {
                                value.updateNodeValueAfterLoading(node, " ", "Timeout Exceeded");
                                continue;
                            }
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        });
    }

    private XValueChildrenList parseVars(String ret, PyDebugValue parent) throws PyDebuggerException {
        List values = ProtocolParser.parseValues((String)ret, (PyFrameAccessor)this);
        XValueChildrenList list2 = new XValueChildrenList(values.size());
        for (PyDebugValue v : values) {
            PyDebugValue value;
            if (parent != null) {
                value = new PyDebugValue(v);
                value.setParent(parent);
            } else {
                value = v;
            }
            list2.add(v.getName(), (XValue)value);
        }
        return list2;
    }

    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(GET_VARIABLE, new Object[]{GetVariableCommand.composeName((PyDebugValue)var)});
                if (ret instanceof String) {
                    return this.parseVars((String)ret, var);
                }
                PydevConsoleCommunication.checkError(ret);
            }
            catch (XmlRpcException e) {
                throw new PyDebuggerException("Get variable from console failed", (Throwable)e);
            }
        }
        return new XValueChildrenList();
    }

    public void changeVariable(PyDebugValue variable, String value) throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(CHANGE_VARIABLE, new Object[]{variable.getEvaluationExpression(), value});
                PydevConsoleCommunication.checkError(ret);
            }
            catch (XmlRpcException e) {
                throw new PyDebuggerException("Get change variable", (Throwable)e);
            }
        }
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        return null;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        if (this.myClient != null) {
            try {
                Object ret = this.myClient.execute(GET_ARRAY, new Object[]{var.getName(), rowOffset, colOffset, rows, cols, format});
                if (ret instanceof String) {
                    return ProtocolParser.parseArrayValues((String)((String)ret), (PyFrameAccessor)this);
                }
                PydevConsoleCommunication.checkError(ret);
            }
            catch (Exception e) {
                throw new PyDebuggerException("Evaluate in console failed", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePositionForName(String name, String parentType) {
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePositionForType(String type) {
        return null;
    }

    public void connectToDebugger(int localPort, @NotNull Map<String, Boolean> dbgOpts, @NotNull Map<String, String> extraEnvs) throws Exception {
        Vector resultarray;
        if (dbgOpts == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(6);
        }
        if (extraEnvs == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(7);
        }
        if (this.waitingForInput) {
            throw new Exception("Can't connect debugger now, waiting for input");
        }
        Hashtable<String, Boolean> opts = new Hashtable<String, Boolean>(dbgOpts);
        opts.put(PYDEVD_EXTRA_ENVS, (Boolean)((Object)new Hashtable<String, String>(extraEnvs)));
        Object result2 = this.myClient.execute(CONNECT_TO_DEBUGGER, new Object[]{localPort, opts});
        Exception exception = null;
        if (result2 instanceof Vector && (resultarray = (Vector)result2).size() == 1) {
            if ("connect complete".equals(resultarray.get(0))) {
                return;
            }
            if (resultarray.get(0) instanceof String) {
                exception = new Exception((String)resultarray.get(0));
            }
            if (resultarray.get(0) instanceof Exception) {
                exception = (Exception)resultarray.get(0);
            }
        }
        throw new PyDebuggerException("pydevconsole failed to execute connectToDebugger", exception);
    }

    public void notifyCommandExecuted(boolean more) {
        super.notifyCommandExecuted(more);
        for (PyFrameListener listener2 : this.myFrameListeners) {
            listener2.frameChanged();
        }
    }

    private static void checkError(Object ret) throws PyDebuggerException {
        if (ret instanceof Object[] && ((Object[])ret).length == 1) {
            throw new PyDebuggerException(((Object[])ret)[0].toString());
        }
    }

    public void setDebugCommunication(PythonDebugConsoleCommunication debugCommunication) {
        this.myDebugCommunication = debugCommunication;
    }

    public PythonDebugConsoleCommunication getDebugCommunication() {
        return this.myDebugCommunication;
    }

    public void setConsoleView(PythonConsoleView consoleView) {
        this.myConsoleView = consoleView;
    }

    public void showNumericContainer(@NotNull PyDebugValue value) {
        if (value == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(8);
        }
        PyViewNumericContainerAction.showNumericViewer(this.myProject, value);
    }

    public void addFrameListener(@NotNull PyFrameListener listener2) {
        if (listener2 == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(9);
        }
        this.myFrameListeners.add(listener2);
    }

    @NotNull
    private static Future<Void> completedFuture() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleCommunication";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyAsyncValues";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbgOpts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "closeAsync";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = GET_COMPLETIONS;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleCommunication";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "completedFuture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadAsyncVariablesValues";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = CONNECT_TO_DEBUGGER;
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showNumericContainer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFrameListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadAsyncVariablesValues$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyWebServer
    extends WebServer {
        public MyWebServer(int port) {
            super(port);
        }

        @NotNull
        public synchronized Future<Void> shutdownAsync() {
            Thread thread = this.listener;
            this.shutdown();
            if (thread != null) {
                Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    thread.join();
                    return null;
                });
                if (future2 == null) {
                    MyWebServer.$$$reportNull$$$0(0);
                }
                return future2;
            }
            Future future3 = PydevConsoleCommunication.completedFuture();
            if (future3 == null) {
                MyWebServer.$$$reportNull$$$0(1);
            }
            return future3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PydevConsoleCommunication$MyWebServer", "shutdownAsync"));
        }
    }
}

