/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.runners.ConsoleTitleGen;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.Tunnelable;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.console.PyConsoleDebugProcess;
import com.jetbrains.python.console.PyConsoleDebugProcessHandler;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PydevRemoteConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreatorKt;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.console.actions.ShowVarsAction;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandlerBase;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PyRemoteProcessStarterManagerUtil;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleRunnerImpl
implements PydevConsoleRunner {
    public static final String WORKING_DIR_AND_PYTHON_PATHS = "WORKING_DIR_AND_PYTHON_PATHS";
    public static final String CONSOLE_START_COMMAND = "import sys; print('Python %s on %s' % (sys.version, sys.platform))\nsys.path.extend([WORKING_DIR_AND_PYTHON_PATHS])\n";
    private static final Logger LOG = Logger.getInstance((String)PydevConsoleRunnerImpl.class.getName());
    public static final String PYDEV_PYDEVCONSOLE_PY = "pydev/pydevconsole.py";
    public static final int PORTS_WAITING_TIMEOUT = 20000;
    private static final String CONSOLE_FEATURE = "python.console";
    private static final String DOCKER_CONTAINER_PROJECT_PATH = "/opt/project";
    private final Project myProject;
    private final String myTitle;
    @Nullable
    private final String myWorkingDir;
    private final Consumer<String> myRerunAction;
    @NotNull
    private Sdk mySdk;
    protected int[] myPorts;
    private PydevConsoleCommunication myPydevConsoleCommunication;
    private PyConsoleProcessHandler myProcessHandler;
    protected PythonConsoleExecuteActionHandler myConsoleExecuteActionHandler;
    private List<PydevConsoleRunner.ConsoleListener> myConsoleListeners;
    private final PyConsoleType myConsoleType;
    @NotNull
    private Map<String, String> myEnvironmentVariables;
    private String myCommandLine;
    @NotNull
    private final PyConsoleOptions.PyConsoleSettings myConsoleSettings;
    private String[] myStatementsToExecute;
    private boolean myEnableAfterConnection;
    private static final long HANDSHAKE_TIMEOUT = 60000L;
    private PyRemoteProcessHandlerBase myRemoteProcessHandlerBase;
    private String myConsoleTitle;
    private PythonConsoleView myConsoleView;

    public PydevConsoleRunnerImpl(@NotNull Project project, @NotNull Sdk sdk, @NotNull PyConsoleType consoleType, @Nullable String workingDir, @NotNull Map<String, String> environmentVariables, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<String> rerunAction, String ... statementsToExecute) {
        if (project == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(1);
        }
        if (consoleType == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(2);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(3);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(4);
        }
        if (rerunAction == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(5);
        }
        this.myConsoleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myStatementsToExecute = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myEnableAfterConnection = true;
        this.myConsoleTitle = null;
        this.myProject = project;
        this.mySdk = sdk;
        this.myTitle = consoleType.getTitle();
        this.myWorkingDir = workingDir;
        this.myConsoleType = consoleType;
        this.myEnvironmentVariables = environmentVariables;
        this.myConsoleSettings = settingsProvider;
        this.myStatementsToExecute = statementsToExecute;
        this.myRerunAction = rerunAction;
    }

    public void setConsoleTitle(String consoleTitle) {
        this.myConsoleTitle = consoleTitle;
    }

    public void setEnableAfterConnection(boolean enableAfterConnection) {
        this.myEnableAfterConnection = enableAfterConnection;
    }

    private List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions, RunContentDescriptor contentDescriptor) {
        toolbarActions.add(this.createRerunAction());
        ArrayList actions = ContainerUtil.newArrayList();
        actions.add(this.createStopAction());
        actions.add(this.createCloseAction(contentDescriptor));
        actions.add(new ConsoleExecuteAction(this.myConsoleView, this.myConsoleExecuteActionHandler, this.myConsoleExecuteActionHandler.getEmptyExecuteAction(), this.myConsoleExecuteActionHandler));
        actions.add(CommonActionsManager.getInstance().createHelpAction("interactive_console"));
        actions.add(new SoftWrapAction());
        toolbarActions.addAll((Collection)actions);
        actions.add(0, this.createRerunAction());
        actions.add(PyConsoleUtil.createInterruptAction(this.myConsoleView));
        actions.add(PyConsoleUtil.createTabCompletionAction(this.myConsoleView));
        actions.add(this.createSplitLineAction());
        toolbarActions.add((AnAction)new ShowVarsAction(this.myConsoleView, this.myPydevConsoleCommunication));
        toolbarActions.add(ConsoleHistoryController.getController(this.myConsoleView).getBrowseHistory());
        toolbarActions.add((AnAction)new ConnectDebuggerAction());
        DefaultActionGroup settings = new DefaultActionGroup("Settings", true);
        settings.getTemplatePresentation().setIcon(AllIcons.General.SecondaryGroup);
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(null));
        settings.add((AnAction)new PyVariableViewSettings.AsyncView());
        toolbarActions.add((AnAction)settings);
        toolbarActions.add((AnAction)new NewConsoleAction());
        return actions;
    }

    @Override
    public void open() {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(this.myProject);
        if (toolWindow != null) {
            toolWindow.getToolWindow().activate(() -> {}, true);
        } else {
            this.runSync();
        }
    }

    @Override
    public void runSync() {
        this.myPorts = PydevConsoleRunnerImpl.findAvailablePorts(this.myProject, this.myConsoleType);
        assert (this.myPorts != null);
        GeneralCommandLine generalCommandLine = this.createCommandLine(this.mySdk, this.myEnvironmentVariables, this.myWorkingDir, this.myPorts);
        this.myCommandLine = generalCommandLine.getCommandLineString();
        try {
            this.initAndRun(generalCommandLine);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Connecting to Console", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setText("Connecting to console...");
                    PydevConsoleRunnerImpl.this.connect(PydevConsoleRunnerImpl.this.myStatementsToExecute);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$1", "run"));
                }
            });
        }
        catch (ExecutionException e) {
            LOG.warn("Error running console", (Throwable)e);
            this.showErrorsInConsole((Exception)((Object)e));
        }
    }

    @Override
    public void run() {
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> FileDocumentManager.getInstance().saveAllDocuments());
        this.myPorts = PydevConsoleRunnerImpl.findAvailablePorts(this.myProject, this.myConsoleType);
        assert (this.myPorts != null);
        final GeneralCommandLine generalCommandLine = this.createCommandLine(this.mySdk, this.myEnvironmentVariables, this.myWorkingDir, this.myPorts);
        this.myCommandLine = generalCommandLine.getCommandLineString();
        UIUtil.invokeLaterIfNeeded(() -> ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Connecting to Console", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText("Connecting to console...");
                try {
                    PydevConsoleRunnerImpl.this.initAndRun(generalCommandLine);
                    PydevConsoleRunnerImpl.this.connect(PydevConsoleRunnerImpl.this.myStatementsToExecute);
                }
                catch (Exception e) {
                    LOG.warn("Error running console", (Throwable)e);
                    UIUtil.invokeAndWaitIfNeeded(() -> PydevConsoleRunnerImpl.this.showErrorsInConsole(e));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$2", "run"));
            }
        }));
    }

    private void showErrorsInConsole(Exception e) {
        String[] messages;
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{this.createRerunAction()});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunnerErrors", (ActionGroup)actionGroup, false);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)actionToolbar.getComponent(), "West");
        NewErrorTreeViewPanel errorViewPanel = new NewErrorTreeViewPanel(this.myProject, null, false, false, null);
        String[] stringArray = messages = StringUtil.isNotEmpty((String)e.getMessage()) ? StringUtil.splitByLines((String)e.getMessage()) : ArrayUtil.EMPTY_STRING_ARRAY;
        if (messages.length == 0) {
            messages = new String[]{"Unknown error"};
        }
        errorViewPanel.addMessage(4, messages, null, -1, -1, null);
        panel2.add((Component)errorViewPanel, "Center");
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, (ProcessHandler)this.myProcessHandler, (JComponent)panel2, "Error running console");
        actionGroup.add(this.createCloseAction(contentDescriptor));
        this.showContentDescriptor(contentDescriptor);
    }

    protected void showContentDescriptor(RunContentDescriptor contentDescriptor) {
        ToolWindow toolwindow = PythonConsoleToolWindow.getToolWindow(this.myProject);
        if (toolwindow != null) {
            PythonConsoleToolWindow.getInstance(this.myProject).init(toolwindow, contentDescriptor);
        } else {
            ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(PydevConsoleRunnerImpl.getExecutor(), contentDescriptor);
        }
    }

    private static Executor getExecutor() {
        return DefaultRunExecutor.getRunExecutorInstance();
    }

    @Nullable
    public static int[] findAvailablePorts(Project project, PyConsoleType consoleType) {
        int[] ports;
        try {
            ports = NetUtils.findAvailableSocketPorts((int)2);
        }
        catch (IOException e) {
            ExecutionHelper.showErrors(project, Collections.singletonList(e), consoleType.getTitle(), null);
            return null;
        }
        return ports;
    }

    protected GeneralCommandLine createCommandLine(@NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, @NotNull int[] ports) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(6);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(7);
        }
        if (ports == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(8);
        }
        return this.doCreateConsoleCmdLine(sdk, environmentVariables, workingDir, ports, PythonHelper.CONSOLE);
    }

    @NotNull
    protected GeneralCommandLine doCreateConsoleCmdLine(@NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, @NotNull int[] ports, PythonHelper helper) {
        ParamsGroup group;
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(9);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(10);
        }
        if (ports == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(11);
        }
        GeneralCommandLine cmd = PythonCommandLineState.createPythonCommandLine(this.myProject, new PythonConsoleRunParams(this.myConsoleSettings, workingDir, sdk, environmentVariables), false, PtyCommandLine.isEnabled() && !SystemInfo.isWindows);
        cmd.withWorkDirectory(this.myWorkingDir);
        ParamsGroup exeGroup = cmd.getParametersList().getParamsGroup("Exe Options");
        if (exeGroup != null && !this.myConsoleSettings.getInterpreterOptions().isEmpty()) {
            exeGroup.addParametersString(this.myConsoleSettings.getInterpreterOptions());
        }
        if ((group = cmd.getParametersList().getParamsGroup("Script")) == null) {
            group = cmd.getParametersList().addParamsGroup("Script");
        }
        helper.addToGroup(group, cmd);
        for (int port : ports) {
            group.addParameter(String.valueOf(port));
        }
        GeneralCommandLine generalCommandLine = cmd;
        if (generalCommandLine == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(12);
        }
        return generalCommandLine;
    }

    private PythonConsoleView createConsoleView() {
        PythonConsoleView consoleView = new PythonConsoleView(this.myProject, this.myTitle, this.mySdk, false);
        this.myPydevConsoleCommunication.setConsoleFile(consoleView.getVirtualFile());
        consoleView.addMessageFilter(new PythonTracebackFilter(this.myProject));
        return consoleView;
    }

    @NotNull
    private Process createProcess(@NotNull GeneralCommandLine generalCommandLine) throws ExecutionException {
        if (generalCommandLine == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(13);
        }
        if (PySdkUtil.isRemote(this.mySdk)) {
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            if (manager != null) {
                UsageTrigger.trigger("python.console.remote");
                PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
                CredentialsType connectionType = data.getRemoteConnectionType();
                if (connectionType == CredentialsType.SSH_HOST || connectionType == CredentialsType.WEB_DEPLOYMENT || connectionType == CredentialsType.VAGRANT) {
                    RemoteProcess remoteProcess = this.createRemoteConsoleProcess(manager, generalCommandLine);
                    if (remoteProcess == null) {
                        PydevConsoleRunnerImpl.$$$reportNull$$$0(14);
                    }
                    return remoteProcess;
                }
                RemoteConsoleProcessData remoteConsoleProcessData = PythonConsoleRemoteProcessCreatorKt.createRemoteConsoleProcess(manager, generalCommandLine.getParametersList().getArray(), generalCommandLine.getEnvironment(), generalCommandLine.getWorkDirectory(), PydevConsoleRunner.getPathMapper(this.myProject, this.mySdk, this.myConsoleSettings), this.myProject, data, this.getRunnerFileFromHelpers());
                this.myRemoteProcessHandlerBase = remoteConsoleProcessData.getRemoteProcessHandlerBase();
                this.myCommandLine = this.myRemoteProcessHandlerBase.getCommandLine();
                this.myPydevConsoleCommunication = remoteConsoleProcessData.getPydevConsoleCommunication();
                Object t = this.myRemoteProcessHandlerBase.getProcess();
                if (t == null) {
                    PydevConsoleRunnerImpl.$$$reportNull$$$0(15);
                }
                return t;
            }
            throw new PythonRemoteInterpreterManager.PyRemoteInterpreterExecutionException();
        }
        this.myCommandLine = generalCommandLine.getCommandLineString();
        Map envs = generalCommandLine.getEnvironment();
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((Map)envs, (Charset)generalCommandLine.getCharset());
        UsageTrigger.trigger("python.console.local");
        Process server = generalCommandLine.createProcess();
        try {
            this.myPydevConsoleCommunication = new PydevConsoleCommunication(this.myProject, this.myPorts[0], server, this.myPorts[1]);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage());
        }
        Process process2 = server;
        if (process2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(16);
        }
        return process2;
    }

    protected String getRunnerFileFromHelpers() {
        return PYDEV_PYDEVCONSOLE_PY;
    }

    private RemoteProcess createRemoteConsoleProcess(PythonRemoteInterpreterManager manager, @NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(17);
        }
        PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
        assert (data != null);
        ParamsGroup scriptParams = commandLine.getParametersList().getParamsGroup("Script");
        if (scriptParams != null) {
            scriptParams.getParametersList().set(1, "0");
            scriptParams.getParametersList().set(2, "0");
        }
        try {
            PyRemotePathMapper pathMapper = PydevConsoleRunner.getPathMapper(this.myProject, this.mySdk, this.myConsoleSettings);
            assert (pathMapper != null);
            commandLine.putUserData(PyRemoteProcessStarter.OPEN_FOR_INCOMING_CONNECTION, (Object)true);
            commandLine.putUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS, (Object)this.buildDockerPathMappings());
            this.myRemoteProcessHandlerBase = PyRemoteProcessStarterManagerUtil.getManager(data).startRemoteProcess(this.myProject, commandLine, manager, data, pathMapper);
            this.myCommandLine = this.myRemoteProcessHandlerBase.getCommandLine();
            Object remoteProcess = this.myRemoteProcessHandlerBase.getProcess();
            Couple<Integer> remotePorts = PydevConsoleRunnerImpl.getRemotePortsFromProcess(remoteProcess);
            if (remoteProcess instanceof Tunnelable) {
                Tunnelable tunnelableProcess = (Tunnelable)remoteProcess;
                tunnelableProcess.addLocalTunnel(this.myPorts[0], (Integer)remotePorts.first);
                tunnelableProcess.addRemoteTunnel((Integer)remotePorts.second, "localhost", this.myPorts[1]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Using tunneled communication for Python console: port %d (=> %d) on IDE side, port %d (=> %d) on pydevconsole.py side", this.myPorts[1], remotePorts.second, this.myPorts[0], remotePorts.first));
                }
                this.myPydevConsoleCommunication = new PydevRemoteConsoleCommunication(this.myProject, this.myPorts[0], (Process)remoteProcess, this.myPorts[1]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Using direct communication for Python console: port %d on IDE side, port %d on pydevconsole.py side", remotePorts.second, remotePorts.first));
                }
                this.myPydevConsoleCommunication = new PydevRemoteConsoleCommunication(this.myProject, (Integer)remotePorts.first, (Process)remoteProcess, (Integer)remotePorts.second);
            }
            return remoteProcess;
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private PathMappingSettings buildDockerPathMappings() {
        PathMappingSettings pathMappingSettings = new PathMappingSettings(Collections.singletonList(new PathMappingSettings.PathMapping(this.myProject.getBasePath(), DOCKER_CONTAINER_PROJECT_PATH)));
        if (pathMappingSettings == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(18);
        }
        return pathMappingSettings;
    }

    public static Couple<Integer> getRemotePortsFromProcess(RemoteProcess process2) throws ExecutionException {
        Scanner s = new Scanner(process2.getInputStream());
        return Couple.of((Object)PydevConsoleRunnerImpl.readInt(s, process2), (Object)PydevConsoleRunnerImpl.readInt(s, process2));
    }

    private static int readInt(Scanner s, Process process2) throws ExecutionException {
        long started = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        while (System.currentTimeMillis() - started < 20000L) {
            String error;
            if (s.hasNextLine()) {
                String line = s.nextLine();
                sb.append(line).append("\n");
                try {
                    int i = Integer.parseInt(line);
                    if (flag) {
                        LOG.warn("Unexpected strings in output:\n" + sb.toString());
                    }
                    return i;
                }
                catch (NumberFormatException ignored) {
                    flag = true;
                    continue;
                }
            }
            TimeoutUtil.sleep((long)200L);
            if (process2.exitValue() == 0) break;
            try {
                error = "Console process terminated with error:\n" + StreamUtil.readText((InputStream)process2.getErrorStream()) + sb.toString();
            }
            catch (Exception ignored) {
                error = "Console process terminated with exit code " + process2.exitValue() + ", output:" + sb.toString();
            }
            throw new ExecutionException(error);
        }
        throw new ExecutionException("Couldn't read integer value from stream");
    }

    private PyConsoleProcessHandler createProcessHandler(Process process2) {
        if (PySdkUtil.isRemote(this.mySdk)) {
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            if (manager != null) {
                PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
                assert (data != null);
                this.myProcessHandler = manager.createConsoleProcessHandler((RemoteProcess)process2, this.myConsoleView, this.myPydevConsoleCommunication, this.myCommandLine, CharsetToolkit.UTF8_CHARSET, manager.setupMappings(this.myProject, data, null), this.myRemoteProcessHandlerBase.getRemoteSocketToLocalHostProvider());
            } else {
                LOG.error("Can't create remote console process handler");
            }
        } else {
            this.myProcessHandler = new PyConsoleProcessHandler(process2, this.myConsoleView, this.myPydevConsoleCommunication, this.myCommandLine, CharsetToolkit.UTF8_CHARSET);
        }
        return this.myProcessHandler;
    }

    private void initAndRun(@NotNull GeneralCommandLine generalCommandLine) throws ExecutionException {
        if (generalCommandLine == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(19);
        }
        Process process2 = this.createProcess(generalCommandLine);
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myConsoleView = this.createConsoleView();
            if (this.myConsoleView != null) {
                this.myConsoleView.setBorder((Border)new SideBorder(JBColor.border(), 1));
            }
            this.myProcessHandler = this.createProcessHandler(process2);
            this.myConsoleExecuteActionHandler = this.createExecuteActionHandler();
            ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
            final PythonConsoleView consoleView = this.myConsoleView;
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    consoleView.setEditable(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/console/PydevConsoleRunnerImpl$3", "processTerminated"));
                }
            });
            this.myConsoleView.attachToProcess((ProcessHandler)this.myProcessHandler);
            this.createContentDescriptorAndActions();
            this.myProcessHandler.startNotify();
        });
    }

    protected void createContentDescriptorAndActions() {
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunner", (ActionGroup)toolbarActions, false);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)actionToolbar.getComponent(), "West");
        panel2.add((Component)this.myConsoleView.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)panel2);
        if (this.myConsoleTitle == null) {
            this.myConsoleTitle = new ConsoleTitleGen(this.myProject, this.myTitle){

                @Override
                @NotNull
                protected List<String> getActiveConsoles(@NotNull String consoleTitle) {
                    PythonConsoleToolWindow toolWindow;
                    if (consoleTitle == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if ((toolWindow = PythonConsoleToolWindow.getInstance(PydevConsoleRunnerImpl.this.myProject)) != null && toolWindow.getToolWindow() != null) {
                        List<String> list2 = Lists.newArrayList((Object[])toolWindow.getToolWindow().getContentManager().getContents()).stream().map(c -> c.getDisplayName()).collect(Collectors.toList());
                        if (list2 == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return list2;
                    }
                    List<String> list3 = super.getActiveConsoles(consoleTitle);
                    if (list3 == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return list3;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "consoleTitle";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$4";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActiveConsoles";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getActiveConsoles";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.makeTitle();
        }
        RunContentDescriptor contentDescriptor = new RunContentDescriptor((ExecutionConsole)this.myConsoleView, (ProcessHandler)this.myProcessHandler, (JComponent)panel2, this.myConsoleTitle, null);
        contentDescriptor.setFocusComputable(() -> this.myConsoleView.getConsoleEditor().getContentComponent());
        contentDescriptor.setAutoFocusContent(true);
        List<AnAction> actions = this.fillToolBarActions(toolbarActions, contentDescriptor);
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, this.myConsoleView.getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, panel2);
        this.getConsoleView().addConsoleFolding(false);
        this.showContentDescriptor(contentDescriptor);
    }

    private void connect(String[] statements2execute) {
        if (this.handshake()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                final PythonConsoleView consoleView = this.myConsoleView;
                consoleView.setConsoleCommunication((ConsoleCommunication)this.myPydevConsoleCommunication);
                consoleView.setSdk(this.mySdk);
                consoleView.setExecutionHandler(this.myConsoleExecuteActionHandler);
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        consoleView.print(event.getText(), outputType);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$5";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                if (this.myEnableAfterConnection) {
                    this.enableConsoleExecuteAction();
                }
                if (statements2execute.length == 1 && statements2execute[0].isEmpty()) {
                    statements2execute[0] = "\t";
                }
                for (String statement : statements2execute) {
                    consoleView.executeStatement(statement + "\n", ProcessOutputTypes.SYSTEM);
                }
                this.fireConsoleInitializedEvent(consoleView);
                consoleView.initialized();
            });
        } else {
            this.myConsoleView.print("Couldn't connect to console process.", ProcessOutputTypes.STDERR);
            this.myProcessHandler.destroyProcess();
            this.myConsoleView.setEditable(false);
        }
    }

    protected AnAction createRerunAction() {
        return new RestartAction(this);
    }

    private void enableConsoleExecuteAction() {
        this.myConsoleExecuteActionHandler.setEnabled(true);
    }

    private boolean handshake() {
        boolean res;
        long started = System.currentTimeMillis();
        while (true) {
            long now;
            try {
                res = this.myPydevConsoleCommunication.handshake();
            }
            catch (XmlRpcException ignored) {
                res = false;
            }
            if (res || (now = System.currentTimeMillis()) - started > 60000L) break;
            TimeoutUtil.sleep((long)100L);
        }
        return res;
    }

    private AnAction createStopAction() {
        final AnAction generalStopAction = ActionManager.getInstance().getAction("Stop");
        DumbAwareAction stopAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                generalStopAction.update(e);
            }

            public void actionPerformed(AnActionEvent e) {
                e = PydevConsoleRunnerImpl.this.stopConsole(e);
                generalStopAction.actionPerformed(e);
            }
        };
        stopAction.copyFrom(generalStopAction);
        return stopAction;
    }

    private AnAction createCloseAction(RunContentDescriptor descriptor2) {
        CloseAction generalCloseAction = new CloseAction(PydevConsoleRunnerImpl.getExecutor(), descriptor2, this.myProject);
        DumbAwareAction stopAction = new DumbAwareAction((AnAction)generalCloseAction, descriptor2){
            final /* synthetic */ AnAction val$generalCloseAction;
            final /* synthetic */ RunContentDescriptor val$descriptor;
            {
                this.val$generalCloseAction = anAction;
                this.val$descriptor = runContentDescriptor;
            }

            public void update(AnActionEvent e) {
                this.val$generalCloseAction.update(e);
            }

            public void actionPerformed(AnActionEvent e) {
                e = PydevConsoleRunnerImpl.this.stopConsole(e);
                PydevConsoleRunnerImpl.this.clearContent(this.val$descriptor);
                this.val$generalCloseAction.actionPerformed(e);
            }
        };
        stopAction.copyFrom((AnAction)generalCloseAction);
        return stopAction;
    }

    protected void clearContent(RunContentDescriptor descriptor2) {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(this.myProject);
        if (toolWindow != null && toolWindow.getToolWindow() != null) {
            Content content = toolWindow.getToolWindow().getContentManager().findContent(descriptor2.getDisplayName());
            assert (content != null);
            toolWindow.getToolWindow().getContentManager().removeContent(content, true);
        }
    }

    private AnActionEvent stopConsole(AnActionEvent e) {
        if (this.myPydevConsoleCommunication != null) {
            e = new AnActionEvent(e.getInputEvent(), e.getDataContext(), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
            try {
                this.closeCommunication();
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return e;
    }

    protected AnAction createSplitLineAction() {
        class ConsoleSplitLineAction
        extends EditorAction {
            private static final String CONSOLE_SPLIT_LINE_ACTION_ID = "Console.SplitLine";

            public ConsoleSplitLineAction() {
                super((EditorActionHandler)new EditorWriteActionHandler(){
                    private final SplitLineAction mySplitLineAction = new SplitLineAction();

                    public boolean isEnabled(Editor editor, DataContext dataContext) {
                        return this.mySplitLineAction.getHandler().isEnabled(editor, dataContext);
                    }

                    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
                        ((EditorWriteActionHandler)this.mySplitLineAction.getHandler()).executeWriteAction(editor, caret, dataContext);
                        editor.getCaretModel().getCurrentCaret().moveCaretRelatively(0, 1, false, true);
                    }
                });
            }

            public void setup() {
                EmptyAction.setupAction((AnAction)this, (String)CONSOLE_SPLIT_LINE_ACTION_ID, null);
            }
        }
        ConsoleSplitLineAction action = new ConsoleSplitLineAction();
        action.setup();
        return action;
    }

    private void closeCommunication() {
        if (!this.myProcessHandler.isProcessTerminated()) {
            this.myPydevConsoleCommunication.close();
        }
    }

    @NotNull
    protected PythonConsoleExecuteActionHandler createExecuteActionHandler() {
        this.myConsoleExecuteActionHandler = new PydevConsoleExecuteActionHandler(this.myConsoleView, (ProcessHandler)this.myProcessHandler, (ConsoleCommunication)this.myPydevConsoleCommunication);
        this.myConsoleExecuteActionHandler.setEnabled(false);
        new ConsoleHistoryController(this.myConsoleType.getTypeId(), "", (LanguageConsoleView)this.myConsoleView).install();
        PythonConsoleExecuteActionHandler pythonConsoleExecuteActionHandler = this.myConsoleExecuteActionHandler;
        if (pythonConsoleExecuteActionHandler == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(20);
        }
        return pythonConsoleExecuteActionHandler;
    }

    @Override
    public PydevConsoleCommunication getPydevConsoleCommunication() {
        return this.myPydevConsoleCommunication;
    }

    static VirtualFile getConsoleFile(PsiFile psiFile) {
        VirtualFile file2 = psiFile.getViewProvider().getVirtualFile();
        if (file2 instanceof LightVirtualFile) {
            file2 = ((LightVirtualFile)file2).getOriginalFile();
        }
        return file2;
    }

    @Override
    public void addConsoleListener(PydevConsoleRunner.ConsoleListener consoleListener) {
        this.myConsoleListeners.add(consoleListener);
    }

    private void fireConsoleInitializedEvent(LanguageConsoleView consoleView) {
        for (PydevConsoleRunner.ConsoleListener listener2 : this.myConsoleListeners) {
            listener2.handleConsoleInitialized(consoleView);
        }
        this.myConsoleListeners.clear();
    }

    @Override
    public PythonConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        return this.myConsoleExecuteActionHandler;
    }

    private void rerun() {
        new Task.Backgroundable(this.myProject, "Restarting Console", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (PydevConsoleRunnerImpl.this.myProcessHandler != null) {
                    UIUtil.invokeAndWaitIfNeeded(() -> PydevConsoleRunnerImpl.this.closeCommunication());
                    boolean processStopped = PydevConsoleRunnerImpl.this.myProcessHandler.waitFor(5000L);
                    if (!processStopped && PydevConsoleRunnerImpl.this.myProcessHandler.canKillProcess()) {
                        PydevConsoleRunnerImpl.this.myProcessHandler.killProcess();
                    }
                    PydevConsoleRunnerImpl.this.myProcessHandler.waitFor();
                }
                GuiUtils.invokeLaterIfNeeded(() -> PydevConsoleRunnerImpl.this.myRerunAction.consume((Object)PydevConsoleRunnerImpl.this.myConsoleTitle), (ModalityState)ModalityState.defaultModalityState());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$8", "run"));
            }
        }.queue();
    }

    private XDebugSession connectToDebugger() throws ExecutionException {
        final ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        XDebugSession session2 = XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab("Python Console Debugger", PythonIcons.Python.Python, null, true, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(final @NotNull XDebugSession session2) {
                if (session2 == null) {
                    9.$$$reportNull$$$0(0);
                }
                PythonDebugLanguageConsoleView debugConsoleView = new PythonDebugLanguageConsoleView(PydevConsoleRunnerImpl.this.myProject, PydevConsoleRunnerImpl.this.mySdk);
                PyConsoleDebugProcessHandler consoleDebugProcessHandler = new PyConsoleDebugProcessHandler(PydevConsoleRunnerImpl.this.myProcessHandler);
                PyConsoleDebugProcess consoleDebugProcess = new PyConsoleDebugProcess(session2, serverSocket, (ExecutionConsole)debugConsoleView, consoleDebugProcessHandler);
                PythonDebugConsoleCommunication communication = PyDebugRunner.initDebugConsoleView(PydevConsoleRunnerImpl.this.myProject, consoleDebugProcess, debugConsoleView, consoleDebugProcessHandler, session2);
                communication.addCommunicationListener(new ConsoleCommunicationListener(){

                    public void commandExecuted(boolean more) {
                        session2.rebuildViews();
                    }

                    public void inputRequested() {
                    }
                });
                PydevConsoleRunnerImpl.this.myPydevConsoleCommunication.setDebugCommunication(communication);
                debugConsoleView.attachToProcess(consoleDebugProcessHandler);
                consoleDebugProcess.waitForNextConnection();
                try {
                    consoleDebugProcess.connect(PydevConsoleRunnerImpl.this.myPydevConsoleCommunication);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                PydevConsoleRunnerImpl.this.myProcessHandler.notifyTextAvailable("\nDebugger connected.\n", ProcessOutputTypes.STDERR);
                PyConsoleDebugProcess pyConsoleDebugProcess = consoleDebugProcess;
                if (pyConsoleDebugProcess == null) {
                    9.$$$reportNull$$$0(1);
                }
                return pyConsoleDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$9";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return session2;
    }

    @Override
    public PyConsoleProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Override
    public PythonConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    public static PythonConsoleRunnerFactory factory() {
        return new PydevConsoleRunnerFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentVariables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ports";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalCommandLine";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleCmdLine";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerPathMappings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecuteActionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConsoleCmdLine";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteConsoleProcess";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "initAndRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PythonConsoleRunParams
    implements PythonRunParams {
        private final PyConsoleOptions.PyConsoleSettings myConsoleSettings;
        private String myWorkingDir;
        private Sdk mySdk;
        private Map<String, String> myEnvironmentVariables;

        public PythonConsoleRunParams(@NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @Nullable String workingDir, @NotNull Sdk sdk, @NotNull Map<String, String> envs) {
            if (consoleSettings == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(1);
            }
            if (envs == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(2);
            }
            this.myConsoleSettings = consoleSettings;
            this.myWorkingDir = workingDir;
            this.mySdk = sdk;
            this.myEnvironmentVariables = envs;
            this.myEnvironmentVariables.putAll(consoleSettings.getEnvs());
            PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
            if (debuggerSettings.isLoadValuesAsync()) {
                this.myEnvironmentVariables.put("PYDEVD_LOAD_VALUES_ASYNC", "True");
            }
        }

        @Override
        public String getInterpreterOptions() {
            return this.myConsoleSettings.getInterpreterOptions();
        }

        @Override
        public void setInterpreterOptions(String interpreterOptions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkingDirectory() {
            return this.myWorkingDir;
        }

        @Override
        public void setWorkingDirectory(String workingDirectory) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getSdkHome() {
            return this.mySdk.getHomePath();
        }

        @Override
        public void setSdkHome(String sdkHome) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setModule(Module module2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getModuleName() {
            return this.myConsoleSettings.getModuleName();
        }

        @Override
        public boolean isUseModuleSdk() {
            return this.myConsoleSettings.isUseModuleSdk();
        }

        @Override
        public void setUseModuleSdk(boolean useModuleSdk) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPassParentEnvs() {
            return this.myConsoleSettings.isPassParentEnvs();
        }

        @Override
        public void setPassParentEnvs(boolean passParentEnvs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getEnvs() {
            return this.myEnvironmentVariables;
        }

        @Override
        public void setEnvs(Map<String, String> envs) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public PathMappingSettings getMappingSettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldAddContentRoots() {
            return this.myConsoleSettings.shouldAddContentRoots();
        }

        @Override
        public boolean shouldAddSourceRoots() {
            return this.myConsoleSettings.shouldAddSourceRoots();
        }

        @Override
        public void setAddContentRoots(boolean flag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAddSourceRoots(boolean flag) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleSettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "envs";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$PythonConsoleRunParams";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NewConsoleAction
    extends AnAction
    implements DumbAware {
        public NewConsoleAction() {
            super("New Console", "Creates new python console", AllIcons.General.Add);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(AnActionEvent e) {
            PydevConsoleRunner runner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner((Project)e.getData(CommonDataKeys.PROJECT), (Module)e.getData(LangDataKeys.MODULE));
            runner.run();
        }
    }

    private class ConnectDebuggerAction
    extends ToggleAction
    implements DumbAware {
        private boolean mySelected;
        private XDebugSession mySession;

        public ConnectDebuggerAction() {
            super("Attach Debugger", "Enables tracing of code executed in console", AllIcons.Actions.StartDebugger);
            this.mySelected = false;
            this.mySession = null;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySelected;
        }

        public void update(AnActionEvent e) {
            if (this.mySession != null) {
                e.getPresentation().setEnabled(false);
            } else {
                super.update(e);
                e.getPresentation().setEnabled(true);
            }
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            this.mySelected = state2;
            if (this.mySelected) {
                try {
                    this.mySession = PydevConsoleRunnerImpl.this.connectToDebugger();
                }
                catch (Exception e1) {
                    LOG.error((Throwable)e1);
                    Messages.showErrorDialog((String)"Can't connect to debugger", (String)"Error Connecting Debugger");
                }
            }
        }
    }

    private static class RestartAction
    extends AnAction {
        private PydevConsoleRunnerImpl myConsoleRunner;

        private RestartAction(PydevConsoleRunnerImpl runner) {
            this.copyFrom(ActionManager.getInstance().getAction("Rerun"));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Restart);
            this.myConsoleRunner = runner;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myConsoleRunner.rerun();
        }
    }

    private class SoftWrapAction
    extends ToggleAction
    implements DumbAware {
        private boolean isSelected;

        SoftWrapAction() {
            super(ActionsBundle.actionText((String)"EditorToggleUseSoftWraps"), ActionsBundle.actionDescription((String)"EditorToggleUseSoftWraps"), AllIcons.Actions.ToggleSoftWrap);
            this.isSelected = PydevConsoleRunnerImpl.this.myConsoleSettings.isUseSoftWraps();
            this.updateEditors();
        }

        public boolean isSelected(AnActionEvent e) {
            return this.isSelected;
        }

        private void updateEditors() {
            PydevConsoleRunnerImpl.this.myConsoleView.getEditor().getSettings().setUseSoftWraps(this.isSelected);
            PydevConsoleRunnerImpl.this.myConsoleView.getConsoleEditor().getSettings().setUseSoftWraps(this.isSelected);
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            this.isSelected = state2;
            this.updateEditors();
            PydevConsoleRunnerImpl.this.myConsoleSettings.setUseSoftWraps(this.isSelected);
        }
    }
}

