/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0003J\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\"\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0012\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/documentation/PyDocumentationLink;", "", "()V", "LINK_TYPE_CLASS", "", "LINK_TYPE_PARAM", "LINK_TYPE_TYPENAME", "containingClass", "Lcom/jetbrains/python/psi/PyClass;", "element", "Lcom/intellij/psi/PsiElement;", "elementForLink", "link", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "parameterPossibleClass", "parameter", "possibleClass", "type", "anchor", "toContainingClass", "content", "toParameterPossibleClass", "toPossibleClass", "qualifiedName", "python-community"})
public final class PyDocumentationLink {
    private static final String LINK_TYPE_CLASS = "#class#";
    private static final String LINK_TYPE_PARAM = "#param#";
    private static final String LINK_TYPE_TYPENAME = "#typename#";
    public static final PyDocumentationLink INSTANCE;

    @JvmStatic
    @NotNull
    public static final String toContainingClass(@Nullable String content) {
        return "<a href=\"psi_element://#class#\">" + content + "</a>";
    }

    @JvmStatic
    @NotNull
    public static final String toParameterPossibleClass(@NotNull String type, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        PyType pyType;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PyType pyType2 = pyType = PyTypeParser.getTypeByName(anchor, type, context);
        return pyType2 instanceof PyClassType ? "<a href=\"psi_element://#param#\">" + type + "</a>" : type;
    }

    @JvmStatic
    @NotNull
    public static final String toPossibleClass(@NotNull String type, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return PyDocumentationLink.toPossibleClass(type, type, anchor, context);
    }

    @JvmStatic
    @NotNull
    public static final String toPossibleClass(@NotNull String content, @NotNull String qualifiedName, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        PyType pyType;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PyType pyType2 = pyType = PyTypeParser.getTypeByName(anchor, qualifiedName, context);
        return pyType2 instanceof PyClassType ? "<a href=\"psi_element://#typename#" + qualifiedName + "\">" + content + "</a>" : content;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement elementForLink(@NotNull String link, @NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)link, (Object)LINK_TYPE_CLASS)) {
            psiElement = (PsiElement)PyDocumentationLink.containingClass(element);
        } else {
            PyClass pyClass;
            if (Intrinsics.areEqual((Object)link, (Object)LINK_TYPE_PARAM)) {
                pyClass = PyDocumentationLink.parameterPossibleClass(element, context);
            } else if (StringsKt.startsWith$default((String)link, (String)LINK_TYPE_TYPENAME, (boolean)false, (int)2, null)) {
                String string = link;
                int n = LINK_TYPE_TYPENAME.length();
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                pyClass = PyDocumentationLink.possibleClass(string2, element, context);
            } else {
                pyClass = null;
            }
            psiElement = (PsiElement)pyClass;
        }
        return psiElement;
    }

    @JvmStatic
    private static final PyClass containingClass(PsiElement element) {
        PsiElement psiElement = element;
        return psiElement instanceof PyClass ? (PyClass)element : (psiElement instanceof PyFunction ? ((PyFunction)element).getContainingClass() : (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class));
    }

    @JvmStatic
    private static final PyClass parameterPossibleClass(PsiElement parameter, TypeEvalContext context) {
        PyType type;
        if (parameter instanceof PyNamedParameter && (type = context.getType((PyTypedElement)parameter)) instanceof PyClassType) {
            return ((PyClassType)type).getPyClass();
        }
        return null;
    }

    @JvmStatic
    private static final PyClass possibleClass(String type, PsiElement anchor, TypeEvalContext context) {
        PyType pyType = PyTypeParser.getTypeByName(anchor, type, context);
        PyType pyType2 = pyType;
        return pyType2 instanceof PyClassType ? ((PyClassType)pyType).getPyClass() : null;
    }

    private PyDocumentationLink() {
    }

    static {
        PyDocumentationLink pyDocumentationLink;
        INSTANCE = pyDocumentationLink = new PyDocumentationLink();
    }
}

