/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.quickfix.ConvertIndentsFix;
import com.jetbrains.python.lexer.PythonIndentingLexer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyInconsistentIndentationInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Inconsistent indentation" == null) {
            PyInconsistentIndentationInspection.$$$reportNull$$$0(0);
        }
        return "Inconsistent indentation";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            PyInconsistentIndentationInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            PyInconsistentIndentationInspection.$$$reportNull$$$0(2);
        }
        if (file2.getLanguage() instanceof PythonLanguage) {
            return new IndentValidator(file2, manager, isOnTheFly).invoke();
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyInconsistentIndentationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyInconsistentIndentationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IndentValidator {
        private PsiFile myFile;
        private InspectionManager myManager;
        private boolean myOnTheFly;
        private List<ProblemDescriptor> myProblems;
        private int myLastTabs = 0;
        private int myLastSpaces = 0;

        public IndentValidator(PsiFile file2, InspectionManager manager, boolean isOnTheFly) {
            this.myFile = file2;
            this.myManager = manager;
            this.myOnTheFly = isOnTheFly;
            this.myProblems = new ArrayList<ProblemDescriptor>();
        }

        public ProblemDescriptor[] invoke() {
            PythonIndentingLexer lexer = new PythonIndentingLexer();
            String text = this.myFile.getText();
            lexer.start(text);
            while (lexer.getTokenType() != null) {
                IElementType tokenType = lexer.getTokenType();
                if (tokenType == PyTokenTypes.STATEMENT_BREAK) {
                    lexer.advance();
                    while (lexer.getTokenType() != null && lexer.getTokenType() != PyTokenTypes.LINE_BREAK) {
                        lexer.advance();
                    }
                    if (lexer.getTokenType() == PyTokenTypes.LINE_BREAK) {
                        String indent = text.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                        this.validateIndent(lexer.getTokenStart(), indent);
                    }
                }
                lexer.advance();
            }
            return this.myProblems.toArray(new ProblemDescriptor[this.myProblems.size()]);
        }

        private void validateIndent(int tokenStart, String indent) {
            int lastLF = indent.lastIndexOf(10);
            String lastLineIndent = indent.substring(lastLF + 1);
            int spaces = 0;
            int tabs = 0;
            int length = lastLineIndent.length();
            for (int i = 0; i < length; ++i) {
                char c = lastLineIndent.charAt(i);
                if (c == ' ') {
                    ++spaces;
                    continue;
                }
                if (c != '\t') continue;
                ++tabs;
            }
            int problemStart = tokenStart + lastLF + 1;
            if (spaces > 0 && tabs > 0) {
                this.reportProblem("Inconsistent indentation: mix of tabs and spaces", problemStart, length);
                this.myLastSpaces = 0;
                this.myLastTabs = 0;
            } else {
                if (spaces > 0 && this.myLastTabs > 0) {
                    this.reportProblem("Inconsistent indentation: previous line used tabs, this line uses spaces", problemStart, length);
                } else if (tabs > 0 && this.myLastSpaces > 0) {
                    this.reportProblem("Inconsistent indentation: previous line used spaces, this line uses tabs", problemStart, length);
                }
                if (spaces > 0 || tabs > 0) {
                    this.myLastTabs = tabs;
                    this.myLastSpaces = spaces;
                }
            }
        }

        private void reportProblem(String descriptionTemplate, int problemStart, int problemLength) {
            PsiElement elt = this.myFile.findElementAt(problemStart);
            int startOffset = problemStart - elt.getTextRange().getStartOffset();
            int endOffset = startOffset + problemLength;
            this.myProblems.add(this.myManager.createProblemDescriptor(elt, new TextRange(startOffset, endOffset), descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[]{new ConvertIndentsFix(false), new ConvertIndentsFix(true)}));
        }
    }
}

