/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.packaging.PyPIPackageCache;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyAbstractPackageCache {
    private static final Logger LOG = Logger.getInstance(PyPIPackageCache.class);
    private static final Gson ourGson = new GsonBuilder().create();
    @SerializedName(value="packages")
    protected TreeMap<String, PackageInfo> myPackages = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    protected PyAbstractPackageCache() {
    }

    @NotNull
    protected static <T extends PyAbstractPackageCache> T load(@NotNull Class<T> classToken, @NotNull T fallbackValue, @NotNull String cacheFileName) {
        if (classToken == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(0);
        }
        if (fallbackValue == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(1);
        }
        if (cacheFileName == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(2);
        }
        Object cache = fallbackValue;
        try (BufferedReader reader = Files.newBufferedReader(PyAbstractPackageCache.getCachePath(cacheFileName), StandardCharsets.UTF_8);){
            cache = (PyAbstractPackageCache)ourGson.fromJson((Reader)reader, classToken);
            LOG.info("Loaded " + ((PyAbstractPackageCache)cache).getPackageNames().size() + " packages from " + PyAbstractPackageCache.getCachePath(cacheFileName));
        }
        catch (IOException exception) {
            LOG.warn("Cannot load " + cacheFileName + " package cache from the filesystem", (Throwable)exception);
        }
        Object object = cache;
        if (object == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(3);
        }
        return (T)object;
    }

    protected static void store(@NotNull PyAbstractPackageCache newValue, @NotNull String cacheFileName) {
        if (newValue == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(4);
        }
        if (cacheFileName == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(5);
        }
        try {
            Path cacheFilePath = PyAbstractPackageCache.getCachePath(cacheFileName);
            Files.createDirectories(cacheFilePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(cacheFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                ourGson.toJson((Object)newValue, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            LOG.warn("Cannot save " + cacheFileName + " package cache to the filesystem", (Throwable)exception);
        }
    }

    @NotNull
    private static Path getCachePath(@NotNull String cacheFileName) {
        if (cacheFileName == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(6);
        }
        Path path = Paths.get(PathManager.getSystemPath(), "python_packages", cacheFileName);
        if (path == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(7);
        }
        return path;
    }

    @NotNull
    public Set<String> getPackageNames() {
        Set<String> set2 = Collections.unmodifiableSet(this.myPackages.keySet());
        if (set2 == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(8);
        }
        return set2;
    }

    public boolean containsPackage(@NotNull String name) {
        if (name == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(9);
        }
        return this.myPackages.containsKey(name);
    }

    @Nullable
    public List<String> getVersions(@NotNull String packageName) {
        PackageInfo packageInfo;
        if (packageName == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(10);
        }
        return (packageInfo = this.myPackages.get(packageName)) != null ? packageInfo.getVersions() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToken";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackValue";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFileName";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyAbstractPackageCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyAbstractPackageCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsPackage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PackageInfo {
        public static final PackageInfo EMPTY = new PackageInfo();
        @SerializedName(value="v")
        private List<String> myVersions;

        public PackageInfo(@NotNull List<String> versions) {
            if (versions == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            this.myVersions = versions;
        }

        public PackageInfo() {
        }

        @Nullable
        public List<String> getVersions() {
            return this.myVersions != null ? Collections.unmodifiableList(this.myVersions) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/jetbrains/python/packaging/PyAbstractPackageCache$PackageInfo", "<init>"));
        }
    }
}

