/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@State(name="PyPackageService", storages={@Storage(value="packages.xml", roamingType=RoamingType.DISABLED)})
public class PyPackageService
implements PersistentStateComponent<PyPackageService> {
    public volatile Map<String, Boolean> sdkToUsersite = ContainerUtil.newConcurrentMap();
    public volatile List<String> additionalRepositories = ContainerUtil.createConcurrentList();
    public volatile @SystemIndependent String virtualEnvBasePath;
    public volatile Boolean PYPI_REMOVED = false;
    public long LAST_TIME_CHECKED = 0L;

    public PyPackageService getState() {
        return this;
    }

    public void loadState(PyPackageService state2) {
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public void addSdkToUserSite(String sdk, boolean useUsersite) {
        this.sdkToUsersite.put(sdk, useUsersite);
    }

    public void addRepository(String repository) {
        if (repository == null) {
            return;
        }
        if (PyPIPackageUtil.isPyPIRepository(repository)) {
            this.PYPI_REMOVED = false;
        } else {
            if (!repository.endsWith("/")) {
                repository = repository + "/";
            }
            this.additionalRepositories.add(repository);
        }
    }

    public void removeRepository(String repository) {
        if (this.additionalRepositories.contains(repository)) {
            this.additionalRepositories.remove(repository);
        } else if (PyPIPackageUtil.isPyPIRepository(repository)) {
            this.PYPI_REMOVED = true;
        }
    }

    public boolean useUserSite(String sdk) {
        if (this.sdkToUsersite.containsKey(sdk)) {
            return this.sdkToUsersite.get(sdk);
        }
        return false;
    }

    public static PyPackageService getInstance() {
        return (PyPackageService)ServiceManager.getService(PyPackageService.class);
    }

    @Nullable
    public @SystemIndependent String getVirtualEnvBasePath() {
        return this.virtualEnvBasePath;
    }

    public void setVirtualEnvBasePath(@NotNull @SystemIndependent String virtualEnvBasePath) {
        if (virtualEnvBasePath == null) {
            PyPackageService.$$$reportNull$$$0(0);
        }
        this.virtualEnvBasePath = virtualEnvBasePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualEnvBasePath", "com/jetbrains/python/packaging/PyPackageService", "setVirtualEnvBasePath"));
    }
}

