/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PyCallExpression
extends PyCallSiteExpression {
    @Override
    @Nullable
    default public PyExpression getReceiver(@Nullable PyCallable resolvedCallee) {
        PyFunction function;
        if (resolvedCallee instanceof PyFunction && (function = (PyFunction)resolvedCallee).getModifier() == PyFunction.Modifier.STATICMETHOD) {
            return null;
        }
        PyExpression callee = this.getCallee();
        return callee instanceof PyQualifiedExpression ? ((PyQualifiedExpression)callee).getQualifier() : null;
    }

    @Override
    @NotNull
    default public List<PyExpression> getArguments(@Nullable PyCallable resolvedCallee) {
        List<PyExpression> list2 = Arrays.asList(this.getArguments());
        if (list2 == null) {
            PyCallExpression.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    public PyExpression getCallee();

    @Nullable
    default public PyArgumentList getArgumentList() {
        return (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyArgumentList.class);
    }

    @NotNull
    default public PyExpression[] getArguments() {
        PyArgumentList argList = this.getArgumentList();
        PyExpression[] pyExpressionArray = argList != null ? argList.getArguments() : PyExpression.EMPTY_ARRAY;
        if (pyExpressionArray == null) {
            PyCallExpression.$$$reportNull$$$0(1);
        }
        return pyExpressionArray;
    }

    @Nullable
    default public <T extends PsiElement> T getArgument(int index, @NotNull Class<T> argClass) {
        PyExpression[] args;
        if (argClass == null) {
            PyCallExpression.$$$reportNull$$$0(2);
        }
        return (T)((args = this.getArguments()).length > index ? (PsiElement)ObjectUtils.tryCast((Object)args[index], argClass) : null);
    }

    @Nullable
    default public <T extends PsiElement> T getArgument(int index, @NotNull String keyword, @NotNull Class<T> argClass) {
        PyExpression arg;
        if (keyword == null) {
            PyCallExpression.$$$reportNull$$$0(3);
        }
        if (argClass == null) {
            PyCallExpression.$$$reportNull$$$0(4);
        }
        if ((arg = this.getKeywordArgument(keyword)) != null) {
            return (T)((PsiElement)ObjectUtils.tryCast((Object)arg, argClass));
        }
        return this.getArgument(index, argClass);
    }

    @Nullable
    default public <T extends PsiElement> T getArgument(@NotNull FunctionParameter parameter, @NotNull Class<T> argClass) {
        PyArgumentList list2;
        if (parameter == null) {
            PyCallExpression.$$$reportNull$$$0(5);
        }
        if (argClass == null) {
            PyCallExpression.$$$reportNull$$$0(6);
        }
        if ((list2 = this.getArgumentList()) == null) {
            return null;
        }
        return (T)((PsiElement)ObjectUtils.tryCast((Object)list2.getValueExpressionForParam(parameter), argClass));
    }

    @Nullable
    default public PyExpression getKeywordArgument(@NotNull String keyword) {
        if (keyword == null) {
            PyCallExpression.$$$reportNull$$$0(7);
        }
        for (PyExpression arg : this.getArguments()) {
            PyKeywordArgument keywordArg;
            if (!(arg instanceof PyKeywordArgument) || !keyword.equals((keywordArg = (PyKeywordArgument)arg).getKeyword())) continue;
            return keywordArg.getValueExpression();
        }
        return null;
    }

    @Deprecated
    default public void addArgument(@NotNull PyExpression expression) {
        PyArgumentList argumentList;
        if (expression == null) {
            PyCallExpression.$$$reportNull$$$0(8);
        }
        if ((argumentList = this.getArgumentList()) != null) {
            argumentList.addArgument(expression);
        }
    }

    @Deprecated
    @Nullable
    default public PyCallable resolveCalleeFunction(@NotNull PyResolveContext resolveContext) {
        PyMarkedCallee first;
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(9);
        }
        return (first = (PyMarkedCallee)ContainerUtil.getFirstItem(this.multiResolveCallee(resolveContext, 0))) == null ? null : first.getElement();
    }

    @Deprecated
    @Nullable
    default public PyMarkedCallee resolveCallee(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(10);
        }
        return (PyMarkedCallee)ContainerUtil.getFirstItem(this.multiResolveCallee(resolveContext, 0));
    }

    @Deprecated
    @Nullable
    default public PyMarkedCallee resolveCallee(@NotNull PyResolveContext resolveContext, int implicitOffset) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(11);
        }
        return (PyMarkedCallee)ContainerUtil.getFirstItem(this.multiResolveCallee(resolveContext, implicitOffset));
    }

    @NotNull
    default public List<PyCallable> multiResolveCalleeFunction(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(12);
        }
        List list2 = ContainerUtil.mapNotNull(this.multiResolveCallee(resolveContext, 0), PyMarkedCallee::getElement);
        if (list2 == null) {
            PyCallExpression.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    default public List<PyMarkedCallee> multiResolveCallee(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(14);
        }
        List<PyMarkedCallee> list2 = this.multiResolveCallee(resolveContext, 0);
        if (list2 == null) {
            PyCallExpression.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    public List<PyMarkedCallee> multiResolveCallee(@NotNull PyResolveContext var1, int var2);

    @Deprecated
    @NotNull
    default public List<PyRatedCallee> multiResolveRatedCalleeFunction(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(16);
        }
        List list2 = ContainerUtil.map(this.multiResolveCallee(resolveContext, 0), markedCallee -> new PyRatedCallee(markedCallee.getCallableType(), markedCallee.getElement(), markedCallee.getRate()));
        if (list2 == null) {
            PyCallExpression.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    default public List<PyRatedMarkedCallee> multiResolveRatedCallee(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(18);
        }
        List<PyRatedMarkedCallee> list2 = this.multiResolveRatedCallee(resolveContext, 0);
        if (list2 == null) {
            PyCallExpression.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    default public List<PyRatedMarkedCallee> multiResolveRatedCallee(@NotNull PyResolveContext resolveContext, int implicitOffset) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(20);
        }
        List list2 = ContainerUtil.map(this.multiResolveCallee(resolveContext, implicitOffset), markedCallee -> new PyRatedMarkedCallee((PyMarkedCallee)markedCallee, markedCallee.getRate()));
        if (list2 == null) {
            PyCallExpression.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    default public PyArgumentsMapping mapArguments(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(22);
        }
        PyArgumentsMapping pyArgumentsMapping = Optional.of(this.multiMapArguments(resolveContext, 0)).map(ContainerUtil::getFirstItem).orElseGet(() -> PyArgumentsMapping.empty(this));
        if (pyArgumentsMapping == null) {
            PyCallExpression.$$$reportNull$$$0(23);
        }
        return pyArgumentsMapping;
    }

    @Deprecated
    @NotNull
    default public PyArgumentsMapping mapArguments(@NotNull PyResolveContext resolveContext, int implicitOffset) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(24);
        }
        PyArgumentsMapping pyArgumentsMapping = Optional.of(this.multiMapArguments(resolveContext, implicitOffset)).map(ContainerUtil::getFirstItem).orElseGet(() -> PyArgumentsMapping.empty(this));
        if (pyArgumentsMapping == null) {
            PyCallExpression.$$$reportNull$$$0(25);
        }
        return pyArgumentsMapping;
    }

    @NotNull
    default public List<PyArgumentsMapping> multiMapArguments(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpression.$$$reportNull$$$0(26);
        }
        List<PyArgumentsMapping> list2 = this.multiMapArguments(resolveContext, 0);
        if (list2 == null) {
            PyCallExpression.$$$reportNull$$$0(27);
        }
        return list2;
    }

    @NotNull
    public List<PyArgumentsMapping> multiMapArguments(@NotNull PyResolveContext var1, int var2);

    default public boolean isCalleeText(String ... nameCandidates) {
        PyExpression callee;
        if (nameCandidates == null) {
            PyCallExpression.$$$reportNull$$$0(28);
        }
        return (callee = this.getCallee()) instanceof PyReferenceExpression && ContainerUtil.exists((Object[])nameCandidates, name -> name.equals(((PyReferenceExpression)callee).getReferencedName()));
    }

    default public boolean isCallee(FQNamesProvider ... name) {
        PyExpression callee;
        if (name == null) {
            PyCallExpression.$$$reportNull$$$0(29);
        }
        return (callee = this.getCallee()) != null && NameResolverTools.isName(callee, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyCallExpression";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argClass";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCandidates";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyCallExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCalleeFunction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCallee";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveRatedCalleeFunction";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveRatedCallee";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "mapArguments";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "multiMapArguments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArgument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordArgument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addArgument";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveCalleeFunction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallee";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCalleeFunction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCallee";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveRatedCalleeFunction";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveRatedCallee";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "mapArguments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "multiMapArguments";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isCalleeText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCallee";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static class PyRatedMarkedCallee
    extends RatedResolveResult {
        @NotNull
        private final PyMarkedCallee myMarkedCallee;

        public PyRatedMarkedCallee(@NotNull PyMarkedCallee markedCallee, int rate) {
            if (markedCallee == null) {
                PyRatedMarkedCallee.$$$reportNull$$$0(0);
            }
            super(rate, (PsiElement)markedCallee.getElement());
            this.myMarkedCallee = markedCallee;
        }

        @NotNull
        public PyMarkedCallee getMarkedCallee() {
            PyMarkedCallee pyMarkedCallee = this.myMarkedCallee;
            if (pyMarkedCallee == null) {
                PyRatedMarkedCallee.$$$reportNull$$$0(1);
            }
            return pyMarkedCallee;
        }

        @Nullable
        public PyCallable getElement() {
            return (PyCallable)super.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markedCallee";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyCallExpression$PyRatedMarkedCallee";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyCallExpression$PyRatedMarkedCallee";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMarkedCallee";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Deprecated
    public static class PyRatedCallee
    extends RatedResolveResult {
        @NotNull
        private final PyCallableType myCallableType;

        public PyRatedCallee(@NotNull PyCallableType callableType, @Nullable PyCallable callable, int rate) {
            if (callableType == null) {
                PyRatedCallee.$$$reportNull$$$0(0);
            }
            super(rate, (PsiElement)callable);
            this.myCallableType = callableType;
        }

        @NotNull
        public PyCallableType getCallableType() {
            PyCallableType pyCallableType = this.myCallableType;
            if (pyCallableType == null) {
                PyRatedCallee.$$$reportNull$$$0(1);
            }
            return pyCallableType;
        }

        @Nullable
        public PyCallable getElement() {
            return (PyCallable)super.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyCallExpression$PyRatedCallee";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyCallExpression$PyRatedCallee";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallableType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PyMarkedCallee
    extends RatedResolveResult {
        @NotNull
        private final PyCallableType myCallableType;
        @Nullable
        private final PyFunction.Modifier myModifier;
        private final int myImplicitOffset;
        private final boolean myImplicitlyResolved;

        public PyMarkedCallee(@NotNull PyCallableType callableType, @Nullable PyCallable function, @Nullable PyFunction.Modifier modifier, int offset, boolean implicitlyResolved, int rate) {
            if (callableType == null) {
                PyMarkedCallee.$$$reportNull$$$0(0);
            }
            super(rate, (PsiElement)function);
            this.myCallableType = callableType;
            this.myModifier = modifier;
            this.myImplicitOffset = offset;
            this.myImplicitlyResolved = implicitlyResolved;
        }

        @NotNull
        public PyCallableType getCallableType() {
            PyCallableType pyCallableType = this.myCallableType;
            if (pyCallableType == null) {
                PyMarkedCallee.$$$reportNull$$$0(1);
            }
            return pyCallableType;
        }

        @Deprecated
        @Nullable
        public PyCallable getCallable() {
            return this.getElement();
        }

        @Nullable
        public PyCallable getElement() {
            return (PyCallable)super.getElement();
        }

        @Nullable
        public PyFunction.Modifier getModifier() {
            return this.myModifier;
        }

        public int getImplicitOffset() {
            return this.myImplicitOffset;
        }

        public boolean isImplicitlyResolved() {
            return this.myImplicitlyResolved;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyCallExpression$PyMarkedCallee";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyCallExpression$PyMarkedCallee";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallableType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PyArgumentsMapping {
        @NotNull
        private final PyCallSiteExpression myCallSiteExpression;
        @Nullable
        private final PyMarkedCallee myMarkedCallee;
        @NotNull
        private final List<PyCallableParameter> myImplicitParameters;
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myMappedParameters;
        @NotNull
        private final List<PyCallableParameter> myUnmappedParameters;
        @NotNull
        private final List<PyExpression> myUnmappedArguments;
        @NotNull
        private final List<PyCallableParameter> myParametersMappedToVariadicPositionalArguments;
        @NotNull
        private final List<PyCallableParameter> myParametersMappedToVariadicKeywordArguments;
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myMappedTupleParameters;

        public PyArgumentsMapping(@NotNull PyCallSiteExpression callSiteExpression, @Nullable PyMarkedCallee markedCallee, @NotNull List<PyCallableParameter> implicitParameters, @NotNull Map<PyExpression, PyCallableParameter> mappedParameters, @NotNull List<PyCallableParameter> unmappedParameters, @NotNull List<PyExpression> unmappedArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicPositionalArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicKeywordArguments, @NotNull Map<PyExpression, PyCallableParameter> tupleMappedParameters) {
            if (callSiteExpression == null) {
                PyArgumentsMapping.$$$reportNull$$$0(0);
            }
            if (implicitParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(1);
            }
            if (mappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(2);
            }
            if (unmappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(3);
            }
            if (unmappedArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(4);
            }
            if (parametersMappedToVariadicPositionalArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(5);
            }
            if (parametersMappedToVariadicKeywordArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(6);
            }
            if (tupleMappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(7);
            }
            this.myCallSiteExpression = callSiteExpression;
            this.myMarkedCallee = markedCallee;
            this.myImplicitParameters = implicitParameters;
            this.myMappedParameters = mappedParameters;
            this.myUnmappedParameters = unmappedParameters;
            this.myUnmappedArguments = unmappedArguments;
            this.myParametersMappedToVariadicPositionalArguments = parametersMappedToVariadicPositionalArguments;
            this.myParametersMappedToVariadicKeywordArguments = parametersMappedToVariadicKeywordArguments;
            this.myMappedTupleParameters = tupleMappedParameters;
        }

        @Deprecated
        public PyArgumentsMapping(@NotNull PyCallSiteExpression callSiteExpression, @Nullable PyMarkedCallee markedCallee, @NotNull Map<PyExpression, PyCallableParameter> mappedParameters, @NotNull List<PyCallableParameter> unmappedParameters, @NotNull List<PyExpression> unmappedArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicPositionalArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicKeywordArguments, @NotNull Map<PyExpression, PyCallableParameter> tupleMappedParameters) {
            if (callSiteExpression == null) {
                PyArgumentsMapping.$$$reportNull$$$0(8);
            }
            if (mappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(9);
            }
            if (unmappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(10);
            }
            if (unmappedArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(11);
            }
            if (parametersMappedToVariadicPositionalArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(12);
            }
            if (parametersMappedToVariadicKeywordArguments == null) {
                PyArgumentsMapping.$$$reportNull$$$0(13);
            }
            if (tupleMappedParameters == null) {
                PyArgumentsMapping.$$$reportNull$$$0(14);
            }
            this(callSiteExpression, markedCallee, Collections.emptyList(), mappedParameters, unmappedParameters, unmappedArguments, parametersMappedToVariadicPositionalArguments, parametersMappedToVariadicKeywordArguments, tupleMappedParameters);
        }

        @NotNull
        public static PyArgumentsMapping empty(@NotNull PyCallSiteExpression callSiteExpression) {
            if (callSiteExpression == null) {
                PyArgumentsMapping.$$$reportNull$$$0(15);
            }
            PyArgumentsMapping pyArgumentsMapping = new PyArgumentsMapping(callSiteExpression, null, Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
            if (pyArgumentsMapping == null) {
                PyArgumentsMapping.$$$reportNull$$$0(16);
            }
            return pyArgumentsMapping;
        }

        @NotNull
        public PyCallSiteExpression getCallSiteExpression() {
            PyCallSiteExpression pyCallSiteExpression = this.myCallSiteExpression;
            if (pyCallSiteExpression == null) {
                PyArgumentsMapping.$$$reportNull$$$0(17);
            }
            return pyCallSiteExpression;
        }

        @Nullable
        public PyMarkedCallee getMarkedCallee() {
            return this.myMarkedCallee;
        }

        @NotNull
        public List<PyCallableParameter> getImplicitParameters() {
            List<PyCallableParameter> list2 = this.myImplicitParameters;
            if (list2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(18);
            }
            return list2;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getMappedParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myMappedParameters;
            if (map2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(19);
            }
            return map2;
        }

        @NotNull
        public List<PyCallableParameter> getUnmappedParameters() {
            List<PyCallableParameter> list2 = this.myUnmappedParameters;
            if (list2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(20);
            }
            return list2;
        }

        @NotNull
        public List<PyExpression> getUnmappedArguments() {
            List<PyExpression> list2 = this.myUnmappedArguments;
            if (list2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(21);
            }
            return list2;
        }

        @NotNull
        public List<PyCallableParameter> getParametersMappedToVariadicPositionalArguments() {
            List<PyCallableParameter> list2 = this.myParametersMappedToVariadicPositionalArguments;
            if (list2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(22);
            }
            return list2;
        }

        @NotNull
        public List<PyCallableParameter> getParametersMappedToVariadicKeywordArguments() {
            List<PyCallableParameter> list2 = this.myParametersMappedToVariadicKeywordArguments;
            if (list2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(23);
            }
            return list2;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getMappedTupleParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myMappedTupleParameters;
            if (map2 == null) {
                PyArgumentsMapping.$$$reportNull$$$0(24);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callSiteExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implicitParameters";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedParameters";
                    break;
                }
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedParameters";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedArguments";
                    break;
                }
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersMappedToVariadicPositionalArguments";
                    break;
                }
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersMappedToVariadicKeywordArguments";
                    break;
                }
                case 7: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tupleMappedParameters";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyCallExpression$PyArgumentsMapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyCallExpression$PyArgumentsMapping";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallSiteExpression";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImplicitParameters";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedParameters";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedParameters";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedArguments";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersMappedToVariadicPositionalArguments";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersMappedToVariadicKeywordArguments";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedTupleParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "empty";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

