/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PointInImport;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyModuleMembersProvider;
import com.jetbrains.python.psi.types.PyOverridingModuleMembersProvider;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyModuleType
implements PyType {
    @NotNull
    private final PyFile myModule;
    @Nullable
    private final PyImportedModule myImportedModule;
    public static final ImmutableSet<String> MODULE_MEMBERS = ImmutableSet.of((Object)"__name__", (Object)"__file__", (Object)"__path__", (Object)"__doc__", (Object)"__dict__", (Object)"__package__", (Object[])new String[0]);

    public PyModuleType(@NotNull PyFile source) {
        if (source == null) {
            PyModuleType.$$$reportNull$$$0(0);
        }
        this(source, null);
    }

    public PyModuleType(@NotNull PyFile source, @Nullable PyImportedModule importedModule) {
        if (source == null) {
            PyModuleType.$$$reportNull$$$0(1);
        }
        this.myModule = source;
        this.myImportedModule = importedModule;
    }

    @NotNull
    public PyFile getModule() {
        PyFile pyFile = this.myModule;
        if (pyFile == null) {
            PyModuleType.$$$reportNull$$$0(2);
        }
        return pyFile;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PsiElement member;
        PsiElement overridingMember;
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(3);
        }
        if (direction == null) {
            PyModuleType.$$$reportNull$$$0(4);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(5);
        }
        if ((overridingMember = PyModuleType.resolveByOverridingMembersProviders(this.myModule, name, resolveContext)) != null) {
            return ResolveResultList.to(overridingMember);
        }
        List<RatedResolveResult> attributes = this.myModule.multiResolveName(name);
        if (!attributes.isEmpty()) {
            return attributes;
        }
        if (PyUtil.isPackage(this.myModule)) {
            ArrayList<PyImportElement> importElements = new ArrayList<PyImportElement>();
            if (!(this.myImportedModule == null || location != null && PyUtil.inSameFile((PsiElement)location, (PsiElement)this.myImportedModule))) {
                PyImportElement importElement = this.myImportedModule.getImportElement();
                if (importElement != null) {
                    importElements.add(importElement);
                }
            } else if (location != null) {
                ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)location);
                if (owner != null) {
                    importElements.addAll(PyModuleType.getVisibleImports(owner));
                }
                if (!PyUtil.inSameFile((PsiElement)location, (PsiElement)this.myModule)) {
                    importElements.addAll(this.myModule.getImportTargets());
                }
                List<PyFromImportStatement> imports = this.myModule.getFromImports();
                for (PyFromImportStatement anImport : imports) {
                    Collections.addAll(importElements, anImport.getImportElements());
                }
            }
            List<? extends RatedResolveResult> implicitMembers = this.resolveImplicitPackageMember(name, importElements);
            if (implicitMembers != null) {
                return implicitMembers;
            }
        }
        if ((member = PyModuleType.resolveByMembersProviders(this.myModule, name, resolveContext)) != null) {
            return ResolveResultList.to(member);
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByMembersProviders(PyFile module2, String name, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(6);
        }
        for (PyModuleMembersProvider provider : (PyModuleMembersProvider[])Extensions.getExtensions(PyModuleMembersProvider.EP_NAME)) {
            PsiElement element;
            if (provider instanceof PyOverridingModuleMembersProvider || (element = provider.resolveMember(module2, name, resolveContext)) == null) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingMembersProviders(@NotNull PyFile module2, @NotNull String name, @NotNull PyResolveContext resolveContext) {
        if (module2 == null) {
            PyModuleType.$$$reportNull$$$0(7);
        }
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(8);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(9);
        }
        for (PyModuleMembersProvider provider : (PyModuleMembersProvider[])Extensions.getExtensions(PyModuleMembersProvider.EP_NAME)) {
            PsiElement element;
            if (!(provider instanceof PyOverridingModuleMembersProvider) || (element = provider.resolveMember(module2, name, resolveContext)) == null) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private List<? extends RatedResolveResult> resolveImplicitPackageMember(@NotNull String name, @NotNull List<PyImportElement> importElements) {
        VirtualFile moduleFile;
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(10);
        }
        if (importElements == null) {
            PyModuleType.$$$reportNull$$$0(11);
        }
        if ((moduleFile = this.myModule.getVirtualFile()) != null) {
            for (QualifiedName packageQName : QualifiedNameFinder.findImportableQNames((PsiElement)this.myModule, this.myModule.getVirtualFile())) {
                QualifiedName resolvingQName = packageQName.append(name);
                for (PyImportElement importElement : importElements) {
                    for (QualifiedName qName : PyModuleType.getImportedQNames(importElement)) {
                        PsiElement subModule;
                        if (!qName.matchesPrefix(resolvingQName) || (subModule = ResolveImportUtil.resolveChild((PsiElement)this.myModule, name, this.myModule, false, true, false)) == null) continue;
                        ResolveResultList results = new ResolveResultList();
                        results.add(new ImportedResolveResult(subModule, 0, importElement));
                        return results;
                    }
                }
            }
        }
        return null;
    }

    @NotNull
    private static List<QualifiedName> getImportedQNames(@NotNull PyImportElement element) {
        QualifiedName importedQName;
        if (element == null) {
            PyModuleType.$$$reportNull$$$0(12);
        }
        ArrayList<QualifiedName> importedQNames = new ArrayList<QualifiedName>();
        PyStatement stmt = element.getContainingImportStatement();
        if (stmt instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)stmt;
            QualifiedName importedQName2 = fromImportStatement.getImportSourceQName();
            String visibleName = element.getVisibleName();
            if (importedQName2 != null) {
                importedQNames.add(importedQName2);
                QualifiedName implicitSubModuleQName = importedQName2.append(visibleName);
                if (implicitSubModuleQName != null) {
                    importedQNames.add(implicitSubModuleQName);
                }
            } else {
                List<PsiElement> elements = ResolveImportUtil.resolveFromImportStatementSource(fromImportStatement, element.getImportedQName());
                for (PsiElement psiElement : elements) {
                    VirtualFile virtualFile;
                    QualifiedName qName;
                    if (!(psiElement instanceof PsiFile) || (qName = QualifiedNameFinder.findShortestImportableQName((PsiElement)element, virtualFile = ((PsiFile)psiElement).getVirtualFile())) == null) continue;
                    importedQNames.add(qName);
                }
            }
        } else if (stmt instanceof PyImportStatement && (importedQName = element.getImportedQName()) != null) {
            importedQNames.add(importedQName);
        }
        if (!ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)element)) {
            PsiFile file2 = element.getContainingFile();
            if (file2 != null) {
                file2 = file2.getOriginalFile();
            }
            QualifiedName absoluteQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file2);
            if (file2 != null && absoluteQName != null) {
                QualifiedName prefixQName;
                QualifiedName qualifiedName = prefixQName = PyUtil.isPackage(file2) ? absoluteQName : absoluteQName.removeLastComponent();
                if (prefixQName.getComponentCount() > 0) {
                    ArrayList<QualifiedName> results = new ArrayList<QualifiedName>(importedQNames);
                    for (QualifiedName qName : importedQNames) {
                        ArrayList components = new ArrayList();
                        components.addAll(prefixQName.getComponents());
                        components.addAll(qName.getComponents());
                        results.add(QualifiedName.fromComponents(components));
                    }
                    ArrayList<QualifiedName> arrayList = results;
                    if (arrayList == null) {
                        PyModuleType.$$$reportNull$$$0(13);
                    }
                    return arrayList;
                }
            }
        }
        ArrayList<QualifiedName> arrayList = importedQNames;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static List<PyImportElement> getVisibleImports(@NotNull ScopeOwner owner) {
        if (owner == null) {
            PyModuleType.$$$reportNull$$$0(15);
        }
        final ArrayList<PyImportElement> visibleImports = new ArrayList<PyImportElement>();
        PyResolveUtil.scopeCrawlUp(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof PyImportElement) {
                    visibleImports.add((PyImportElement)element);
                }
                return true;
            }

            @Nullable
            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    1.$$$reportNull$$$0(2);
                }
                return null;
            }

            public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "hintKey";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/psi/types/PyModuleType$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getHint";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleEvent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, owner, null, null);
        ArrayList<PyImportElement> arrayList = visibleImports;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiFileSystemItem> getSubmodulesList(@Nullable PsiDirectory directory2, @Nullable PsiElement anchor) {
        ArrayList<PsiFileSystemItem> result2 = new ArrayList<PsiFileSystemItem>();
        if (directory2 != null) {
            for (PsiFile psiFile : directory2.getFiles()) {
                String filename = psiFile.getName();
                if ((PyModuleType.isExcluded((PsiFileSystemItem)psiFile) || !(psiFile instanceof PyFile) || filename.equals("__init__.py")) && !PyModuleType.isBinaryModule(filename)) continue;
                result2.add((PsiFileSystemItem)psiFile);
            }
            for (PsiFile psiFile : directory2.getSubdirectories()) {
                if (PyModuleType.isExcluded((PsiFileSystemItem)psiFile) || !PyUtil.isPackage((PsiDirectory)psiFile, anchor)) continue;
                result2.add((PsiFileSystemItem)psiFile);
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = result2;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static boolean isExcluded(@NotNull PsiFileSystemItem file2) {
        if (file2 == null) {
            PyModuleType.$$$reportNull$$$0(18);
        }
        return FileIndexFacade.getInstance((Project)file2.getProject()).isExcludedFile(file2.getVirtualFile());
    }

    private static boolean isBinaryModule(String filename) {
        String ext = FileUtilRt.getExtension((String)filename);
        if (SystemInfo.isWindows) {
            return "pyd".equalsIgnoreCase(ext);
        }
        return "so".equals(ext);
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(location.getProject(), location.getContainingFile());
        List<LookupElement> result2 = this.getCompletionVariantsAsLookupElements(location, context, false, false, typeEvalContext);
        return result2.toArray();
    }

    @NotNull
    public List<LookupElement> getCompletionVariantsAsLookupElements(@NotNull PsiElement location, @NotNull ProcessingContext context, boolean wantAllSubmodules, boolean suppressParentheses, @NotNull TypeEvalContext typeEvalContext) {
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyModuleType.$$$reportNull$$$0(20);
        }
        if (typeEvalContext == null) {
            PyModuleType.$$$reportNull$$$0(21);
        }
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        Set namesAlready = (Set)context.get(CTX_NAMES);
        PointInImport point = ResolveImportUtil.getPointInImport(location);
        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(typeEvalContext);
        for (PyModuleMembersProvider provider : (PyModuleMembersProvider[])Extensions.getExtensions(PyModuleMembersProvider.EP_NAME)) {
            for (PyCustomMember member : provider.getMembers(this.myModule, point, typeEvalContext)) {
                String name = member.getName();
                if (namesAlready != null) {
                    namesAlready.add(name);
                }
                if (PyUtil.isClassPrivateName(name)) continue;
                CompletionVariantsProcessor processor2 = PyModuleType.createCompletionVariantsProcessor(location, suppressParentheses, point);
                PsiElement resolved = member.resolve(location, resolveContext);
                if (resolved != null) {
                    LookupElement element;
                    processor2.execute(resolved, ResolveState.initial());
                    List<LookupElement> lookupList = processor2.getResultList();
                    if (!lookupList.isEmpty() && name.equals((element = lookupList.get(0)).getLookupString())) {
                        result2.add(element);
                        continue;
                    }
                }
                result2.add((LookupElement)LookupElementBuilder.create((String)name).withIcon(member.getIcon()).withTypeText(member.getShortType()));
            }
        }
        if (point == PointInImport.NONE || point == PointInImport.AS_NAME) {
            CompletionVariantsProcessor processor3 = PyModuleType.createCompletionVariantsProcessor(location, suppressParentheses, point);
            this.myModule.processDeclarations(processor3, ResolveState.initial(), null, location);
            if (namesAlready != null) {
                for (LookupElement le : processor3.getResultList()) {
                    String name = le.getLookupString();
                    if (namesAlready.contains(name)) continue;
                    result2.add(le);
                    namesAlready.add(name);
                }
            } else {
                result2.addAll(processor3.getResultList());
            }
        }
        if (PyUtil.isPackage(this.myModule)) {
            if (point == PointInImport.AS_MODULE || point == PointInImport.AS_NAME || wantAllSubmodules) {
                result2.addAll(PyModuleType.getSubModuleVariants(this.myModule.getContainingDirectory(), location, namesAlready));
            } else {
                result2.addAll(PyModuleType.collectImportedSubmodulesAsLookupElements((PsiFileSystemItem)this.myModule, location, namesAlready));
            }
        }
        ArrayList<LookupElement> arrayList = result2;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private static CompletionVariantsProcessor createCompletionVariantsProcessor(PsiElement location, boolean suppressParentheses, PointInImport point) {
        Condition nodeFilter = psiElement -> !(psiElement instanceof PyImportElement) || PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyImportStatementBase.class) instanceof PyFromImportStatement;
        CompletionVariantsProcessor completionVariantsProcessor = new CompletionVariantsProcessor(location, (Condition<PsiElement>)nodeFilter, null, point == PointInImport.AS_NAME, suppressParentheses);
        if (completionVariantsProcessor == null) {
            PyModuleType.$$$reportNull$$$0(23);
        }
        return completionVariantsProcessor;
    }

    @NotNull
    public static List<LookupElement> collectImportedSubmodulesAsLookupElements(@NotNull PsiFileSystemItem pyPackage, @NotNull PsiElement location, @Nullable Set<String> existingNames) {
        List<PsiElement> elements;
        if (pyPackage == null) {
            PyModuleType.$$$reportNull$$$0(24);
        }
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(25);
        }
        List list2 = (elements = PyModuleType.collectImportedSubmodules(pyPackage, location)) != null ? ContainerUtil.mapNotNull(elements, element -> {
            if (element instanceof PsiFileSystemItem) {
                return PyModuleType.buildFileLookupElement((PsiFileSystemItem)element, existingNames);
            }
            if (element instanceof PsiNamedElement) {
                return LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)element));
            }
            return null;
        }) : Collections.emptyList();
        if (list2 == null) {
            PyModuleType.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @Nullable
    public static List<PsiElement> collectImportedSubmodules(@NotNull PsiFileSystemItem pyPackage, @NotNull PsiElement location) {
        PsiDirectory parentAnchor;
        if (pyPackage == null) {
            PyModuleType.$$$reportNull$$$0(27);
        }
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(28);
        }
        if (pyPackage instanceof PyFile && PyUtil.isPackage((PyFile)pyPackage)) {
            parentAnchor = ((PyFile)pyPackage).getContainingDirectory();
        } else if (pyPackage instanceof PsiDirectory && PyUtil.isPackage((PsiDirectory)pyPackage, location)) {
            parentAnchor = pyPackage;
        } else {
            return null;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(location);
        if (scopeOwner == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        block0: for (PyImportElement importElement : PyModuleType.getVisibleImports(scopeOwner)) {
            PsiElement resolvedChild = PyUtil.turnInitIntoDir(importElement.resolve());
            if (resolvedChild == null || !PsiTreeUtil.isAncestor((PsiElement)parentAnchor, (PsiElement)resolvedChild, (boolean)true)) continue;
            QualifiedName importedQName = importElement.getImportedQName();
            while (resolvedChild != null && resolvedChild.getParent() != parentAnchor) {
                if (importedQName == null || importedQName.getComponentCount() <= 1) continue block0;
                importedQName = importedQName.removeTail(1);
                resolvedChild = PyUtil.turnInitIntoDir(ResolveImportUtil.resolveImportElement(importElement, importedQName));
            }
            ContainerUtil.addIfNotNull(result2, (Object)resolvedChild);
        }
        return result2;
    }

    @NotNull
    public static List<LookupElement> getSubModuleVariants(@Nullable PsiDirectory directory2, @NotNull PsiElement location, @Nullable Set<String> namesAlready) {
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(29);
        }
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        for (PsiFileSystemItem item : PyModuleType.getSubmodulesList(directory2, location)) {
            LookupElementBuilder lookupElement;
            if (item == location.getContainingFile().getOriginalFile() || (lookupElement = PyModuleType.buildFileLookupElement(item, namesAlready)) == null) continue;
            result2.add((LookupElement)lookupElement);
        }
        ArrayList<LookupElement> arrayList = result2;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Nullable
    public static LookupElementBuilder buildFileLookupElement(PsiFileSystemItem item, @Nullable Set<String> existingNames) {
        String s = FileUtil.getNameWithoutExtension((String)item.getName());
        if (!PyNames.isIdentifier(s)) {
            return null;
        }
        if (existingNames != null) {
            if (existingNames.contains(s)) {
                return null;
            }
            existingNames.add(s);
        }
        return LookupElementBuilder.create((Object)item, (String)s).withTypeText(PyModuleType.getPresentablePath((PsiDirectory)item.getParent())).withPresentableText(s).withIcon(item.getIcon(0));
    }

    private static String getPresentablePath(PsiDirectory directory2) {
        if (directory2 == null) {
            return "";
        }
        String path = directory2.getVirtualFile().getPath();
        if (path.contains("python_stubs")) {
            return "<built-in>";
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @Override
    public String getName() {
        return this.myModule.getName();
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Override
    public void assertValid(String message) {
        if (!this.myModule.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this.myModule, this.myModule.getClass().toString() + ": " + message);
        }
    }

    @NotNull
    public static Set<String> getPossibleInstanceMembers() {
        ImmutableSet<String> immutableSet = MODULE_MEMBERS;
        if (immutableSet == null) {
            PyModuleType.$$$reportNull$$$0(31);
        }
        return immutableSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyModuleType";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importElements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyModuleType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedQNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleImports";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubmodulesList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariantsAsLookupElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionVariantsProcessor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImportedSubmodulesAsLookupElements";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubModuleVariants";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleInstanceMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveByMembersProviders";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingMembersProviders";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveImplicitPackageMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getImportedQNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleImports";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariantsAsLookupElements";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectImportedSubmodulesAsLookupElements";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectImportedSubmodules";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSubModuleVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

