/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddExistingVirtualEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "sdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getOrCreateSdk", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "python-community"})
public final class PyAddExistingVirtualEnvPanel
extends PyAddSdkPanel {
    @NotNull
    private final String panelName = "Existing environment";
    @NotNull
    private final Icon icon;
    private final PySdkPathChoosingComboBox sdkComboBox;
    private final JBCheckBox makeSharedField;
    private final Project project;
    private final List<Sdk> existingSdks;
    @Nullable
    private String newProjectPath;

    @Override
    @NotNull
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object)PyAddSdkPanel.Companion.validateSdkComboBox(this.sdkComboBox)));
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk;
        Sdk sdk2 = this.sdkComboBox.getSelectedSdk();
        Sdk sdk3 = sdk2;
        if (sdk3 instanceof PyDetectedSdk) {
            PyDetectedSdk pyDetectedSdk = (PyDetectedSdk)sdk2;
            String string = this.getNewProjectPath();
            if (string == null) {
                Project project = this.project;
                string = project != null ? project.getBasePath() : null;
            }
            Sdk sdk4 = PySdkExtKt.setupAssociated(pyDetectedSdk, this.existingSdks, string);
            if (sdk4 != null) {
                Sdk sdk5;
                Sdk $receiver = sdk5 = sdk4;
                if (!this.makeSharedField.isSelected()) {
                    PySdkExtKt.associateWithProject($receiver, this.project, this.getNewProjectPath() != null);
                }
                sdk = sdk5;
            } else {
                sdk = null;
            }
        } else {
            sdk = sdk2;
        }
        return sdk;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    /*
     * WARNING - void declaration
     */
    public PyAddExistingVirtualEnvPanel(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath) {
        void $receiver$iv$iv;
        void $receiver$iv;
        PySdkPathChoosingComboBox pySdkPathChoosingComboBox;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        this.project = project;
        this.existingSdks = existingSdks;
        this.newProjectPath = newProjectPath;
        this.panelName = "Existing environment";
        Icon icon = PythonIcons.Python.Virtualenv;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Virtualenv");
        this.icon = icon;
        Iterable iterable = PySdkExtKt.detectVirtualEnvs(this.project, this.existingSdks);
        PySdkPathChoosingComboBox pySdkPathChoosingComboBox2 = pySdkPathChoosingComboBox;
        PySdkPathChoosingComboBox pySdkPathChoosingComboBox3 = pySdkPathChoosingComboBox;
        PyAddExistingVirtualEnvPanel pyAddExistingVirtualEnvPanel = this;
        void var5_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv$iv);
            if (PySdkExtKt.isAssociatedWithAnotherProject(it, this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        pySdkPathChoosingComboBox2(list2, null);
        pyAddExistingVirtualEnvPanel.sdkComboBox = pySdkPathChoosingComboBox3;
        this.makeSharedField = new JBCheckBox("Make available to all projects");
        this.setLayout(new BorderLayout());
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent("Interpreter:", (JComponent)((Object)this.sdkComboBox)).addComponent((JComponent)this.makeSharedField).getPanel();
        this.add((Component)formPanel, "North");
    }
}

