/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletons;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletonsProvider;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.SkeletonVersionChecker;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySkeletonRefresher {
    private static final Logger LOG = Logger.getInstance(PySkeletonRefresher.class);
    @Nullable
    private Project myProject;
    @Nullable
    private final ProgressIndicator myIndicator;
    @NotNull
    private final Sdk mySdk;
    private String mySkeletonsPath;
    @NonNls
    public static final String BLACKLIST_FILE_NAME = ".blacklist";
    private static final Pattern BLACKLIST_LINE = Pattern.compile("^([^=]+) = (\\d+\\.\\d+) (\\d+)\\s*$");
    private static final Pattern VERSION_LINE_V1 = Pattern.compile("# from (\\S+) by generator (\\S+)\\s*");
    private static final Pattern FROM_LINE_V2 = Pattern.compile("# from (.*)$");
    private static final Pattern BY_LINE_V2 = Pattern.compile("# by generator (.*)$");
    private static int ourGeneratingCount = 0;
    private String myExtraSyspath;
    private PyPregeneratedSkeletons myPregeneratedSkeletons;
    private int myGeneratorVersion;
    private Map<String, Pair<Integer, Long>> myBlacklist;
    private SkeletonVersionChecker myVersionChecker;
    private PySkeletonGenerator mySkeletonsGenerator;

    public static synchronized boolean isGeneratingSkeletons() {
        return ourGeneratingCount > 0;
    }

    private static synchronized void changeGeneratingSkeletons(int increment) {
        ourGeneratingCount += increment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshSkeletonsOfSdk(@Nullable Project project, @Nullable Component ownerComponent, @Nullable String skeletonsPath, @NotNull Sdk sdk) throws InvalidSdkException {
        if (sdk == null) {
            PySkeletonRefresher.$$$reportNull$$$0(0);
        }
        TreeMap<String, List<String>> errors = new TreeMap<String, List<String>>();
        SmartList failedSdks = new SmartList();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        String homePath = sdk.getHomePath();
        if (skeletonsPath == null) {
            LOG.info("Could not find skeletons path for SDK path " + homePath);
        } else {
            LOG.info("Refreshing skeletons for " + homePath);
            SkeletonVersionChecker checker = new SkeletonVersionChecker(0);
            PySkeletonRefresher refresher = new PySkeletonRefresher(project, ownerComponent, sdk, skeletonsPath, indicator, null);
            PySkeletonRefresher.changeGeneratingSkeletons(1);
            try {
                List<String> sdkErrors = refresher.regenerateSkeletons(checker);
                if (sdkErrors.size() > 0) {
                    String sdkName = sdk.getName();
                    List knownErrors = (List)errors.get(sdkName);
                    if (knownErrors == null) {
                        errors.put(sdkName, sdkErrors);
                    } else {
                        knownErrors.addAll(sdkErrors);
                    }
                }
            }
            finally {
                PySkeletonRefresher.changeGeneratingSkeletons(-1);
            }
        }
        if (failedSdks.size() > 0 || errors.size() > 0) {
            int module_errors = 0;
            for (String sdk_name : errors.keySet()) {
                module_errors += ((List)errors.get(sdk_name)).size();
            }
            String message = failedSdks.size() > 0 ? PyBundle.message("sdk.errorlog.$0.mods.fail.in.$1.sdks.$2.completely", module_errors, errors.size(), failedSdks.size()) : PyBundle.message("sdk.errorlog.$0.mods.fail.in.$1.sdks", module_errors, errors.size());
            PySkeletonRefresher.logErrors(errors, (List<String>)failedSdks, message);
        }
    }

    private static void logErrors(@NotNull Map<String, List<String>> errors, @NotNull List<String> failedSdks, @NotNull String message) {
        if (errors == null) {
            PySkeletonRefresher.$$$reportNull$$$0(1);
        }
        if (failedSdks == null) {
            PySkeletonRefresher.$$$reportNull$$$0(2);
        }
        if (message == null) {
            PySkeletonRefresher.$$$reportNull$$$0(3);
        }
        LOG.warn(PyBundle.message("sdk.some.skeletons.failed", new Object[0]));
        LOG.warn(message);
        if (failedSdks.size() > 0) {
            LOG.warn(PyBundle.message("sdk.error.dialog.failed.sdks", new Object[0]));
            LOG.warn(StringUtil.join(failedSdks, (String)", "));
        }
        if (errors.size() > 0) {
            LOG.warn(PyBundle.message("sdk.error.dialog.failed.modules", new Object[0]));
            for (String sdkName : errors.keySet()) {
                for (String moduleName : errors.get(sdkName)) {
                    LOG.warn(moduleName);
                }
            }
        }
    }

    public PySkeletonRefresher(@Nullable Project project, @Nullable Component ownerComponent, @NotNull Sdk sdk, @Nullable String skeletonsPath, @Nullable ProgressIndicator indicator, @Nullable String folder) throws InvalidSdkException {
        if (sdk == null) {
            PySkeletonRefresher.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myIndicator = indicator;
        this.mySdk = sdk;
        this.mySkeletonsPath = skeletonsPath;
        PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (PySdkUtil.isRemote(sdk) && remoteInterpreterManager != null) {
            try {
                this.mySkeletonsGenerator = remoteInterpreterManager.createRemoteSkeletonGenerator(this.myProject, ownerComponent, sdk, this.getSkeletonsPath());
            }
            catch (ExecutionException e) {
                throw new InvalidSdkException(e.getMessage(), e.getCause());
            }
        } else {
            this.mySkeletonsGenerator = new PySkeletonGenerator(this.getSkeletonsPath(), this.mySdk, folder);
        }
    }

    private void indicate(String msg) {
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
            this.myIndicator.setText(msg);
            this.myIndicator.setText2("");
        }
    }

    private void indicateMinor(String msg) {
        if (this.myIndicator != null) {
            this.myIndicator.setText2(msg);
        }
    }

    private void checkCanceled() {
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
        }
    }

    private static String calculateExtraSysPath(@NotNull Sdk sdk, @Nullable String skeletonsPath) {
        if (sdk == null) {
            PySkeletonRefresher.$$$reportNull$$$0(5);
        }
        File skeletons = skeletonsPath != null ? new File(skeletonsPath) : null;
        VirtualFile userSkeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory();
        File userSkeletons = userSkeletonsDir != null ? new File(userSkeletonsDir.getPath()) : null;
        VirtualFile remoteSourcesDir = PySdkUtil.findAnyRemoteLibrary(sdk);
        File remoteSources = remoteSourcesDir != null ? new File(remoteSourcesDir.getPath()) : null;
        ArrayList<VirtualFile> paths = new ArrayList<VirtualFile>();
        paths.addAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
        paths.addAll(BuildoutFacet.getExtraPathForAllOpenModules());
        return Joiner.on((String)File.pathSeparator).join((Iterable)ContainerUtil.mapNotNull(paths, file2 -> {
            File canonicalFile;
            if (file2.isInLocalFileSystem() && (canonicalFile = new File(file2.getPath())).exists() && !FileUtil.filesEqual((File)canonicalFile, (File)skeletons) && !FileUtil.filesEqual((File)canonicalFile, (File)userSkeletons) && !FileUtil.filesEqual((File)canonicalFile, (File)remoteSources)) {
                return file2.getPath();
            }
            return null;
        }));
    }

    @NotNull
    public String getSkeletonsPath() throws InvalidSdkException {
        if (this.mySkeletonsPath == null) {
            this.mySkeletonsPath = PythonSdkType.getSkeletonsPath(PathManager.getSystemPath(), this.mySdk.getHomePath());
            File skeletonsDir = new File(this.mySkeletonsPath);
            if (!skeletonsDir.exists() && !skeletonsDir.mkdirs()) {
                throw new InvalidSdkException("Can't create skeleton dir " + String.valueOf(this.mySkeletonsPath));
            }
        }
        String string = this.mySkeletonsPath;
        if (string == null) {
            PySkeletonRefresher.$$$reportNull$$$0(6);
        }
        return string;
    }

    public List<String> regenerateSkeletons(@Nullable SkeletonVersionChecker checker) throws InvalidSdkException {
        boolean oldOrNonExisting;
        SmartList errorList = new SmartList();
        String homePath = this.mySdk.getHomePath();
        String skeletonsPath = this.getSkeletonsPath();
        File skeletonsDir = new File(skeletonsPath);
        if (!skeletonsDir.exists()) {
            skeletonsDir.mkdirs();
        }
        String readablePath = FileUtil.getLocationRelativeToUserHome((String)homePath);
        if (checker != null && checker.isPregenerated()) {
            this.mySkeletonsGenerator.setPrebuilt(true);
        }
        this.mySkeletonsGenerator.prepare();
        this.myBlacklist = this.loadBlacklist();
        this.indicate(PyBundle.message("sdk.gen.querying.$0", readablePath));
        String extraSysPath = PySkeletonRefresher.calculateExtraSysPath(this.mySdk, this.getSkeletonsPath());
        String[] split = extraSysPath.split(";");
        PySkeletonGenerator.ListBinariesResult binaries = null;
        for (List batch : Lists.partition(Arrays.asList(split), (int)50)) {
            if (binaries == null) {
                binaries = this.mySkeletonsGenerator.listBinaries(this.mySdk, Joiner.on((String)";").join((Iterable)batch));
                continue;
            }
            binaries.modules.putAll(this.mySkeletonsGenerator.listBinaries((Sdk)this.mySdk, (String)Joiner.on((String)";").join((Iterable)batch)).modules);
        }
        this.myGeneratorVersion = binaries != null ? binaries.generatorVersion : 0;
        this.myPregeneratedSkeletons = PyPregeneratedSkeletonsProvider.findPregeneratedSkeletonsForSdk(this.mySdk, this.myGeneratorVersion);
        this.indicate(PyBundle.message("sdk.gen.reading.versions.file", new Object[0]));
        this.myVersionChecker = checker != null ? checker.withDefaultVersionIfUnknown(this.myGeneratorVersion) : new SkeletonVersionChecker(this.myGeneratorVersion);
        String builtinsFileName = PythonSdkType.getBuiltinsFileName(this.mySdk);
        File builtinsFile = new File(skeletonsPath, builtinsFileName);
        SkeletonHeader oldHeader = PySkeletonRefresher.readSkeletonHeader(builtinsFile);
        boolean bl = oldOrNonExisting = oldHeader == null || oldHeader.getVersion() == 0;
        if (this.myPregeneratedSkeletons != null && oldOrNonExisting) {
            this.myPregeneratedSkeletons.unpackPreGeneratedSkeletons(this.getSkeletonsPath());
        }
        if (oldOrNonExisting) {
            this.copyBaseSdkSkeletonsToVirtualEnv(skeletonsPath, binaries);
        }
        boolean builtinsUpdated = this.updateSkeletonsForBuiltins(readablePath, builtinsFile);
        if (binaries != null && !binaries.modules.isEmpty()) {
            this.indicate(PyBundle.message("sdk.gen.updating.$0", readablePath));
            List<UpdateResult> updateErrors = this.updateOrCreateSkeletons(binaries.modules);
            if (updateErrors.size() > 0) {
                this.indicateMinor(BLACKLIST_FILE_NAME);
                for (UpdateResult error : updateErrors) {
                    if (error.isFresh()) {
                        errorList.add(error.getName());
                    }
                    this.myBlacklist.put(error.getPath(), (Pair<Integer, Long>)new Pair((Object)this.myGeneratorVersion, (Object)error.getTimestamp()));
                }
                PySkeletonRefresher.storeBlacklist(skeletonsDir, this.myBlacklist);
            } else {
                PySkeletonRefresher.removeBlacklist(skeletonsDir);
            }
        }
        this.indicate(PyBundle.message("sdk.gen.reloading", new Object[0]));
        this.mySkeletonsGenerator.refreshGeneratedSkeletons();
        if (!oldOrNonExisting) {
            this.indicate(PyBundle.message("sdk.gen.cleaning.$0", readablePath));
            this.cleanUpSkeletons(skeletonsDir);
        }
        if ((builtinsUpdated || PySdkUtil.isRemote(this.mySdk)) && this.myProject != null) {
            ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(), this.myProject.getDisposed());
        }
        return errorList;
    }

    private boolean updateSkeletonsForBuiltins(String readablePath, File builtinsFile) throws InvalidSdkException {
        boolean mustUpdateBuiltins;
        SkeletonHeader newHeader = PySkeletonRefresher.readSkeletonHeader(builtinsFile);
        boolean bl = mustUpdateBuiltins = this.myPregeneratedSkeletons == null && (newHeader == null || newHeader.getVersion() < this.myVersionChecker.getBuiltinVersion());
        if (mustUpdateBuiltins) {
            this.indicate(PyBundle.message("sdk.gen.updating.builtins.$0", readablePath));
            this.mySkeletonsGenerator.generateBuiltinSkeletons(this.mySdk);
            if (this.myProject != null) {
                PythonSdkPathCache.getInstance(this.myProject, this.mySdk).clearBuiltins();
            }
        }
        return mustUpdateBuiltins;
    }

    private void copyBaseSdkSkeletonsToVirtualEnv(String skeletonsPath, PySkeletonGenerator.ListBinariesResult binaries) throws InvalidSdkException {
        Sdk base = PythonSdkType.getInstance().getVirtualEnvBaseSdk(this.mySdk);
        if (base != null) {
            this.indicate("Copying base SDK skeletons for virtualenv...");
            String baseSkeletonsPath = PythonSdkType.getSkeletonsPath(PathManager.getSystemPath(), base.getHomePath());
            PySkeletonGenerator.ListBinariesResult baseBinaries = this.mySkeletonsGenerator.listBinaries(base, PySkeletonRefresher.calculateExtraSysPath(base, baseSkeletonsPath));
            for (Map.Entry<String, PyBinaryItem> entry : binaries.modules.entrySet()) {
                String module2 = entry.getKey();
                PyBinaryItem binary = entry.getValue();
                PyBinaryItem baseBinary = baseBinaries.modules.get(module2);
                File fromFile = PySkeletonRefresher.getSkeleton(module2, baseSkeletonsPath);
                if (!baseBinaries.modules.containsKey(module2) || !fromFile.exists() || binary.length() != baseBinary.length()) continue;
                File toFile = fromFile.isDirectory() ? PySkeletonRefresher.getPackageSkeleton(module2, skeletonsPath) : PySkeletonRefresher.getModuleSkeleton(module2, skeletonsPath);
                try {
                    FileUtil.copy((File)fromFile, (File)toFile);
                }
                catch (IOException e) {
                    LOG.info("Error copying base virtualenv SDK skeleton for " + module2, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static SkeletonHeader readSkeletonHeader(@NotNull File file2) {
        if (file2 == null) {
            PySkeletonRefresher.$$$reportNull$$$0(7);
        }
        try (LineNumberReader reader = new LineNumberReader(new FileReader(file2));){
            String line = null;
            for (int i = 0; i < 3; ++i) {
                line = reader.readLine();
                if (line != null) continue;
                SkeletonHeader skeletonHeader = null;
                return skeletonHeader;
            }
            Matcher v1Matcher = VERSION_LINE_V1.matcher(line);
            if (v1Matcher.matches()) {
                SkeletonHeader skeletonHeader = new SkeletonHeader(v1Matcher.group(1), SkeletonVersionChecker.fromVersionString(v1Matcher.group(2)));
                return skeletonHeader;
            }
            Matcher fromMatcher = FROM_LINE_V2.matcher(line);
            if (!fromMatcher.matches()) return null;
            String binaryFile = fromMatcher.group(1);
            line = reader.readLine();
            if (line == null) return null;
            Matcher byMatcher = BY_LINE_V2.matcher(line);
            if (!byMatcher.matches()) return null;
            int version = SkeletonVersionChecker.fromVersionString(byMatcher.group(1));
            SkeletonHeader skeletonHeader = new SkeletonHeader(binaryFile, version);
            return skeletonHeader;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Pair<Integer, Long>> loadBlacklist() {
        HashMap<String, Pair<Integer, Long>> ret = new HashMap<String, Pair<Integer, Long>>();
        File blacklistFile = new File(this.mySkeletonsPath, BLACKLIST_FILE_NAME);
        if (blacklistFile.exists() && blacklistFile.canRead()) {
            try {
                FileReader input = new FileReader(blacklistFile);
                try (LineNumberReader lines2 = new LineNumberReader(input);){
                    String line;
                    do {
                        int version;
                        if ((line = lines2.readLine()) == null || line.length() <= 0 || line.charAt(0) == '#') continue;
                        Matcher matcher = BLACKLIST_LINE.matcher(line);
                        boolean notParsed = true;
                        if (matcher.matches() && (version = SkeletonVersionChecker.fromVersionString(matcher.group(2))) > 0) {
                            try {
                                long timestamp = Long.parseLong(matcher.group(3));
                                String filename = matcher.group(1);
                                ret.put(filename, (Pair<Integer, Long>)new Pair((Object)version, (Object)timestamp));
                                notParsed = false;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!notParsed) continue;
                        LOG.warn("In blacklist at " + this.mySkeletonsPath + " strange line '" + line + "'");
                    } while (line != null);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeBlacklist(File skeletonDir, Map<String, Pair<Integer, Long>> blacklist) {
        File blacklistFile = new File(skeletonDir, BLACKLIST_FILE_NAME);
        try (PrintWriter output = new PrintWriter(blacklistFile);){
            output.println("# PyCharm failed to generate skeletons for these modules.");
            output.println("# These skeletons will be re-generated automatically");
            output.println("# when a newer module version or an updated generator becomes available.");
            for (String fname : blacklist.keySet()) {
                Pair<Integer, Long> data = blacklist.get(fname);
                output.print(fname);
                output.print(" = ");
                output.print(SkeletonVersionChecker.toVersionString((Integer)data.getFirst()));
                output.print(" ");
                output.print(data.getSecond());
                output.println();
            }
        }
        catch (IOException ex) {
            LOG.warn("Failed to store blacklist in " + skeletonDir.getPath(), (Throwable)ex);
        }
    }

    private static void removeBlacklist(File skeletonDir) {
        boolean okay;
        File blacklistFile = new File(skeletonDir, BLACKLIST_FILE_NAME);
        if (blacklistFile.exists() && !(okay = blacklistFile.delete())) {
            LOG.warn("Could not delete blacklist file in " + skeletonDir.getPath());
        }
    }

    private void cleanUpSkeletons(File dir) {
        this.indicateMinor(dir.getPath());
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File item : files) {
            boolean canLive;
            String itemName;
            if (item.isDirectory()) {
                boolean deleted;
                File lastFile;
                this.cleanUpSkeletons(item);
                File[] remaining = item.listFiles();
                if (remaining != null && remaining.length == 0) {
                    this.mySkeletonsGenerator.deleteOrLog(item);
                    continue;
                }
                if (remaining == null || remaining.length != 1 || !"__init__.py".equals((lastFile = remaining[0]).getName()) || lastFile.length() != 0L || !(deleted = this.mySkeletonsGenerator.deleteOrLog(lastFile))) continue;
                this.mySkeletonsGenerator.deleteOrLog(item);
                continue;
            }
            if (!item.isFile() || "__init__.py".equals(itemName = item.getName()) && item.length() == 0L || BLACKLIST_FILE_NAME.equals(itemName) || PythonSdkType.getBuiltinsFileName(this.mySdk).equals(itemName)) continue;
            SkeletonHeader header = PySkeletonRefresher.readSkeletonHeader(item);
            boolean bl = canLive = header != null;
            if (canLive) {
                String binaryFile = header.getBinaryFile();
                boolean bl2 = canLive = "(pre-generated)".equals(binaryFile) || "(built-in)".equals(binaryFile) || this.mySkeletonsGenerator.exists(binaryFile);
            }
            if (canLive) continue;
            this.mySkeletonsGenerator.deleteOrLog(item);
        }
    }

    private List<UpdateResult> updateOrCreateSkeletons(Map<String, PyBinaryItem> modules) throws InvalidSdkException {
        long startTime = System.currentTimeMillis();
        ArrayList names = Lists.newArrayList(modules.keySet());
        Collections.sort(names);
        ArrayList<UpdateResult> results = new ArrayList<UpdateResult>();
        int count = names.size();
        if (this.myIndicator != null) {
            this.myIndicator.setIndeterminate(false);
        }
        for (int i = 0; i < count; ++i) {
            String name;
            PyBinaryItem module2;
            this.checkCanceled();
            if (this.myIndicator != null) {
                this.myIndicator.setFraction((double)i / (double)count);
            }
            if ((module2 = modules.get(name = (String)names.get(i))) == null) continue;
            this.updateOrCreateSkeleton(module2, results);
        }
        this.finishSkeletonsGeneration();
        long doneInMs = System.currentTimeMillis() - startTime;
        LOG.info("Rebuilding skeletons for binaries took " + doneInMs + " ms");
        return results;
    }

    private void finishSkeletonsGeneration() {
        this.mySkeletonsGenerator.finishSkeletonsGeneration();
    }

    private static File getSkeleton(String moduleName, String skeletonsPath) {
        File module2 = PySkeletonRefresher.getModuleSkeleton(moduleName, skeletonsPath);
        return module2.exists() ? module2 : PySkeletonRefresher.getPackageSkeleton(moduleName, skeletonsPath);
    }

    private static File getModuleSkeleton(String module2, String skeletonsPath) {
        String modulePath = module2.replace('.', '/');
        return new File(skeletonsPath, modulePath + ".py");
    }

    private static File getPackageSkeleton(String pkg, String skeletonsPath) {
        String packagePath = pkg.replace('.', '/');
        return new File(new File(skeletonsPath, packagePath), "__init__.py");
    }

    private void updateOrCreateSkeleton(PyBinaryItem binaryItem, List<UpdateResult> errorList) throws InvalidSdkException {
        Pair<Integer, Long> versionInfo;
        String moduleName = binaryItem.getModule();
        File skeleton = PySkeletonRefresher.getSkeleton(moduleName, this.getSkeletonsPath());
        SkeletonHeader header = PySkeletonRefresher.readSkeletonHeader(skeleton);
        boolean mustRebuild = true;
        if (header != null) {
            int requiredVersion = this.myVersionChecker.getRequiredVersion(moduleName);
            boolean bl = mustRebuild = header.getVersion() < requiredVersion;
        }
        if (!mustRebuild) {
            boolean bl = mustRebuild = skeleton.exists() && binaryItem.lastModified() > skeleton.lastModified();
        }
        if (this.myBlacklist != null && (versionInfo = this.myBlacklist.get(binaryItem.getPath())) != null) {
            int failedGeneratorVersion = (Integer)versionInfo.getFirst();
            long failedTimestamp = (Long)versionInfo.getSecond();
            if (!(mustRebuild &= failedGeneratorVersion < this.myGeneratorVersion || failedTimestamp < binaryItem.lastModified())) {
                errorList.add(new UpdateResult(moduleName, binaryItem.getPath(), binaryItem.lastModified(), false));
            }
        }
        if (mustRebuild) {
            this.indicateMinor(moduleName);
            if (this.myPregeneratedSkeletons != null && this.myPregeneratedSkeletons.copyPregeneratedSkeleton(moduleName, this.getSkeletonsPath())) {
                return;
            }
            LOG.info("Skeleton for " + moduleName);
            this.generateSkeleton(moduleName, binaryItem.getPath(), null, (Consumer<Boolean>)((Consumer)generated -> {
                if (!generated.booleanValue()) {
                    errorList.add(new UpdateResult(moduleName, binaryItem.getPath(), binaryItem.lastModified(), true));
                }
            }));
        }
    }

    public void generateSkeleton(@NotNull String modname, @Nullable String modfilename, @Nullable List<String> assemblyRefs, Consumer<Boolean> resultConsumer) throws InvalidSdkException {
        if (modname == null) {
            PySkeletonRefresher.$$$reportNull$$$0(8);
        }
        this.mySkeletonsGenerator.generateSkeleton(modname, modfilename, assemblyRefs, this.getExtraSyspath(), this.mySdk.getHomePath(), resultConsumer);
    }

    private String getExtraSyspath() {
        if (this.myExtraSyspath == null) {
            this.myExtraSyspath = PySkeletonRefresher.calculateExtraSysPath(this.mySdk, this.mySkeletonsPath);
        }
        return this.myExtraSyspath;
    }

    public int getGeneratorVersion() {
        return this.myGeneratorVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedSdks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modname";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refreshSkeletonsOfSdk";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logErrors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateExtraSysPath";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readSkeletonHeader";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateSkeleton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyBinaryItem {
        private String myPath;
        private String myModule;
        private long myLength;
        private long myLastModified;

        PyBinaryItem(String module2, String path, long length, long lastModified) {
            this.myPath = path;
            this.myModule = module2;
            this.myLength = length;
            this.myLastModified = lastModified * 1000L;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getModule() {
            return this.myModule;
        }

        public long length() {
            return this.myLength;
        }

        public long lastModified() {
            return this.myLastModified;
        }
    }

    private static class UpdateResult {
        private final String myPath;
        private final String myName;
        private final long myTimestamp;
        private final boolean myIsFresh;

        public boolean isFresh() {
            return this.myIsFresh;
        }

        private UpdateResult(String name, String path, long timestamp, boolean fresh) {
            this.myName = name;
            this.myPath = path;
            this.myTimestamp = timestamp;
            this.myIsFresh = fresh;
        }

        public String getName() {
            return this.myName;
        }

        public String getPath() {
            return this.myPath;
        }

        public Long getTimestamp() {
            return this.myTimestamp;
        }
    }

    public static class SkeletonHeader {
        @NotNull
        private final String myFile;
        private final int myVersion;

        public SkeletonHeader(@NotNull String binaryFile, int version) {
            if (binaryFile == null) {
                SkeletonHeader.$$$reportNull$$$0(0);
            }
            this.myFile = binaryFile;
            this.myVersion = version;
        }

        @NotNull
        public String getBinaryFile() {
            String string = this.myFile;
            if (string == null) {
                SkeletonHeader.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getVersion() {
            return this.myVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher$SkeletonHeader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher$SkeletonHeader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinaryFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

