/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.converters;

import com.google.common.collect.ImmutableMap;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.RunManagerSettings;
import com.jetbrains.python.PyBundle;
import org.jdom.Element;

public class PythonTestRunConfigurationsConverter
extends ConversionProcessor<RunManagerSettings> {
    private static ImmutableMap<String, String> ourTypeToFactoryNameMap = ImmutableMap.builder().put((Object)"PythonUnitTestConfigurationType", (Object)PyBundle.message("runcfg.unittest.display_name", new Object[0])).put((Object)"PythonDocTestRunConfigurationType", (Object)PyBundle.message("runcfg.doctest.display_name", new Object[0])).put((Object)"PythonNoseTestRunConfigurationType", (Object)PyBundle.message("runcfg.nosetests.display_name", new Object[0])).put((Object)"py.test", (Object)PyBundle.message("runcfg.pytest.display_name", new Object[0])).build();

    @Override
    public boolean isConversionNeeded(RunManagerSettings runManagerSettings) {
        for (Element element : runManagerSettings.getRunConfigurations()) {
            if (!PythonTestRunConfigurationsConverter.isConversionNeeded(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(RunManagerSettings runManagerSettings) throws CannotConvertException {
        for (Element element : runManagerSettings.getRunConfigurations()) {
            String confType = element.getAttributeValue("type");
            String factoryName = (String)ourTypeToFactoryNameMap.get((Object)confType);
            if (factoryName == null) continue;
            element.setAttribute("type", "tests");
            element.setAttribute("factoryName", factoryName);
        }
    }

    private static boolean isConversionNeeded(Element element) {
        String confType = element.getAttributeValue("type");
        return ourTypeToFactoryNameMap.containsKey((Object)confType);
    }
}

