/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.search;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ImageTags", storages={@Storage(value="imageTags.xml")})
public class ImageTagManager
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static ImageTagManager getInstance(Project project) {
        return (ImageTagManager)ServiceManager.getService((Project)project, ImageTagManager.class);
    }

    public boolean hasTag(String tag, VirtualFile file2) {
        State.Files files = this.myState.myTags.get(tag);
        return files != null && files.contains(file2.getPath());
    }

    public void addTag(String tag, VirtualFile file2) {
        State.Files files = this.myState.myTags.get(tag);
        if (files == null) {
            files = new State.Files();
            this.myState.myTags.put(tag, files);
        }
        files.add(file2.getPath());
    }

    public void removeTag(String tag, VirtualFile file2) {
        State.Files files = this.myState.myTags.get(tag);
        if (files != null) {
            files.remove(file2.getPath());
        }
    }

    public List<String> getTags(VirtualFile file2) {
        return this.myState.myTags.keySet().stream().filter(tag -> this.hasTag((String)tag, file2)).collect(Collectors.toList());
    }

    public List<String> getAllTags() {
        return new ArrayList<String>(this.myState.myTags.keySet());
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state2) {
        this.myState = state2;
    }

    public static class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundKeyWithTag=false, surroundWithTag=false, entryTagName="tag", keyAttributeName="name", valueAttributeName="values")
        public final Map<String, Files> myTags = new LinkedHashMap<String, Files>();

        @Property(surroundWithTag=false)
        @Tag(value="files")
        public static class Files {
            @Property(surroundWithTag=false)
            @AbstractCollection(surroundWithTag=false, elementTag="file", elementValueAttribute="path")
            public final Set<String> myFiles = new LinkedHashSet<String>();

            public void remove(String path) {
                this.myFiles.remove(path);
            }

            public void add(String path) {
                this.myFiles.add(path);
            }

            public boolean contains(String path) {
                return this.myFiles.contains(path);
            }
        }
    }
}

